<?php
//test
//
//header("Access-Control-Allow-Credentials: true");
$allowedOrigins = [
    "http://student.pragjyotishcollege.ac.in",
    "https://student.pragjyotishcollege.ac.in",
    "http://localhost:3000",
    "http://localhost:3001",
    "http://localhost:3002",
    "http://localhost:3003",
    "http://localhost:5000",
    "http://192.168.43.229:3000",
    "http://192.168.43.229:3001",
    "http://192.168.43.229:3002",
    "http://192.168.43.229:3003",
];

if (in_array($_SERVER["HTTP_ORIGIN"], $allowedOrigins)) {
    header("Access-Control-Allow-Origin: " . $_SERVER["HTTP_ORIGIN"]);
}
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Unit, Authorization");
//header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization");
//
if($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
   header( "HTTP/1.1 200 OK" );
   exit();
}  
// --(REMOVE THE ABOVE CODE IN PRODUCTION SERVER) --> Place-3 
// 

date_default_timezone_set("Asia/Kolkata");



//history enabling and disabling can be done here 
define('SITE_HISTORY_KEEPING', 'ENABLED');  
    //put 'DISABLED' to skip history storing, and put 'ENABLED' to keep data in history 



require __DIR__ . '/../vendor/autoload.php';







// Instantiate the app
require __DIR__ . '/../src/config.php';
$app = new \Slim\App(['settings' => $config]);

// Set up dependencies
require __DIR__ . '/../src/dependencies.php';

// Set up authentication routes
require __DIR__ . '/../src/routes/auth.php';

// Register middleware
require __DIR__ . '/../src/middleware.php';

// we will need utilities 
require __DIR__ . '/../src/utility.php';
require __DIR__ . '/../src/routes/generaluser.php';
require __DIR__ . '/../src/routes/student.php';
require __DIR__ . '/../src/routes/attendance.php';
require __DIR__ . '/../src/routes/routine.php';
require __DIR__ . '/../src/routes/initialisation.php';
require __DIR__ . '/../src/routes/section.php';
require __DIR__ . '/../src/routes/reports.php';
require __DIR__ . '/../src/routes/notifications.php';
require __DIR__ . '/../src/routes/feedback_category.php';
require __DIR__ . '/../src/routes/feedback_question.php';
require __DIR__ . '/../src/routes/feedback_session.php';
require __DIR__ . '/../src/routes/feedbacks.php';
require __DIR__ . '/../src/routes/student_feedback.php';
require __DIR__ . '/../src/routes/classtest.php';


require __DIR__ . '/../src/routes/assignments.php';


require __DIR__ . '/../src/routes/class_notes.php';
require __DIR__ . '/../src/routes/activities.php';







/**
 * Verifying required params posted or not
 */
function verifyRequiredParams($required_fields,$request_params) {
    $error = false;
    $error_fields = "";
    foreach ($required_fields as $field) {
        if (!isset($request_params->$field) || strlen(trim($request_params->$field)) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }
    if ($error) {  // 
        return $error_fields;
    } else {
        return false;
    }
}



$app->run();
