<?php
// Import PHPMailer classes into the global namespace
// These must be at the top of your script, not inside a function
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//Load Composer's autoloader
//require 'vendor/autoload.php';

class SendMailer{

    public function sendMail($address,$subject,$message,$from, $from_name){
        $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
        try {
            //Server settings
            $mail->SMTPDebug = 2;                                   // Enable verbose debug output
            $mail->isSMTP();                                        // Set mailer to use SMTP
            $mail->Host = 'smtp.gmail.com';                         // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                                 // Enable SMTP authentication
            $mail->Username = getenv('HTTP_MY_EMAIL');              // SMTP username
            $mail->Password = getenv('HTTP_MY_PASSWORD');           // SMTP password
            $mail->SMTPSecure = 'tls';                              // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 587;                                      // TCP port to connect to

            //Recipients
            $mail->setFrom($from, $from_name);         // Add a recipient
            $mail->addAddress($address);                            // Name is optional
            $mail->addReplyTo($from, 'Information');
            $mail->addCC('info@corexx.in');

            /*//Attachments
            $mail->addAttachment('/var/tmp/file.tar.gz');         // Add attachments
            $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name*/

            //Content
            $mail->isHTML(true);                                  // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body    = $message;
            $mail->AltBody = 'This is a autogenerated mail. Please donot reply';

            $mail->send();
            return 'sent';
        } catch (Exception $e) {
            return 'Message could not be sent. Mailer Error: '.$mail->ErrorInfo;
        }

}
}