<?php

// Application middleware

// e.g: $app->add(new \Slim\Csrf\Guard);

$app->add(new Tuupola\Middleware\JwtAuthentication([
    "secret" => $container['env_values']['MY_SECRET'],
    "ignore" => [
         "/signup",
        "/forgotpassword",
        "/forgotpassword/otp",
        "/forgotpassword/final",
        "/resendotp",
        "/forgotpassworda",
        "/forgotpassworda/otp",
        "/forgotpassworda/final",
        "/auth/login",
        "/generaluser/login",
        "/generaluser/logintemp",
        "/collegeuser/login",
        "/findstudentdatalist",
        "/updatenewsubjects"
    ],
    "before" => function ($request, $arguments) use ($container) {
        $token = $arguments['decoded'];
        $container['accesslog']->debug('A. '.$token['sub']->email.' M. '.$request->getMethod().' P. '.$request->getUri());
    },
    "error" => function ($response, $arguments) {
        $data["status"] = "401";
        $data["statusType"] = "error";
        $data["message"] = $arguments["message"];
        return $response
            ->withHeader("Content-Type", "application/json")
            ->write(json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT))
            ->withStatus(401);
    }
]));
