<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="ActivityRepository") @Table(name="activity")
 */

class Activity
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $activity_type;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $activity_name;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $event_date;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $entry_date;

    /**
     * @Column(type="string",length=300, nullable=true)
     */
    protected $activity_title;

    /**
     * @Column(type="text", nullable=true)
     */
    protected $description;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $created_by;

    /**
     * @Column(type="json_array", nullable=true)
     */
    protected $upload_info;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $time_stamp;


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set activityType.
     *
     * @param string|null $activityType
     *
     * @return Activity
     */
    public function setActivityType($activityType = null)
    {
        $this->activity_type = $activityType;

        return $this;
    }

    /**
     * Get activityType.
     *
     * @return string|null
     */
    public function getActivityType()
    {
        return $this->activity_type;
    }

    /**
     * Set activityName.
     *
     * @param string|null $activityName
     *
     * @return Activity
     */
    public function setActivityName($activityName = null)
    {
        $this->activity_name = $activityName;

        return $this;
    }

    /**
     * Get activityName.
     *
     * @return string|null
     */
    public function getActivityName()
    {
        return $this->activity_name;
    }

    /**
     * Set eventDate.
     *
     * @param string|null $eventDate
     *
     * @return Activity
     */
    public function setEventDate($eventDate = null)
    {
        $this->event_date = $eventDate;

        return $this;
    }

    /**
     * Get eventDate.
     *
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->event_date;
    }

    /**
     * Set entryDate.
     *
     * @param string|null $entryDate
     *
     * @return Activity
     */
    public function setEntryDate($entryDate = null)
    {
        $this->entry_date = $entryDate;

        return $this;
    }

    /**
     * Get entryDate.
     *
     * @return string|null
     */
    public function getEntryDate()
    {
        return $this->entry_date;
    }

    /**
     * Set activityTitle.
     *
     * @param string|null $activityTitle
     *
     * @return Activity
     */
    public function setActivityTitle($activityTitle = null)
    {
        $this->activity_title = $activityTitle;

        return $this;
    }

    /**
     * Get activityTitle.
     *
     * @return string|null
     */
    public function getActivityTitle()
    {
        return $this->activity_title;
    }

    /**
     * Set description.
     *
     * @param string|null $description
     *
     * @return Activity
     */
    public function setDescription($description = null)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description.
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set createdBy.
     *
     * @param string|null $createdBy
     *
     * @return Activity
     */
    public function setCreatedBy($createdBy = null)
    {
        $this->created_by = $createdBy;

        return $this;
    }

    /**
     * Get createdBy.
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->created_by;
    }

    /**
     * Set uploadInfo.
     *
     * @param array|null $uploadInfo
     *
     * @return Activity
     */
    public function setUploadInfo($uploadInfo = null)
    {
        $this->upload_info = $uploadInfo;

        return $this;
    }

    /**
     * Get uploadInfo.
     *
     * @return array|null
     */
    public function getUploadInfo()
    {
        return $this->upload_info;
    }

    /**
     * Set timeStamp.
     *
     * @param string|null $timeStamp
     *
     * @return Activity
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->time_stamp = $timeStamp;

        return $this;
    }

    /**
     * Get timeStamp.
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->time_stamp;
    }
}
