<?php

use Doctrine\ORM\EntityRepository;

class ActivityRepository extends EntityRepository
{

    public function getActivities($activity_type){
        $a = array('Summer/Winter internship/training programme','Seminar/Webinar/Conference participation','Competitive examination/test qualified, if any','Science/Arts Exhibition Participation','Publications in books/journals/magazines etc.','Command on ICT tools');
        $b = array('Debate & Quiz Competition (Winner)','Singing/Dancing Competition (Winner)','Sports (Winner)','Others');
        if($activity_type=='academic')
        return $a;
        else if($activity_type=='curricular')
        return $b;
        else if($activity_type=='all'){
            $c = array_merge($a,$b);
            return $c;
        }
    }

    public function addActivity($body){
        $em = $this->getEntityManager();
        $activity_type = addslashes(strip_tags(trim($body['activity_type'])));
        $activity_name = addslashes(strip_tags(trim($body['activity_name'])));
        $activity_title = addslashes(strip_tags(trim($body['activity_title'])));
        $description = addslashes(strip_tags(trim($body['description'])));
        $event_date = addslashes(strip_tags(trim($body['event_date'])));
        $created_by = addslashes(strip_tags(trim($body['username'])));
        $entry_date = date('d-m-Y');
        $time_stamp = date('d-m-Y H:i:s');

         //store the photo

         require_once __DIR__ . '/../utility.php';
         $ut = new StorePhoto();
 
         if (sizeof($body['upload_info']) > 0) {
             $upload_info = $ut->setPhoto($body['upload_info'], 'ACTIVITY');
         } else {
             $upload_info = [];
         }

        $obj = new Activity();
        $obj->setActivityType($activity_type);
        $obj->setActivityName($activity_name);
        $obj->setActivityTitle($activity_title);
        $obj->setDescription($description);
        $obj->setEventDate($event_date);
        $obj->setUploadInfo($upload_info);
        $obj->setEntryDate($entry_date);
        $obj->setTimeStamp($time_stamp);
        $obj->setCreatedBy($created_by);
        $em->persist($obj);
        $em->flush();
        if(null !=$obj->getId()){
            return true;
        }
        else return false;
    }
    
    public function getMyActivity($created_by,$activity_type){
        $em = $this->getEntityManager();
        $dql = "SELECT r.id,r.activity_type,r.activity_name,r.activity_title,r.description,r.event_date,r.upload_info,r.entry_date,r.time_stamp,r.created_by FROM Activity r WHERE r.activity_type=:activity_type AND r.created_by=:created_by ORDER BY r.id DESC";
        $query = $em->createQuery($dql)->setParameter('activity_type',$activity_type)->setParameter('created_by',$created_by);
        return $query->getResult();
    }
}
