<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="AdmissionFormRepository") @Table(name="admission_form")
 */

class AdmissionForm
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="integer",nullable=true,options={"default" : 0})
     */
    protected $form_id;

    /**
     * @Column(type="integer",length=4,nullable=true,options={"default" : 0})
     */
    protected $active_step;

    /**
     * @Column(type="integer",nullable=true,options={"default" : 0})
     */
    protected $class_id;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $class_name;

     /**
     * @Column(type="integer",nullable=true,options={"default" : 0})
     */
    protected $is_free_admission;

    /**
     * @Column(type="integer",nullable=true,options={"default" : 0})
     */
    protected $no_combo_course;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $total_marks;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $marks_obtained;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $percentage;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $office_use;

    /**
     * @Column(type="string",length=100)
     */
    protected $name;


    /**
     * @Column(type="string",length=100)
     */
    protected $email;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $father_name;


    /**
     * @Column(type="string",length=120,nullable=true)
     */
    protected $father_email;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $mother_name;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $mother_phone;

        /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $father_qualification;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $mother_qualification;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $father_profession;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $mother_profession;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $father_phone;


    /**
     * @Column(type="string",length=20,nullable=true)
     */
    protected $gender;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $caste;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $date_of_birth;

    /**
     * @Column(type="string",length=15)
     */
    protected $phone;

    /**
     * @Column(type="string",length=500,nullable=true)
     */
    protected $p_occupation;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $quota;

     /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $state;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $religion;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $nationality;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $blood_group;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $maratial_status;


    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $local_g_phone;


    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $mother_toungue;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $languages_known;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $has_hostel;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $last_exam_passed;


    /**
     * @Column(type="text",nullable=true)
     */
    protected $last_exam_year;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $last_exam_total;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $last_exam_obtained;


    /**
     * @Column(type="text",nullable=true)
     */
    protected $last_exam_percentage;


    /**
     * @Column(type="text",nullable=true)
     */
    protected $last_exam_university;


    /**
     * @Column(type="text",nullable=true)
     */
    protected $last_exam_college;

    /**
     * @Column(type="string", length=30,nullable=true)
     */
    protected $ranking_score;

    /**
     * @Column(type="string", length=30,nullable=true)
     */
    protected $ranking_serial;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $annual_income;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $university_roll_no;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $roll_no;


    /**
     * @Column(type="string",length=20,nullable=true)
     */
    protected $is_pwd;

    /**
     * @Column(type="string",length=20,nullable=true)
     */
    protected $is_ews;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $exam_passed;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $best_subjects;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $last_marks;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $major_1;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $major_2;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $compulsory_1;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $compulsory_2;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $compulsory_3;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $mil;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $generic_1;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $generic_2;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $generic_3;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $final_major;


    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $final_generic;

    /**
     * @Column(type="integer",length=10,nullable=true)
     */
    protected $subject_comb;


    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $optional_subjects;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $course_type;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $stream;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $dept_code;


    /**
     * @Column(type="integer",length=11,nullable=true)
     */
    protected $semester;

    
    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */
    protected $session_id;

    
    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $date_of_admission;


    /**
     * @Column(type="string",length=200,nullable=true)
     */
    protected $account_holder;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $account_no;

    /**
     * @Column(type="string",length=150,nullable=true)
     */
    protected $account_bank;


    /**
     * @Column(type="string",length=150,nullable=true)
     */
    protected $account_branch;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $account_ifsc;


    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $account_micr;

     

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $present_address;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $permanent_address;


     /**
     * @Column(type="json_array",nullable=true)
     */
     protected $local_address;



    /**
     * @Column(type="string",length=500,nullable=true)
     */
    protected $local_g;

     /**
     * @Column(type="string",length=500,nullable=true)
     */
    protected $extra_curr;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $dp;


    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $signature;


    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $g_signature;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $certificate;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $marksheet;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $income;


    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $bpl;


    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $tree;


    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $unique_ack;


     /**
     * @Column(type="json_array",nullable=true)
     */

    protected $age_proof;

     /**
     * @Column(type="json_array",nullable=true)
     */

    protected $bank_details;

     /**
     * @Column(type="json_array",nullable=true)
     */

    protected $other_certificate;


     /**
     * @Column(type="json_array",nullable=true)
     */

    protected $gap_certificate;


     /**
     * @Column(type="json_array",nullable=true)
     */

    protected $caste_certificate;


     /**
     * @Column(type="json_array",nullable=true)
     */

    protected $domicile_certificate;


    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $pwd_certificate;


    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $fees_receipt;

    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */

    protected $is_del;

    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */

    protected $is_submit;


    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */

    protected $is_complete;

    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */

    protected $payment_status;

    
    /**
     * @Column(type="text",nullable=true)
     */

    protected $transaction;


     /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */

    protected $admission_done;

    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */

    protected $admission_payment_done;

    /**
     * @Column(type="integer",length=20,nullable=true)
     */

    protected $student_id;


    /**
     * @Column(type="integer",length=2,nullable=true,options={"default":0} )
     */

    protected $admission_type;

    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */

    protected $is_verified=0;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $verified_on;


    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $verified_by;


    /**
     * @Column(type="text",nullable=true)
     */
    protected $rejection_reason;


    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */
    protected $is_admitted=0;


    /**
     * @Column(type="integer",nullable=true)
     */
    protected $request_id;


    /**
     * @Column(type="string", length=100,nullable=true)
     */
    protected $request_type;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $unique_id;


    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $college_id;

     /**
     * @Column(type="string", length=20, nullable=true)
     */

    protected $other_college;

     /**
     * @Column(type="json_array",nullable=true)
     */
    protected $activities;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $subjects_choosen;


    /**
     * @Column(type="string",length=20,nullable=true)
     */
    protected $has_gap;


    /**
     * @Column(type="string",length=20,nullable=true)
     */
    protected $gap_admission;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $gap_course;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $gap_institute;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $gap_roll_no;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $gap_reason;


     /**
     * @Column(type="json_array",nullable=true)
     */
    protected $documents_required;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $documents_uploaded;

     /**
     * @Column(type="string",length=100,options={"default":0})
     */
    protected $admission_amount_paid=0;


    /**
     * @Column(type="string",length=100)
     */
    protected $primary_email;

   

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set formId.
     *
     * @param int|null $formId
     *
     * @return AdmissionForm
     */
    public function setFormId($formId = null)
    {
        $this->form_id = $formId;

        return $this;
    }

    /**
     * Get formId.
     *
     * @return int|null
     */
    public function getFormId()
    {
        return $this->form_id;
    }

    /**
     * Set activeStep.
     *
     * @param int|null $activeStep
     *
     * @return AdmissionForm
     */
    public function setActiveStep($activeStep = null)
    {
        $this->active_step = $activeStep;

        return $this;
    }

    /**
     * Get activeStep.
     *
     * @return int|null
     */
    public function getActiveStep()
    {
        return $this->active_step;
    }

    /**
     * Set classId.
     *
     * @param int|null $classId
     *
     * @return AdmissionForm
     */
    public function setClassId($classId = null)
    {
        $this->class_id = $classId;

        return $this;
    }

    /**
     * Get classId.
     *
     * @return int|null
     */
    public function getClassId()
    {
        return $this->class_id;
    }

    /**
     * Set className.
     *
     * @param string|null $className
     *
     * @return AdmissionForm
     */
    public function setClassName($className = null)
    {
        $this->class_name = $className;

        return $this;
    }

    /**
     * Get className.
     *
     * @return string|null
     */
    public function getClassName()
    {
        return $this->class_name;
    }

    /**
     * Set isFreeAdmission.
     *
     * @param int|null $isFreeAdmission
     *
     * @return AdmissionForm
     */
    public function setIsFreeAdmission($isFreeAdmission = null)
    {
        $this->is_free_admission = $isFreeAdmission;

        return $this;
    }

    /**
     * Get isFreeAdmission.
     *
     * @return int|null
     */
    public function getIsFreeAdmission()
    {
        return $this->is_free_admission;
    }

    /**
     * Set noComboCourse.
     *
     * @param int|null $noComboCourse
     *
     * @return AdmissionForm
     */
    public function setNoComboCourse($noComboCourse = null)
    {
        $this->no_combo_course = $noComboCourse;

        return $this;
    }

    /**
     * Get noComboCourse.
     *
     * @return int|null
     */
    public function getNoComboCourse()
    {
        return $this->no_combo_course;
    }

    /**
     * Set totalMarks.
     *
     * @param string|null $totalMarks
     *
     * @return AdmissionForm
     */
    public function setTotalMarks($totalMarks = null)
    {
        $this->total_marks = $totalMarks;

        return $this;
    }

    /**
     * Get totalMarks.
     *
     * @return string|null
     */
    public function getTotalMarks()
    {
        return $this->total_marks;
    }

    /**
     * Set marksObtained.
     *
     * @param string|null $marksObtained
     *
     * @return AdmissionForm
     */
    public function setMarksObtained($marksObtained = null)
    {
        $this->marks_obtained = $marksObtained;

        return $this;
    }

    /**
     * Get marksObtained.
     *
     * @return string|null
     */
    public function getMarksObtained()
    {
        return $this->marks_obtained;
    }

    /**
     * Set percentage.
     *
     * @param string|null $percentage
     *
     * @return AdmissionForm
     */
    public function setPercentage($percentage = null)
    {
        $this->percentage = $percentage;

        return $this;
    }

    /**
     * Get percentage.
     *
     * @return string|null
     */
    public function getPercentage()
    {
        return $this->percentage;
    }

    /**
     * Set officeUse.
     *
     * @param array|null $officeUse
     *
     * @return AdmissionForm
     */
    public function setOfficeUse($officeUse = null)
    {
        $this->office_use = $officeUse;

        return $this;
    }

    /**
     * Get officeUse.
     *
     * @return array|null
     */
    public function getOfficeUse()
    {
        return $this->office_use;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return AdmissionForm
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set email.
     *
     * @param string $email
     *
     * @return AdmissionForm
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email.
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set fatherName.
     *
     * @param string|null $fatherName
     *
     * @return AdmissionForm
     */
    public function setFatherName($fatherName = null)
    {
        $this->father_name = $fatherName;

        return $this;
    }

    /**
     * Get fatherName.
     *
     * @return string|null
     */
    public function getFatherName()
    {
        return $this->father_name;
    }

    /**
     * Set fatherEmail.
     *
     * @param string|null $fatherEmail
     *
     * @return AdmissionForm
     */
    public function setFatherEmail($fatherEmail = null)
    {
        $this->father_email = $fatherEmail;

        return $this;
    }

    /**
     * Get fatherEmail.
     *
     * @return string|null
     */
    public function getFatherEmail()
    {
        return $this->father_email;
    }

    /**
     * Set motherName.
     *
     * @param string|null $motherName
     *
     * @return AdmissionForm
     */
    public function setMotherName($motherName = null)
    {
        $this->mother_name = $motherName;

        return $this;
    }

    /**
     * Get motherName.
     *
     * @return string|null
     */
    public function getMotherName()
    {
        return $this->mother_name;
    }

    /**
     * Set motherPhone.
     *
     * @param string|null $motherPhone
     *
     * @return AdmissionForm
     */
    public function setMotherPhone($motherPhone = null)
    {
        $this->mother_phone = $motherPhone;

        return $this;
    }

    /**
     * Get motherPhone.
     *
     * @return string|null
     */
    public function getMotherPhone()
    {
        return $this->mother_phone;
    }

    /**
     * Set fatherQualification.
     *
     * @param string|null $fatherQualification
     *
     * @return AdmissionForm
     */
    public function setFatherQualification($fatherQualification = null)
    {
        $this->father_qualification = $fatherQualification;

        return $this;
    }

    /**
     * Get fatherQualification.
     *
     * @return string|null
     */
    public function getFatherQualification()
    {
        return $this->father_qualification;
    }

    /**
     * Set motherQualification.
     *
     * @param string|null $motherQualification
     *
     * @return AdmissionForm
     */
    public function setMotherQualification($motherQualification = null)
    {
        $this->mother_qualification = $motherQualification;

        return $this;
    }

    /**
     * Get motherQualification.
     *
     * @return string|null
     */
    public function getMotherQualification()
    {
        return $this->mother_qualification;
    }

    /**
     * Set fatherProfession.
     *
     * @param string|null $fatherProfession
     *
     * @return AdmissionForm
     */
    public function setFatherProfession($fatherProfession = null)
    {
        $this->father_profession = $fatherProfession;

        return $this;
    }

    /**
     * Get fatherProfession.
     *
     * @return string|null
     */
    public function getFatherProfession()
    {
        return $this->father_profession;
    }

    /**
     * Set motherProfession.
     *
     * @param string|null $motherProfession
     *
     * @return AdmissionForm
     */
    public function setMotherProfession($motherProfession = null)
    {
        $this->mother_profession = $motherProfession;

        return $this;
    }

    /**
     * Get motherProfession.
     *
     * @return string|null
     */
    public function getMotherProfession()
    {
        return $this->mother_profession;
    }

    /**
     * Set fatherPhone.
     *
     * @param string|null $fatherPhone
     *
     * @return AdmissionForm
     */
    public function setFatherPhone($fatherPhone = null)
    {
        $this->father_phone = $fatherPhone;

        return $this;
    }

    /**
     * Get fatherPhone.
     *
     * @return string|null
     */
    public function getFatherPhone()
    {
        return $this->father_phone;
    }

    /**
     * Set gender.
     *
     * @param string|null $gender
     *
     * @return AdmissionForm
     */
    public function setGender($gender = null)
    {
        $this->gender = $gender;

        return $this;
    }

    /**
     * Get gender.
     *
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Set caste.
     *
     * @param string|null $caste
     *
     * @return AdmissionForm
     */
    public function setCaste($caste = null)
    {
        $this->caste = $caste;

        return $this;
    }

    /**
     * Get caste.
     *
     * @return string|null
     */
    public function getCaste()
    {
        return $this->caste;
    }

    /**
     * Set dateOfBirth.
     *
     * @param string|null $dateOfBirth
     *
     * @return AdmissionForm
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        $this->date_of_birth = $dateOfBirth;

        return $this;
    }

    /**
     * Get dateOfBirth.
     *
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->date_of_birth;
    }

    /**
     * Set phone.
     *
     * @param string $phone
     *
     * @return AdmissionForm
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * Get phone.
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Set pOccupation.
     *
     * @param string|null $pOccupation
     *
     * @return AdmissionForm
     */
    public function setPOccupation($pOccupation = null)
    {
        $this->p_occupation = $pOccupation;

        return $this;
    }

    /**
     * Get pOccupation.
     *
     * @return string|null
     */
    public function getPOccupation()
    {
        return $this->p_occupation;
    }

    /**
     * Set quota.
     *
     * @param string|null $quota
     *
     * @return AdmissionForm
     */
    public function setQuota($quota = null)
    {
        $this->quota = $quota;

        return $this;
    }

    /**
     * Get quota.
     *
     * @return string|null
     */
    public function getQuota()
    {
        return $this->quota;
    }

    /**
     * Set state.
     *
     * @param string|null $state
     *
     * @return AdmissionForm
     */
    public function setState($state = null)
    {
        $this->state = $state;

        return $this;
    }

    /**
     * Get state.
     *
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set religion.
     *
     * @param string|null $religion
     *
     * @return AdmissionForm
     */
    public function setReligion($religion = null)
    {
        $this->religion = $religion;

        return $this;
    }

    /**
     * Get religion.
     *
     * @return string|null
     */
    public function getReligion()
    {
        return $this->religion;
    }

    /**
     * Set nationality.
     *
     * @param string|null $nationality
     *
     * @return AdmissionForm
     */
    public function setNationality($nationality = null)
    {
        $this->nationality = $nationality;

        return $this;
    }

    /**
     * Get nationality.
     *
     * @return string|null
     */
    public function getNationality()
    {
        return $this->nationality;
    }

    /**
     * Set bloodGroup.
     *
     * @param string|null $bloodGroup
     *
     * @return AdmissionForm
     */
    public function setBloodGroup($bloodGroup = null)
    {
        $this->blood_group = $bloodGroup;

        return $this;
    }

    /**
     * Get bloodGroup.
     *
     * @return string|null
     */
    public function getBloodGroup()
    {
        return $this->blood_group;
    }

    /**
     * Set maratialStatus.
     *
     * @param string|null $maratialStatus
     *
     * @return AdmissionForm
     */
    public function setMaratialStatus($maratialStatus = null)
    {
        $this->maratial_status = $maratialStatus;

        return $this;
    }

    /**
     * Get maratialStatus.
     *
     * @return string|null
     */
    public function getMaratialStatus()
    {
        return $this->maratial_status;
    }

    /**
     * Set localGPhone.
     *
     * @param string|null $localGPhone
     *
     * @return AdmissionForm
     */
    public function setLocalGPhone($localGPhone = null)
    {
        $this->local_g_phone = $localGPhone;

        return $this;
    }

    /**
     * Get localGPhone.
     *
     * @return string|null
     */
    public function getLocalGPhone()
    {
        return $this->local_g_phone;
    }

    /**
     * Set motherToungue.
     *
     * @param string|null $motherToungue
     *
     * @return AdmissionForm
     */
    public function setMotherToungue($motherToungue = null)
    {
        $this->mother_toungue = $motherToungue;

        return $this;
    }

    /**
     * Get motherToungue.
     *
     * @return string|null
     */
    public function getMotherToungue()
    {
        return $this->mother_toungue;
    }

    /**
     * Set languagesKnown.
     *
     * @param string|null $languagesKnown
     *
     * @return AdmissionForm
     */
    public function setLanguagesKnown($languagesKnown = null)
    {
        $this->languages_known = $languagesKnown;

        return $this;
    }

    /**
     * Get languagesKnown.
     *
     * @return string|null
     */
    public function getLanguagesKnown()
    {
        return $this->languages_known;
    }

    /**
     * Set hasHostel.
     *
     * @param string|null $hasHostel
     *
     * @return AdmissionForm
     */
    public function setHasHostel($hasHostel = null)
    {
        $this->has_hostel = $hasHostel;

        return $this;
    }

    /**
     * Get hasHostel.
     *
     * @return string|null
     */
    public function getHasHostel()
    {
        return $this->has_hostel;
    }

    /**
     * Set lastExamPassed.
     *
     * @param string|null $lastExamPassed
     *
     * @return AdmissionForm
     */
    public function setLastExamPassed($lastExamPassed = null)
    {
        $this->last_exam_passed = $lastExamPassed;

        return $this;
    }

    /**
     * Get lastExamPassed.
     *
     * @return string|null
     */
    public function getLastExamPassed()
    {
        return $this->last_exam_passed;
    }

    /**
     * Set lastExamYear.
     *
     * @param string|null $lastExamYear
     *
     * @return AdmissionForm
     */
    public function setLastExamYear($lastExamYear = null)
    {
        $this->last_exam_year = $lastExamYear;

        return $this;
    }

    /**
     * Get lastExamYear.
     *
     * @return string|null
     */
    public function getLastExamYear()
    {
        return $this->last_exam_year;
    }

    /**
     * Set lastExamTotal.
     *
     * @param string|null $lastExamTotal
     *
     * @return AdmissionForm
     */
    public function setLastExamTotal($lastExamTotal = null)
    {
        $this->last_exam_total = $lastExamTotal;

        return $this;
    }

    /**
     * Get lastExamTotal.
     *
     * @return string|null
     */
    public function getLastExamTotal()
    {
        return $this->last_exam_total;
    }

    /**
     * Set lastExamObtained.
     *
     * @param string|null $lastExamObtained
     *
     * @return AdmissionForm
     */
    public function setLastExamObtained($lastExamObtained = null)
    {
        $this->last_exam_obtained = $lastExamObtained;

        return $this;
    }

    /**
     * Get lastExamObtained.
     *
     * @return string|null
     */
    public function getLastExamObtained()
    {
        return $this->last_exam_obtained;
    }

    /**
     * Set lastExamPercentage.
     *
     * @param string|null $lastExamPercentage
     *
     * @return AdmissionForm
     */
    public function setLastExamPercentage($lastExamPercentage = null)
    {
        $this->last_exam_percentage = $lastExamPercentage;

        return $this;
    }

    /**
     * Get lastExamPercentage.
     *
     * @return string|null
     */
    public function getLastExamPercentage()
    {
        return $this->last_exam_percentage;
    }

    /**
     * Set lastExamUniversity.
     *
     * @param string|null $lastExamUniversity
     *
     * @return AdmissionForm
     */
    public function setLastExamUniversity($lastExamUniversity = null)
    {
        $this->last_exam_university = $lastExamUniversity;

        return $this;
    }

    /**
     * Get lastExamUniversity.
     *
     * @return string|null
     */
    public function getLastExamUniversity()
    {
        return $this->last_exam_university;
    }

    /**
     * Set lastExamCollege.
     *
     * @param string|null $lastExamCollege
     *
     * @return AdmissionForm
     */
    public function setLastExamCollege($lastExamCollege = null)
    {
        $this->last_exam_college = $lastExamCollege;

        return $this;
    }

    /**
     * Get lastExamCollege.
     *
     * @return string|null
     */
    public function getLastExamCollege()
    {
        return $this->last_exam_college;
    }

    /**
     * Set rankingScore.
     *
     * @param string|null $rankingScore
     *
     * @return AdmissionForm
     */
    public function setRankingScore($rankingScore = null)
    {
        $this->ranking_score = $rankingScore;

        return $this;
    }

    /**
     * Get rankingScore.
     *
     * @return string|null
     */
    public function getRankingScore()
    {
        return $this->ranking_score;
    }

    /**
     * Set rankingSerial.
     *
     * @param string|null $rankingSerial
     *
     * @return AdmissionForm
     */
    public function setRankingSerial($rankingSerial = null)
    {
        $this->ranking_serial = $rankingSerial;

        return $this;
    }

    /**
     * Get rankingSerial.
     *
     * @return string|null
     */
    public function getRankingSerial()
    {
        return $this->ranking_serial;
    }

    /**
     * Set annualIncome.
     *
     * @param string|null $annualIncome
     *
     * @return AdmissionForm
     */
    public function setAnnualIncome($annualIncome = null)
    {
        $this->annual_income = $annualIncome;

        return $this;
    }

    /**
     * Get annualIncome.
     *
     * @return string|null
     */
    public function getAnnualIncome()
    {
        return $this->annual_income;
    }

    /**
     * Set universityRollNo.
     *
     * @param string|null $universityRollNo
     *
     * @return AdmissionForm
     */
    public function setUniversityRollNo($universityRollNo = null)
    {
        $this->university_roll_no = $universityRollNo;

        return $this;
    }

    /**
     * Get universityRollNo.
     *
     * @return string|null
     */
    public function getUniversityRollNo()
    {
        return $this->university_roll_no;
    }

    /**
     * Set rollNo.
     *
     * @param string|null $rollNo
     *
     * @return AdmissionForm
     */
    public function setRollNo($rollNo = null)
    {
        $this->roll_no = $rollNo;

        return $this;
    }

    /**
     * Get rollNo.
     *
     * @return string|null
     */
    public function getRollNo()
    {
        return $this->roll_no;
    }

    /**
     * Set isPwd.
     *
     * @param string|null $isPwd
     *
     * @return AdmissionForm
     */
    public function setIsPwd($isPwd = null)
    {
        $this->is_pwd = $isPwd;

        return $this;
    }

    /**
     * Get isPwd.
     *
     * @return string|null
     */
    public function getIsPwd()
    {
        return $this->is_pwd;
    }

    /**
     * Set examPassed.
     *
     * @param array|null $examPassed
     *
     * @return AdmissionForm
     */
    public function setExamPassed($examPassed = null)
    {
        $this->exam_passed = $examPassed;

        return $this;
    }

    /**
     * Get examPassed.
     *
     * @return array|null
     */
    public function getExamPassed()
    {
        return $this->exam_passed;
    }

    /**
     * Set bestSubjects.
     *
     * @param array|null $bestSubjects
     *
     * @return AdmissionForm
     */
    public function setBestSubjects($bestSubjects = null)
    {
        $this->best_subjects = $bestSubjects;

        return $this;
    }

    /**
     * Get bestSubjects.
     *
     * @return array|null
     */
    public function getBestSubjects()
    {
        return $this->best_subjects;
    }

    /**
     * Set lastMarks.
     *
     * @param array|null $lastMarks
     *
     * @return AdmissionForm
     */
    public function setLastMarks($lastMarks = null)
    {
        $this->last_marks = $lastMarks;

        return $this;
    }

    /**
     * Get lastMarks.
     *
     * @return array|null
     */
    public function getLastMarks()
    {
        return $this->last_marks;
    }

    /**
     * Set major1.
     *
     * @param array|null $major1
     *
     * @return AdmissionForm
     */
    public function setMajor1($major1 = null)
    {
        $this->major_1 = $major1;

        return $this;
    }

    /**
     * Get major1.
     *
     * @return array|null
     */
    public function getMajor1()
    {
        return $this->major_1;
    }

    /**
     * Set major2.
     *
     * @param array|null $major2
     *
     * @return AdmissionForm
     */
    public function setMajor2($major2 = null)
    {
        $this->major_2 = $major2;

        return $this;
    }

    /**
     * Get major2.
     *
     * @return array|null
     */
    public function getMajor2()
    {
        return $this->major_2;
    }

    /**
     * Set compulsory1.
     *
     * @param array|null $compulsory1
     *
     * @return AdmissionForm
     */
    public function setCompulsory1($compulsory1 = null)
    {
        $this->compulsory_1 = $compulsory1;

        return $this;
    }

    /**
     * Get compulsory1.
     *
     * @return array|null
     */
    public function getCompulsory1()
    {
        return $this->compulsory_1;
    }

    /**
     * Set compulsory2.
     *
     * @param array|null $compulsory2
     *
     * @return AdmissionForm
     */
    public function setCompulsory2($compulsory2 = null)
    {
        $this->compulsory_2 = $compulsory2;

        return $this;
    }

    /**
     * Get compulsory2.
     *
     * @return array|null
     */
    public function getCompulsory2()
    {
        return $this->compulsory_2;
    }

    /**
     * Set compulsory3.
     *
     * @param array|null $compulsory3
     *
     * @return AdmissionForm
     */
    public function setCompulsory3($compulsory3 = null)
    {
        $this->compulsory_3 = $compulsory3;

        return $this;
    }

    /**
     * Get compulsory3.
     *
     * @return array|null
     */
    public function getCompulsory3()
    {
        return $this->compulsory_3;
    }

    /**
     * Set mil.
     *
     * @param array|null $mil
     *
     * @return AdmissionForm
     */
    public function setMil($mil = null)
    {
        $this->mil = $mil;

        return $this;
    }

    /**
     * Get mil.
     *
     * @return array|null
     */
    public function getMil()
    {
        return $this->mil;
    }

    /**
     * Set generic1.
     *
     * @param array|null $generic1
     *
     * @return AdmissionForm
     */
    public function setGeneric1($generic1 = null)
    {
        $this->generic_1 = $generic1;

        return $this;
    }

    /**
     * Get generic1.
     *
     * @return array|null
     */
    public function getGeneric1()
    {
        return $this->generic_1;
    }

    /**
     * Set generic2.
     *
     * @param array|null $generic2
     *
     * @return AdmissionForm
     */
    public function setGeneric2($generic2 = null)
    {
        $this->generic_2 = $generic2;

        return $this;
    }

    /**
     * Get generic2.
     *
     * @return array|null
     */
    public function getGeneric2()
    {
        return $this->generic_2;
    }

    /**
     * Set generic3.
     *
     * @param array|null $generic3
     *
     * @return AdmissionForm
     */
    public function setGeneric3($generic3 = null)
    {
        $this->generic_3 = $generic3;

        return $this;
    }

    /**
     * Get generic3.
     *
     * @return array|null
     */
    public function getGeneric3()
    {
        return $this->generic_3;
    }

    /**
     * Set finalMajor.
     *
     * @param array|null $finalMajor
     *
     * @return AdmissionForm
     */
    public function setFinalMajor($finalMajor = null)
    {
        $this->final_major = $finalMajor;

        return $this;
    }

    /**
     * Get finalMajor.
     *
     * @return array|null
     */
    public function getFinalMajor()
    {
        return $this->final_major;
    }

    /**
     * Set finalGeneric.
     *
     * @param array|null $finalGeneric
     *
     * @return AdmissionForm
     */
    public function setFinalGeneric($finalGeneric = null)
    {
        $this->final_generic = $finalGeneric;

        return $this;
    }

    /**
     * Get finalGeneric.
     *
     * @return array|null
     */
    public function getFinalGeneric()
    {
        return $this->final_generic;
    }

    /**
     * Set subjectComb.
     *
     * @param int|null $subjectComb
     *
     * @return AdmissionForm
     */
    public function setSubjectComb($subjectComb = null)
    {
        $this->subject_comb = $subjectComb;

        return $this;
    }

    /**
     * Get subjectComb.
     *
     * @return int|null
     */
    public function getSubjectComb()
    {
        return $this->subject_comb;
    }

    /**
     * Set optionalSubjects.
     *
     * @param array|null $optionalSubjects
     *
     * @return AdmissionForm
     */
    public function setOptionalSubjects($optionalSubjects = null)
    {
        $this->optional_subjects = $optionalSubjects;

        return $this;
    }

    /**
     * Get optionalSubjects.
     *
     * @return array|null
     */
    public function getOptionalSubjects()
    {
        return $this->optional_subjects;
    }

    /**
     * Set courseType.
     *
     * @param string|null $courseType
     *
     * @return AdmissionForm
     */
    public function setCourseType($courseType = null)
    {
        $this->course_type = $courseType;

        return $this;
    }

    /**
     * Get courseType.
     *
     * @return string|null
     */
    public function getCourseType()
    {
        return $this->course_type;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return AdmissionForm
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set stream.
     *
     * @param string|null $stream
     *
     * @return AdmissionForm
     */
    public function setStream($stream = null)
    {
        $this->stream = $stream;

        return $this;
    }

    /**
     * Get stream.
     *
     * @return string|null
     */
    public function getStream()
    {
        return $this->stream;
    }

    /**
     * Set deptCode.
     *
     * @param string|null $deptCode
     *
     * @return AdmissionForm
     */
    public function setDeptCode($deptCode = null)
    {
        $this->dept_code = $deptCode;

        return $this;
    }

    /**
     * Get deptCode.
     *
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->dept_code;
    }

    /**
     * Set semester.
     *
     * @param int|null $semester
     *
     * @return AdmissionForm
     */
    public function setSemester($semester = null)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return int|null
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set sessionId.
     *
     * @param int|null $sessionId
     *
     * @return AdmissionForm
     */
    public function setSessionId($sessionId = null)
    {
        $this->session_id = $sessionId;

        return $this;
    }

    /**
     * Get sessionId.
     *
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->session_id;
    }

    /**
     * Set dateOfAdmission.
     *
     * @param string|null $dateOfAdmission
     *
     * @return AdmissionForm
     */
    public function setDateOfAdmission($dateOfAdmission = null)
    {
        $this->date_of_admission = $dateOfAdmission;

        return $this;
    }

    /**
     * Get dateOfAdmission.
     *
     * @return string|null
     */
    public function getDateOfAdmission()
    {
        return $this->date_of_admission;
    }

    /**
     * Set accountHolder.
     *
     * @param string|null $accountHolder
     *
     * @return AdmissionForm
     */
    public function setAccountHolder($accountHolder = null)
    {
        $this->account_holder = $accountHolder;

        return $this;
    }

    /**
     * Get accountHolder.
     *
     * @return string|null
     */
    public function getAccountHolder()
    {
        return $this->account_holder;
    }

    /**
     * Set accountNo.
     *
     * @param string|null $accountNo
     *
     * @return AdmissionForm
     */
    public function setAccountNo($accountNo = null)
    {
        $this->account_no = $accountNo;

        return $this;
    }

    /**
     * Get accountNo.
     *
     * @return string|null
     */
    public function getAccountNo()
    {
        return $this->account_no;
    }

    /**
     * Set accountBank.
     *
     * @param string|null $accountBank
     *
     * @return AdmissionForm
     */
    public function setAccountBank($accountBank = null)
    {
        $this->account_bank = $accountBank;

        return $this;
    }

    /**
     * Get accountBank.
     *
     * @return string|null
     */
    public function getAccountBank()
    {
        return $this->account_bank;
    }

    /**
     * Set accountBranch.
     *
     * @param string|null $accountBranch
     *
     * @return AdmissionForm
     */
    public function setAccountBranch($accountBranch = null)
    {
        $this->account_branch = $accountBranch;

        return $this;
    }

    /**
     * Get accountBranch.
     *
     * @return string|null
     */
    public function getAccountBranch()
    {
        return $this->account_branch;
    }

    /**
     * Set accountIfsc.
     *
     * @param string|null $accountIfsc
     *
     * @return AdmissionForm
     */
    public function setAccountIfsc($accountIfsc = null)
    {
        $this->account_ifsc = $accountIfsc;

        return $this;
    }

    /**
     * Get accountIfsc.
     *
     * @return string|null
     */
    public function getAccountIfsc()
    {
        return $this->account_ifsc;
    }

    /**
     * Set accountMicr.
     *
     * @param string|null $accountMicr
     *
     * @return AdmissionForm
     */
    public function setAccountMicr($accountMicr = null)
    {
        $this->account_micr = $accountMicr;

        return $this;
    }

    /**
     * Get accountMicr.
     *
     * @return string|null
     */
    public function getAccountMicr()
    {
        return $this->account_micr;
    }

    /**
     * Set presentAddress.
     *
     * @param array|null $presentAddress
     *
     * @return AdmissionForm
     */
    public function setPresentAddress($presentAddress = null)
    {
        $this->present_address = $presentAddress;

        return $this;
    }

    /**
     * Get presentAddress.
     *
     * @return array|null
     */
    public function getPresentAddress()
    {
        return $this->present_address;
    }

    /**
     * Set permanentAddress.
     *
     * @param array|null $permanentAddress
     *
     * @return AdmissionForm
     */
    public function setPermanentAddress($permanentAddress = null)
    {
        $this->permanent_address = $permanentAddress;

        return $this;
    }

    /**
     * Get permanentAddress.
     *
     * @return array|null
     */
    public function getPermanentAddress()
    {
        return $this->permanent_address;
    }

    /**
     * Set localAddress.
     *
     * @param array|null $localAddress
     *
     * @return AdmissionForm
     */
    public function setLocalAddress($localAddress = null)
    {
        $this->local_address = $localAddress;

        return $this;
    }

    /**
     * Get localAddress.
     *
     * @return array|null
     */
    public function getLocalAddress()
    {
        return $this->local_address;
    }

    /**
     * Set localG.
     *
     * @param string|null $localG
     *
     * @return AdmissionForm
     */
    public function setLocalG($localG = null)
    {
        $this->local_g = $localG;

        return $this;
    }

    /**
     * Get localG.
     *
     * @return string|null
     */
    public function getLocalG()
    {
        return $this->local_g;
    }

    /**
     * Set extraCurr.
     *
     * @param string|null $extraCurr
     *
     * @return AdmissionForm
     */
    public function setExtraCurr($extraCurr = null)
    {
        $this->extra_curr = $extraCurr;

        return $this;
    }

    /**
     * Get extraCurr.
     *
     * @return string|null
     */
    public function getExtraCurr()
    {
        return $this->extra_curr;
    }

    /**
     * Set dp.
     *
     * @param array|null $dp
     *
     * @return AdmissionForm
     */
    public function setDp($dp = null)
    {
        $this->dp = $dp;

        return $this;
    }

    /**
     * Get dp.
     *
     * @return array|null
     */
    public function getDp()
    {
        return $this->dp;
    }

    /**
     * Set signature.
     *
     * @param array|null $signature
     *
     * @return AdmissionForm
     */
    public function setSignature($signature = null)
    {
        $this->signature = $signature;

        return $this;
    }

    /**
     * Get signature.
     *
     * @return array|null
     */
    public function getSignature()
    {
        return $this->signature;
    }

    /**
     * Set gSignature.
     *
     * @param array|null $gSignature
     *
     * @return AdmissionForm
     */
    public function setGSignature($gSignature = null)
    {
        $this->g_signature = $gSignature;

        return $this;
    }

    /**
     * Get gSignature.
     *
     * @return array|null
     */
    public function getGSignature()
    {
        return $this->g_signature;
    }

    /**
     * Set certificate.
     *
     * @param array|null $certificate
     *
     * @return AdmissionForm
     */
    public function setCertificate($certificate = null)
    {
        $this->certificate = $certificate;

        return $this;
    }

    /**
     * Get certificate.
     *
     * @return array|null
     */
    public function getCertificate()
    {
        return $this->certificate;
    }

    /**
     * Set marksheet.
     *
     * @param array|null $marksheet
     *
     * @return AdmissionForm
     */
    public function setMarksheet($marksheet = null)
    {
        $this->marksheet = $marksheet;

        return $this;
    }

    /**
     * Get marksheet.
     *
     * @return array|null
     */
    public function getMarksheet()
    {
        return $this->marksheet;
    }

    /**
     * Set income.
     *
     * @param array|null $income
     *
     * @return AdmissionForm
     */
    public function setIncome($income = null)
    {
        $this->income = $income;

        return $this;
    }

    /**
     * Get income.
     *
     * @return array|null
     */
    public function getIncome()
    {
        return $this->income;
    }

    /**
     * Set bpl.
     *
     * @param array|null $bpl
     *
     * @return AdmissionForm
     */
    public function setBpl($bpl = null)
    {
        $this->bpl = $bpl;

        return $this;
    }

    /**
     * Get bpl.
     *
     * @return array|null
     */
    public function getBpl()
    {
        return $this->bpl;
    }

    /**
     * Set tree.
     *
     * @param array|null $tree
     *
     * @return AdmissionForm
     */
    public function setTree($tree = null)
    {
        $this->tree = $tree;

        return $this;
    }

    /**
     * Get tree.
     *
     * @return array|null
     */
    public function getTree()
    {
        return $this->tree;
    }

    /**
     * Set uniqueAck.
     *
     * @param array|null $uniqueAck
     *
     * @return AdmissionForm
     */
    public function setUniqueAck($uniqueAck = null)
    {
        $this->unique_ack = $uniqueAck;

        return $this;
    }

    /**
     * Get uniqueAck.
     *
     * @return array|null
     */
    public function getUniqueAck()
    {
        return $this->unique_ack;
    }

    /**
     * Set ageProof.
     *
     * @param array|null $ageProof
     *
     * @return AdmissionForm
     */
    public function setAgeProof($ageProof = null)
    {
        $this->age_proof = $ageProof;

        return $this;
    }

    /**
     * Get ageProof.
     *
     * @return array|null
     */
    public function getAgeProof()
    {
        return $this->age_proof;
    }

    /**
     * Set bankDetails.
     *
     * @param array|null $bankDetails
     *
     * @return AdmissionForm
     */
    public function setBankDetails($bankDetails = null)
    {
        $this->bank_details = $bankDetails;

        return $this;
    }

    /**
     * Get bankDetails.
     *
     * @return array|null
     */
    public function getBankDetails()
    {
        return $this->bank_details;
    }

    /**
     * Set otherCertificate.
     *
     * @param array|null $otherCertificate
     *
     * @return AdmissionForm
     */
    public function setOtherCertificate($otherCertificate = null)
    {
        $this->other_certificate = $otherCertificate;

        return $this;
    }

    /**
     * Get otherCertificate.
     *
     * @return array|null
     */
    public function getOtherCertificate()
    {
        return $this->other_certificate;
    }

    /**
     * Set gapCertificate.
     *
     * @param array|null $gapCertificate
     *
     * @return AdmissionForm
     */
    public function setGapCertificate($gapCertificate = null)
    {
        $this->gap_certificate = $gapCertificate;

        return $this;
    }

    /**
     * Get gapCertificate.
     *
     * @return array|null
     */
    public function getGapCertificate()
    {
        return $this->gap_certificate;
    }

    /**
     * Set casteCertificate.
     *
     * @param array|null $casteCertificate
     *
     * @return AdmissionForm
     */
    public function setCasteCertificate($casteCertificate = null)
    {
        $this->caste_certificate = $casteCertificate;

        return $this;
    }

    /**
     * Get casteCertificate.
     *
     * @return array|null
     */
    public function getCasteCertificate()
    {
        return $this->caste_certificate;
    }

    /**
     * Set domicileCertificate.
     *
     * @param array|null $domicileCertificate
     *
     * @return AdmissionForm
     */
    public function setDomicileCertificate($domicileCertificate = null)
    {
        $this->domicile_certificate = $domicileCertificate;

        return $this;
    }

    /**
     * Get domicileCertificate.
     *
     * @return array|null
     */
    public function getDomicileCertificate()
    {
        return $this->domicile_certificate;
    }

    /**
     * Set pwdCertificate.
     *
     * @param array|null $pwdCertificate
     *
     * @return AdmissionForm
     */
    public function setPwdCertificate($pwdCertificate = null)
    {
        $this->pwd_certificate = $pwdCertificate;

        return $this;
    }

    /**
     * Get pwdCertificate.
     *
     * @return array|null
     */
    public function getPwdCertificate()
    {
        return $this->pwd_certificate;
    }

    /**
     * Set feesReceipt.
     *
     * @param array|null $feesReceipt
     *
     * @return AdmissionForm
     */
    public function setFeesReceipt($feesReceipt = null)
    {
        $this->fees_receipt = $feesReceipt;

        return $this;
    }

    /**
     * Get feesReceipt.
     *
     * @return array|null
     */
    public function getFeesReceipt()
    {
        return $this->fees_receipt;
    }

    /**
     * Set isDel.
     *
     * @param int|null $isDel
     *
     * @return AdmissionForm
     */
    public function setIsDel($isDel = null)
    {
        $this->is_del = $isDel;

        return $this;
    }

    /**
     * Get isDel.
     *
     * @return int|null
     */
    public function getIsDel()
    {
        return $this->is_del;
    }

    /**
     * Set isSubmit.
     *
     * @param int|null $isSubmit
     *
     * @return AdmissionForm
     */
    public function setIsSubmit($isSubmit = null)
    {
        $this->is_submit = $isSubmit;

        return $this;
    }

    /**
     * Get isSubmit.
     *
     * @return int|null
     */
    public function getIsSubmit()
    {
        return $this->is_submit;
    }

    /**
     * Set paymentReceipt.
     *
     * @param array|null $paymentReceipt
     *
     * @return AdmissionForm
     */
    public function setPaymentReceipt($paymentReceipt = null)
    {
        $this->payment_receipt = $paymentReceipt;

        return $this;
    }

    /**
     * Get paymentReceipt.
     *
     * @return array|null
     */
    public function getPaymentReceipt()
    {
        return $this->payment_receipt;
    }

    /**
     * Set isComplete.
     *
     * @param int|null $isComplete
     *
     * @return AdmissionForm
     */
    public function setIsComplete($isComplete = null)
    {
        $this->is_complete = $isComplete;

        return $this;
    }

    /**
     * Get isComplete.
     *
     * @return int|null
     */
    public function getIsComplete()
    {
        return $this->is_complete;
    }

    /**
     * Set paymentStatus.
     *
     * @param int|null $paymentStatus
     *
     * @return AdmissionForm
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        $this->payment_status = $paymentStatus;

        return $this;
    }

    /**
     * Get paymentStatus.
     *
     * @return int|null
     */
    public function getPaymentStatus()
    {
        return $this->payment_status;
    }

    /**
     * Set transaction.
     *
     * @param string|null $transaction
     *
     * @return AdmissionForm
     */
    public function setTransaction($transaction = null)
    {
        $this->transaction = $transaction;

        return $this;
    }

    /**
     * Get transaction.
     *
     * @return string|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }

    /**
     * Set admissionDone.
     *
     * @param int|null $admissionDone
     *
     * @return AdmissionForm
     */
    public function setAdmissionDone($admissionDone = null)
    {
        $this->admission_done = $admissionDone;

        return $this;
    }

    /**
     * Get admissionDone.
     *
     * @return int|null
     */
    public function getAdmissionDone()
    {
        return $this->admission_done;
    }

    /**
     * Set admissionPaymentDone.
     *
     * @param int|null $admissionPaymentDone
     *
     * @return AdmissionForm
     */
    public function setAdmissionPaymentDone($admissionPaymentDone = null)
    {
        $this->admission_payment_done = $admissionPaymentDone;

        return $this;
    }

    /**
     * Get admissionPaymentDone.
     *
     * @return int|null
     */
    public function getAdmissionPaymentDone()
    {
        return $this->admission_payment_done;
    }

    /**
     * Set studentId.
     *
     * @param int|null $studentId
     *
     * @return AdmissionForm
     */
    public function setStudentId($studentId = null)
    {
        $this->student_id = $studentId;

        return $this;
    }

    /**
     * Get studentId.
     *
     * @return int|null
     */
    public function getStudentId()
    {
        return $this->student_id;
    }

    /**
     * Set admissionType.
     *
     * @param int|null $admissionType
     *
     * @return AdmissionForm
     */
    public function setAdmissionType($admissionType = null)
    {
        $this->admission_type = $admissionType;

        return $this;
    }

    /**
     * Get admissionType.
     *
     * @return int|null
     */
    public function getAdmissionType()
    {
        return $this->admission_type;
    }

    /**
     * Set isVerified.
     *
     * @param int|null $isVerified
     *
     * @return AdmissionForm
     */
    public function setIsVerified($isVerified = null)
    {
        $this->is_verified = $isVerified;

        return $this;
    }

    /**
     * Get isVerified.
     *
     * @return int|null
     */
    public function getIsVerified()
    {
        return $this->is_verified;
    }

    /**
     * Set verifiedOn.
     *
     * @param string|null $verifiedOn
     *
     * @return AdmissionForm
     */
    public function setVerifiedOn($verifiedOn = null)
    {
        $this->verified_on = $verifiedOn;

        return $this;
    }

    /**
     * Get verifiedOn.
     *
     * @return string|null
     */
    public function getVerifiedOn()
    {
        return $this->verified_on;
    }

    /**
     * Set verifiedBy.
     *
     * @param string|null $verifiedBy
     *
     * @return AdmissionForm
     */
    public function setVerifiedBy($verifiedBy = null)
    {
        $this->verified_by = $verifiedBy;

        return $this;
    }

    /**
     * Get verifiedBy.
     *
     * @return string|null
     */
    public function getVerifiedBy()
    {
        return $this->verified_by;
    }

    /**
     * Set rejectionReason.
     *
     * @param string|null $rejectionReason
     *
     * @return AdmissionForm
     */
    public function setRejectionReason($rejectionReason = null)
    {
        $this->rejection_reason = $rejectionReason;

        return $this;
    }

    /**
     * Get rejectionReason.
     *
     * @return string|null
     */
    public function getRejectionReason()
    {
        return $this->rejection_reason;
    }

    /**
     * Set isAdmitted.
     *
     * @param int|null $isAdmitted
     *
     * @return AdmissionForm
     */
    public function setIsAdmitted($isAdmitted = null)
    {
        $this->is_admitted = $isAdmitted;

        return $this;
    }

    /**
     * Get isAdmitted.
     *
     * @return int|null
     */
    public function getIsAdmitted()
    {
        return $this->is_admitted;
    }

    /**
     * Set requestId.
     *
     * @param int|null $requestId
     *
     * @return AdmissionForm
     */
    public function setRequestId($requestId = null)
    {
        $this->request_id = $requestId;

        return $this;
    }

    /**
     * Get requestId.
     *
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Set requestType.
     *
     * @param string|null $requestType
     *
     * @return AdmissionForm
     */
    public function setRequestType($requestType = null)
    {
        $this->request_type = $requestType;

        return $this;
    }

    /**
     * Get requestType.
     *
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->request_type;
    }

    /**
     * Set uniqueId.
     *
     * @param string|null $uniqueId
     *
     * @return AdmissionForm
     */
    public function setUniqueId($uniqueId = null)
    {
        $this->unique_id = $uniqueId;

        return $this;
    }

    /**
     * Get uniqueId.
     *
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->unique_id;
    }

    /**
     * Set collegeId.
     *
     * @param string|null $collegeId
     *
     * @return AdmissionForm
     */
    public function setCollegeId($collegeId = null)
    {
        $this->college_id = $collegeId;

        return $this;
    }

    /**
     * Get collegeId.
     *
     * @return string|null
     */
    public function getCollegeId()
    {
        return $this->college_id;
    }

    /**
     * Set otherCollege.
     *
     * @param string|null $otherCollege
     *
     * @return AdmissionForm
     */
    public function setOtherCollege($otherCollege = null)
    {
        $this->other_college = $otherCollege;

        return $this;
    }

    /**
     * Get otherCollege.
     *
     * @return string|null
     */
    public function getOtherCollege()
    {
        return $this->other_college;
    }

    /**
     * Set activities.
     *
     * @param array|null $activities
     *
     * @return AdmissionForm
     */
    public function setActivities($activities = null)
    {
        $this->activities = $activities;

        return $this;
    }

    /**
     * Get activities.
     *
     * @return array|null
     */
    public function getActivities()
    {
        return $this->activities;
    }

    /**
     * Set subjectsChoosen.
     *
     * @param array|null $subjectsChoosen
     *
     * @return AdmissionForm
     */
    public function setSubjectsChoosen($subjectsChoosen = null)
    {
        $this->subjects_choosen = $subjectsChoosen;

        return $this;
    }

    /**
     * Get subjectsChoosen.
     *
     * @return array|null
     */
    public function getSubjectsChoosen()
    {
        return $this->subjects_choosen;
    }

    /**
     * Set hasGap.
     *
     * @param string|null $hasGap
     *
     * @return AdmissionForm
     */
    public function setHasGap($hasGap = null)
    {
        $this->has_gap = $hasGap;

        return $this;
    }

    /**
     * Get hasGap.
     *
     * @return string|null
     */
    public function getHasGap()
    {
        return $this->has_gap;
    }

    /**
     * Set gapAdmission.
     *
     * @param string|null $gapAdmission
     *
     * @return AdmissionForm
     */
    public function setGapAdmission($gapAdmission = null)
    {
        $this->gap_admission = $gapAdmission;

        return $this;
    }

    /**
     * Get gapAdmission.
     *
     * @return string|null
     */
    public function getGapAdmission()
    {
        return $this->gap_admission;
    }

    /**
     * Set gapCourse.
     *
     * @param string|null $gapCourse
     *
     * @return AdmissionForm
     */
    public function setGapCourse($gapCourse = null)
    {
        $this->gap_course = $gapCourse;

        return $this;
    }

    /**
     * Get gapCourse.
     *
     * @return string|null
     */
    public function getGapCourse()
    {
        return $this->gap_course;
    }

    /**
     * Set gapInstitute.
     *
     * @param string|null $gapInstitute
     *
     * @return AdmissionForm
     */
    public function setGapInstitute($gapInstitute = null)
    {
        $this->gap_institute = $gapInstitute;

        return $this;
    }

    /**
     * Get gapInstitute.
     *
     * @return string|null
     */
    public function getGapInstitute()
    {
        return $this->gap_institute;
    }

    /**
     * Set gapRollNo.
     *
     * @param string|null $gapRollNo
     *
     * @return AdmissionForm
     */
    public function setGapRollNo($gapRollNo = null)
    {
        $this->gap_roll_no = $gapRollNo;

        return $this;
    }

    /**
     * Get gapRollNo.
     *
     * @return string|null
     */
    public function getGapRollNo()
    {
        return $this->gap_roll_no;
    }

    /**
     * Set gapReason.
     *
     * @param string|null $gapReason
     *
     * @return AdmissionForm
     */
    public function setGapReason($gapReason = null)
    {
        $this->gap_reason = $gapReason;

        return $this;
    }

    /**
     * Get gapReason.
     *
     * @return string|null
     */
    public function getGapReason()
    {
        return $this->gap_reason;
    }

    /**
     * Set isEws.
     *
     * @param string|null $isEws
     *
     * @return AdmissionForm
     */
    public function setIsEws($isEws = null)
    {
        $this->is_ews = $isEws;

        return $this;
    }

    /**
     * Get isEws.
     *
     * @return string|null
     */
    public function getIsEws()
    {
        return $this->is_ews;
    }

    /**
     * Set documentsUploaded.
     *
     * @param array|null $documentsUploaded
     *
     * @return AdmissionForm
     */
    public function setDocumentsUploaded($documentsUploaded = null)
    {
        $this->documents_uploaded = $documentsUploaded;

        return $this;
    }

    /**
     * Get documentsUploaded.
     *
     * @return array|null
     */
    public function getDocumentsUploaded()
    {
        return $this->documents_uploaded;
    }

    /**
     * Set documentsRequired.
     *
     * @param array|null $documentsRequired
     *
     * @return AdmissionForm
     */
    public function setDocumentsRequired($documentsRequired = null)
    {
        $this->documents_required = $documentsRequired;

        return $this;
    }

    /**
     * Get documentsRequired.
     *
     * @return array|null
     */
    public function getDocumentsRequired()
    {
        return $this->documents_required;
    }

    /**
     * Set admissionAmountPaid.
     *
     * @param string $admissionAmountPaid
     *
     * @return AdmissionForm
     */
    public function setAdmissionAmountPaid($admissionAmountPaid)
    {
        $this->admission_amount_paid = $admissionAmountPaid;

        return $this;
    }

    /**
     * Get admissionAmountPaid.
     *
     * @return string
     */
    public function getAdmissionAmountPaid()
    {
        return $this->admission_amount_paid;
    }

    /**
     * Set primaryEmail.
     *
     * @param string $primaryEmail
     *
     * @return AdmissionForm
     */
    public function setPrimaryEmail($primaryEmail)
    {
        $this->primary_email = $primaryEmail;

        return $this;
    }

    /**
     * Get primaryEmail.
     *
     * @return string
     */
    public function getPrimaryEmail()
    {
        return $this->primary_email;
    }
}
