<?php

/**
 * @Entity(repositoryClass="AllowAdmissionRepository") @Table(name="allow_admission")
 */

class AllowAdmission
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=10, nullable=true)
     */
    protected $admission_type;


     /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $start_time;

     /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $end_time;


    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $documents_required;



    /**
     * @Column(type="string",length=10, nullable=true)
     */
    protected $status=0;

   

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return AllowAdmission
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set admissionType.
     *
     * @param int|null $admissionType
     *
     * @return AllowAdmission
     */
    public function setAdmissionType($admissionType = null)
    {
        $this->admission_type = $admissionType;

        return $this;
    }

    /**
     * Get admissionType.
     *
     * @return int|null
     */
    public function getAdmissionType()
    {
        return $this->admission_type;
    }

    /**
     * Set status.
     *
     * @param int|null $status
     *
     * @return AllowAdmission
     */
    public function setStatus($status = null)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status.
     *
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set startTime.
     *
     * @param string|null $startTime
     *
     * @return AllowAdmission
     */
    public function setStartTime($startTime = null)
    {
        $this->start_time = $startTime;

        return $this;
    }

    /**
     * Get startTime.
     *
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    /**
     * Set endTime.
     *
     * @param string|null $endTime
     *
     * @return AllowAdmission
     */
    public function setEndTime($endTime = null)
    {
        $this->end_time = $endTime;

        return $this;
    }

    /**
     * Get endTime.
     *
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    /**
     * Set documentsRequired.
     *
     * @param array|null $documentsRequired
     *
     * @return AllowAdmission
     */
    public function setDocumentsRequired($documentsRequired = null)
    {
        $this->documents_required = $documentsRequired;

        return $this;
    }

    /**
     * Get documentsRequired.
     *
     * @return array|null
     */
    public function getDocumentsRequired()
    {
        return $this->documents_required;
    }
}
