<?php

use Doctrine\ORM\EntityRepository;

class AllowAdmissionRepository extends EntityRepository
{

    public function add($body)
    {
        $entityManager = $this->getEntityManager();
        $course = addslashes(strip_tags(trim($body['course'])));
        $admission_type = addslashes(strip_tags(trim($body['admission_type'])));
        $start_time = addslashes(strip_tags(trim($body['start_time'])));
        $end_time = addslashes(strip_tags(trim($body['end_time'])));
        $status = addslashes(strip_tags(trim($body['status'])));
        $documents_required = $body['documents_required'];


        if (sizeof($this->check($body)) == 0) {
            $access = new AllowAdmission();
            $access->setCourse($course);
            $access->setAdmissionType($admission_type);
            $access->setStartTime($start_time);
            $access->setEndTime($end_time);
            $access->setStatus($status);
            $access->setDocumentsRequired($documents_required);
            
            $entityManager->persist($access);
            $entityManager->flush();
            return 'Sucessfully Inserted';
        } else {
            return 'Already Exists';
        }

    }

    public function getAll()
    {
        $dql = "SELECT r.id,r.course,r.admission_type,r.start_time,r.end_time,r.status,r.documents_required,s.tenure,s.no_of_term,s.label FROM AllowAdmission r,Course s WHERE r.course=s.name";
        $query = $this->getEntityManager()->createQuery($dql);
        return  $query->getResult();
       
    }

    public function getActiveAdmission()
    {
        $dql = "SELECT r.id,r.course,r.admission_type,r.start_time,r.end_time,r.status,r.documents_required,s.tenure,s.no_of_term,s.label FROM AllowAdmission r,Course s WHERE r.course=s.name";
        $query = $this->getEntityManager()->createQuery($dql);
        $result =  $query->getResult();
        $temp = [];

        if(sizeof($result)>0){

            foreach($result as $r){
                $flag = $this->isAdmissionAllowed($r['course'], $r['admission_type']);
                
                if($flag){
                $r['status'] = $flag == true ? 1 : 0;
                array_push($temp,$r);
                }
            }
        }

        return $temp;
    }

    public function getAllByType($type){
        $dql = "SELECT r.id,r.course,r.admission_type,r.start_time,r.end_time,r.status,r.documents_required FROM AllowAdmission r WHERE r.admission_type=:type AND r.status=1";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('type',$type);
        return $query->getResult();
    }

    private function getAllForEdit($id)
    {
        $dql = "SELECT r From AllowAdmission r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function getSingle($id)
    {
        $dql = "SELECT r.id,r.course,r.admission_type,r.status FROM AllowAdmission r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function update($id, $body)
    {
        $entityManager = $this->getEntityManager();

        $id = addslashes(strip_tags(trim($body['id'])));
        $course = addslashes(strip_tags(trim($body['course'])));
        $admission_type = addslashes(strip_tags(trim($body['admission_type'])));
        $start_time = addslashes(strip_tags(trim($body['start_time'])));
        $end_time = addslashes(strip_tags(trim($body['end_time'])));
        $status = addslashes(strip_tags(trim($body['status'])));
        $documents_required = $body['documents_required'];

        $result = $this->getAllForEdit($id);

        if (sizeof($result) == 1) {
            $result[0]->setCourse($course);
            $result[0]->setAdmissionType($admission_type);
            $result[0]->setStatus($status);
            $result[0]->setStartTime($start_time);
            $result[0]->setEndTime($end_time);
            $result[0]->setDocumentsRequired($documents_required);
            
            $entityManager->persist($result[0]);
            $entityManager->flush();
            return "Updated Successfully.";
        } else {
            return "Not Found.";
        }

    }

    public function check($body)
    {
        $course = addslashes(strip_tags(trim($body['course'])));
        $admission_type = addslashes(strip_tags(trim($body['admission_type'])));


        $dql = 'SELECT r FROM AllowAdmission r WHERE r.course=:course AND r.admission_type=:admission_type';
        $query = $this->getEntityManager()
            ->createQuery($dql)
            ->setParameter('course', $course)
            ->setParameter('admission_type', $admission_type);
        return $query->getResult();
    }

    public function delete($id)
    {
        $dql = 'DELETE FROM AllowAdmission r WHERE r.id=:id';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $query->getResult();
        return 'Successfully Deleted';
    }

    public function isAdmissionAllowed($course, $admission_type)
    {
        
        $r = $this->getEntityManager()->getRepository('SessionMaster')->getActiveSession();

            if (sizeof($r) == 0) {
               return false; 
            } 

           

        $dql = 'SELECT r.start_time,r.end_time,r.status FROM AllowAdmission r WHERE r.course=:course AND r.admission_type=:admission_type';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('admission_type', $admission_type)->setParameter('course', $course);
        $r = $query->getResult();
        if(sizeOf($r) > 0){
            if($r[0]['status'] == 1 ){
            if($r[0]['start_time'] !='' && $r[0]['end_time'] !='' && $r[0]['start_time'] !=null && $r[0]['end_time'] !=null){

                if(date('Y-m-d HH:mm:ss') >= date('Y-m-d HH:mm:ss',strtotime($r[0]['start_time'])) && date('Y-m-d HH:mm:ss') <= date('Y-m-d HH:mm:ss',strtotime($r[0]['end_time']))){
                    return true;
                }
                else return false;
            }
            else {
                if($r[0]['start_time'] !='' && $r[0]['start_time'] !=null){

                    if(date('Y-m-d HH:mm:ss') >= date('Y-m-d HH:mm:ss',strtotime($r[0]['start_time']))){
                        return true;
                    }
                    else return false;
                }
                else if($r[0]['end_time'] !='' && $r[0]['end_time'] !=null){

                    if(date('Y-m-d HH:mm:ss') <= date('Y-m-d HH:mm:ss',strtotime($r[0]['end_time']))){
                        return true;
                    }
                    else return false;
                }

                else return true;
            }
        }
        else return false;
            
        }else{
            return false;
        }
    }
}
