<?php

use Doctrine\ORM\EntityRepository;

class AlumniRepository extends EntityRepository
{

    public function addAlumniQuick($body){
        $em = $this->getEntityManager();

        $name = addslashes(strip_tags(trim($body['name'])));
        $contact = addslashes(strip_tags(trim($body['contact'])));
        $email = addslashes(strip_tags(trim($body['email'])));
        $course = addslashes(strip_tags(trim($body['course'])));
        $address = addslashes(strip_tags(trim($body['address'])));

        if (sizeof($this->checkContact($contact)) == 0) {
            $access = new Alumni();
            $access->setName($name);
            $access->setContact($contact);
            $access->setEmail($email);
            $access->setCourse($course);
            $access->setAddress($address);
            $em->persist($access);
            $em->flush();
            return true;
        } else {
            return false;
        }
    }

    public function addAlumni($body)
    {
        $entityManager = $this->getEntityManager();
        $name = addslashes(strip_tags(trim($body['name'])));
        $contact = addslashes(strip_tags(trim($body['contact'])));
        $email = addslashes(strip_tags(trim($body['email'])));
        $admission_yaer = addslashes(strip_tags(trim($body['admission_yaer'])));
        $passed_year = addslashes(strip_tags(trim($body['passed_year'])));
        $course = addslashes(strip_tags(trim($body['course'])));
        $address = addslashes(strip_tags(trim($body['address'])));
        $id_card = $body['id_card'];

        if (sizeof($this->checkContact($contact)) == 0) {
            $access = new Alumni();
            $access->setName($name);
            $access->setContact($contact);
            $access->setEmail($email);
            $access->setAdmissionYaer($admission_yaer);
            $access->setPassedYear($passed_year);
            $access->setCourse($course);
            $access->setAddress($address);
            $access->setIdCard($id_card);
            $entityManager->persist($access);
            $entityManager->flush();
            return 'Sucessfully Inserted';
        } else {
            return 'Already Exists';
        }

    }

    public function getAlumni()
    {
        $dql = "SELECT r.id,r.name,r.contact,r.email,r.admission_year,r.passed_year,r.course,r.address,r.id_card FROM Alumni r";
        $query = $this->getEntityManager()->createQuery($dql);
        return $query->getResult();
    }
    private function getAlumniForEdit($id)
    {
        $dql = "SELECT r From Alumni r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function getAlumniSingle($id)
    {
        $dql = "SELECT r.id,r.name,r.contact,r.email,r.admission_year,r.passed_year,r.course,r.address,r.id_card FROM Alumni r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function updateAlumni($id, $body)
    {
        $entityManager = $this->getEntityManager();

        $id = addslashes(strip_tags(trim($body['id'])));
        $name = addslashes(strip_tags(trim($body['name'])));
        $contact = addslashes(strip_tags(trim($body['contact'])));
        $email = addslashes(strip_tags(trim($body['email'])));
        $admission_yaer = addslashes(strip_tags(trim($body['admission_yaer'])));
        $passed_year = addslashes(strip_tags(trim($body['passed_year'])));
        $course = addslashes(strip_tags(trim($body['course'])));
        $address = addslashes(strip_tags(trim($body['address'])));
        $id_card = $body['id_card'];

        $result = $this->getAlumniForEdit($id);

        if (sizeof($result) == 1) {
            $result[0]->setName($name);
            $result[0]->setContact($contact);
            $result[0]->setEmail($email);
            $result[0]->setAdmissionYaer($admission_yaer);
            $result[0]->setPassedYear($passed_year);
            $result[0]->setCourse($course);
            $result[0]->setAddress($address);
            $result[0]->setIdCard($id_card);
            $entityManager->persist($result[0]);
            $entityManager->flush();
            return "Updated Successfully.";
        } else {
            return "Not Found.";
        }

    }

    public function checkContact($contact)
    {
        
        $dql = 'SELECT r FROM Alumni r WHERE r.contact=:contact';
        $query = $this->getEntityManager()
            ->createQuery($dql)
            ->setParameter('contact', $contact);
        return $query->getResult();
    }

    public function deleteAlumni($id)
    {
        $dql = 'DELETE FROM Alumni r WHERE r.id=:id';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $query->getResult();
        return 'Successfully Deleted';
    }

}
