<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="AlumniUserRepository") @Table(name="alumni_user")
 */

class AlumniUser
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=100)
     */
    protected $name;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $email;
    
    /**
     * @Column(type="string",length=20, nullable=true)
     */
    protected $phone;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $passout_year;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $admission_year;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $current_work;

    /**
     * @Column(type="json_array")
     */
    protected $id_card;

    /**
     * @Column(type="integer",length=5,options={"default": 0 })
     */
    protected $is_verified;

   

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return AlumniUser
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set email.
     *
     * @param string|null $email
     *
     * @return AlumniUser
     */
    public function setEmail($email = null)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email.
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set phone.
     *
     * @param string|null $phone
     *
     * @return AlumniUser
     */
    public function setPhone($phone = null)
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * Get phone.
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return AlumniUser
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set passoutYear.
     *
     * @param string|null $passoutYear
     *
     * @return AlumniUser
     */
    public function setPassoutYear($passoutYear = null)
    {
        $this->passout_year = $passoutYear;

        return $this;
    }

    /**
     * Get passoutYear.
     *
     * @return string|null
     */
    public function getPassoutYear()
    {
        return $this->passout_year;
    }

    /**
     * Set admissionYear.
     *
     * @param string|null $admissionYear
     *
     * @return AlumniUser
     */
    public function setAdmissionYear($admissionYear = null)
    {
        $this->admission_year = $admissionYear;

        return $this;
    }

    /**
     * Get admissionYear.
     *
     * @return string|null
     */
    public function getAdmissionYear()
    {
        return $this->admission_year;
    }

    /**
     * Set currentWork.
     *
     * @param string|null $currentWork
     *
     * @return AlumniUser
     */
    public function setCurrentWork($currentWork = null)
    {
        $this->current_work = $currentWork;

        return $this;
    }

    /**
     * Get currentWork.
     *
     * @return string|null
     */
    public function getCurrentWork()
    {
        return $this->current_work;
    }

    /**
     * Set idCard.
     *
     * @param array $idCard
     *
     * @return AlumniUser
     */
    public function setIdCard($idCard)
    {
        $this->id_card = $idCard;

        return $this;
    }

    /**
     * Get idCard.
     *
     * @return array
     */
    public function getIdCard()
    {
        return $this->id_card;
    }

    /**
     * Set isVerified.
     *
     * @param int $isVerified
     *
     * @return AlumniUser
     */
    public function setIsVerified($isVerified)
    {
        $this->is_verified = $isVerified;

        return $this;
    }

    /**
     * Get isVerified.
     *
     * @return int
     */
    public function getIsVerified()
    {
        return $this->is_verified;
    }
}
