<?php

use Doctrine\ORM\EntityRepository;

class AlumniUserRepository extends EntityRepository
{

    public function addAlumni($body)
    {
        $entityManager = $this->getEntityManager();
        $name = addslashes(strip_tags(trim($body['name'])));
        $email = addslashes(strip_tags(trim($body['email'])));
        $phone = addslashes(strip_tags(trim($body['phone'])));
        $admission_year = addslashes(strip_tags(trim($body['admission_year'])));
        $passout_year = addslashes(strip_tags(trim($body['passout_year'])));
        $course = addslashes(strip_tags(trim($body['course'])));
        $current_work = addslashes(strip_tags(trim($body['current_work'])));
        $is_verified = 0;

        // we will receive a file also 

        if (array_key_exists('file', $body)) {
            // store the file in storage and then proceed to the next step
            $b = [];
            $b['type'] = 'ALUMNI';
            $b['file'] = $body['file'];

            // send it to master file repository
            $ref_file = $this->getEntityManager()->getRepository('MasterFile')->addFile($b);
        } else {
            $ref_file = null;
        }




        if (sizeof($this->checkAlumni($email)) == 0) {
            $emp = new AlumniUser();
            $emp->setName($name);
            $emp->setEmail($email);
            $emp->setPhone($phone);
            $emp->setAdmissionYear($admission_year);
            $emp->setPassoutYear($passout_year);
            $emp->setCourse($course);
            $emp->setCurrentWork($current_work);
            $emp->setIsVerified($is_verified);
            $emp->setIdCard($ref_file);
            $entityManager->persist($emp);
            $entityManager->flush();
            if (null != $emp->getId()) {
                // $res = $entityManager->getRepository('GeneralUser')->addGeneralUser($body, 'ALUMNI');
                // if ($res == 'success') {
                //     return "Registered Successfully.";
                // }
                return "Registered successfully";
            }
        } else {
            return "Email already exist.";
        }
    }

    public function getAlumni()
    {
        $dql = "SELECT r.id,r.name,r.email,r.phone,r.course,r.admission_year,r.passout_year,r.current_work,r.id_card,r.is_verified From AlumniUser r ORDER BY r.name ASC";
        $query = $this->getEntityManager()->createQuery($dql);
        $result = $query->getResult();
        return $result;
    }



    public function getAlumniForEdit($id)
    {
        $dql = "SELECT r from AlumniUser r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function isAlumniVerified($email)
    {
        $dql = "SELECT r.is_verified from AlumniUser r where r.email=:email";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('email', $email);
        $result = $query->getResult();
        if (sizeof($result) > 0) {
            $is_verified = $result[0]['is_verified'];
            if ($is_verified == 1) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function getEmployeeSingle($id)
    {
        $dql = "SELECT r.id,r.name,r.email,r.phone,r.course,r.admission_year,r.passout_year,r.current_work,r.id_card From AlumniUser r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $result = $query->getResult();
        $a = array();
        require_once __DIR__ . '/../utility.php';
        $a[0]['data'] = $result[0];
        $file = new FileUpload();
        $a[0]['file'] = $file->getFile($result[0]['id_card']);

        return $a;
    }

    public function getAlumniPhoneNumber($email)
    {
        $dql = "SELECT r from AlumniUser r where r.email=:email";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('email', $email);
        $result = $query->getResult();
        return $result[0]->getPhone();
    }

    public function updateAlumni($id, $body)
    {
        $entityManager = $this->getEntityManager();
        $name = addslashes(strip_tags(trim($body['name'])));
        $email = addslashes(strip_tags(trim($body['email'])));
        $phone = addslashes(strip_tags(trim($body['phone'])));
        $admission_year = addslashes(strip_tags(trim($body['admission_year'])));
        $passout_year = addslashes(strip_tags(trim($body['passout_year'])));
        $course = addslashes(strip_tags(trim($body['course'])));
        $current_work = addslashes(strip_tags(trim($body['current_work'])));
        $is_verified = addslashes(strip_tags(trim($body['is_verified'])));

        $result = $this->getAlumniForEdit($id);
        if (sizeof($result) == 1) {

            $emp = $result[0];

            $emp->setName($name);
            $emp->setEmail($email);
            $emp->setPhone($phone);
            $emp->setAdmissionYear($admission_year);
            $emp->setPassoutYear($passout_year);
            $emp->setCourse($course);
            $emp->setCurrentWork($current_work);


            if ($emp->getIsVerified() == 0) {
                if ($is_verified == 1) {
                    $res = $entityManager->getRepository('GeneralUser')->addGeneralUser($body, 'ALUMNI');
                    if ($res == 'success') {
                        return "Registered Successfully.";
                    }
                }
            }


            $emp->setIsVerified($is_verified);


            $entityManager->persist($emp);
            $entityManager->flush();


            // if is verified 1

            return "Updated Successfully.";
        } else {
            return "Invalid Username.";
        }
    }

    public function deleteAlumni($id)
    {
        $r = $this->getAlumniForEdit($id);
        $this->getEntityManager()->getRepository('GeneralUser')->deleteGeneralUser($r[0]->getEmail());
        $dql = "DELETE FROM AlumniUser r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $query->getResult();
        return "Succesfully deleted";
    }

    public function checkAlumni($email)
    {
        $dql = 'SELECT r FROM AlumniUser r WHERE r.email=:email';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('email', $email);
        return $query->getResult();
    }
}
