<?php

use Doctrine\ORM\EntityRepository;

class AssignmentRepository extends EntityRepository
{

    public function getMyAssignments($student, $student_id)
    {

        $today = date('d-m-Y');
        

        $data = [];
        foreach ($student['subjects'] as $subject) {
            $sql = "SELECT r.id,r.course,r.stream,r.course_type,r.semester,r.sub_code,r.title,r.description,r.created_by,r.entry_date,r.upload_info,r.time_stamp,r.last_date,s.sub_name,u.name FROM assignment r, subject_master s, employee u WHERE r.created_by=u.email AND r.sub_code=s.sub_code  AND r.sub_code=:sub_code AND STR_TO_DATE(r.last_date,'%d-%m-%Y')>=STR_TO_DATE(:today,'%d-%m-%Y') AND r.course=:course AND r.semester=:semester AND r.course_type=:course_type ORDER BY r.last_date ASC";
            $stmt = $this->getEntityManager()->getConnection()->prepare($sql);
            $stmt->bindParam(':sub_code', $subject['value'], PDO::PARAM_STR);
            $stmt->bindParam(':course', $student['course'], PDO::PARAM_STR);
            //$stmt->bindParam(':stream', $student['stream'], PDO::PARAM_STR);
            $stmt->bindParam(':course_type', $student['course_type'], PDO::PARAM_STR);
            $stmt->bindParam(':semester', $student['semester'], PDO::PARAM_INT);
            $stmt->bindParam(':today', $today, PDO::PARAM_STR);
            $stmt->execute();
            $result = $stmt->fetchAll();
            $index = 0;
            
            foreach ($result as $r) {
                // check if already submitted
               
                $already_done = $this->getEntityManager()
                    ->getRepository('AssignmentSubmission')
                    ->checkAssignment($student_id,$r['id']);
                $result[$index]['already_done'] = !$already_done;
                $sub = $this->getEntityManager()->getRepository('AssignmentSubmission')->getCheckedValue($student_id,$r['id']);
                $result[$index]['checked'] = $sub;
                $uu = json_decode($r['upload_info'], true);
                $result[$index]['upload_info'] = $this->getEntityManager()->getRepository('ClassNotes')->getUrls($uu); 
                $index++;
            }

            $data = array_merge($data, $result);
        }

        // arrange the array
        return $data;
    }


    public function singleAssignment($assignment_id, $student_id)
    {
        $em = $this->getEntityManager();

        $student = $em->getRepository('Student')->getStudentByIdNew($student_id);
        $all_subjects = $student['subjects'];

        $subjects = [];
        foreach ($all_subjects as $as) {
            array_push($subjects, $as['value']);
        }

        $today = date('d-m-Y');

        $data = [];

        $sql = "SELECT r.id,r.course,r.stream,r.course_type,r.semester,r.sub_code,r.title,r.description,r.created_by,r.entry_date,r.upload_info,r.time_stamp,r.last_date,s.sub_name,u.name FROM assignment r, subject_master s, employee u WHERE r.created_by=u.email AND r.sub_code=s.sub_code AND  r.id=:id AND STR_TO_DATE(r.last_date,'%d-%m-%Y')>=STR_TO_DATE(:today,'%d-%m-%Y')";
        $stmt = $this->getEntityManager()->getConnection()->prepare($sql);
        $stmt->bindParam(':id', $assignment_id, PDO::PARAM_INT);
        $stmt->bindParam(':today', $today, PDO::PARAM_STR);
        $stmt->execute();
        $result = $stmt->fetchAll();
        

        if (sizeof($result) > 0) {

            $res = $result[0];

            if (in_array($res['sub_code'], $subjects)) {
                $uu = json_decode($res['upload_info'], true);
                $res['upload_info'] = $this->getEntityManager()->getRepository('ClassNotes')->getUrls($uu); 
                $b = [];
                $b['status'] = true;
                $b['status_text'] = $res;
                return $b;
            } else {
                $b = [];
                $b['status'] = false;
                $b['status_text'] = 'You cannot submit this assignment anymore';
                return $b;
            }
            return $data;
        } else {
            $b = [];
            $b['status'] = false;
            $b['status_text'] = 'You cannot submit this assignment anymore';
            return $b;
        }
    }


    
}
