<?php

/**
 * @Entity(repositoryClass="AssignmentSubmissionRepository") @Table(name="assignment_submission")
 */

class AssignmentSubmission
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @ManyToOne(targetEntity="Assignment", inversedBy="submitted_students")
     * @JoinColumn(name="assignment_id", referencedColumnName="id")
     */
    protected $assignment;

    /**
     * @Column(type="integer",length=11, nullable=true)
     */
    protected $assignment_id;

    /**
     * @Column(type="integer",length=11, nullable=true)
     */
    protected $student_id;


    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $submission_date;

    /**
     * @Column(type="text", nullable=true)
     */
    protected $assignment_text;


    /**
     * @Column(type="json_array", nullable=true)
     */
    protected $upload_info;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $time_stamp;

    /**
     * @Column(type="integer",length=2, nullable=true, options={"default":0})
     */
    protected $checked;

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set assignmentId.
     *
     * @param int|null $assignmentId
     *
     * @return AssignmentSubmission
     */
    public function setAssignmentId($assignmentId = null)
    {
        $this->assignment_id = $assignmentId;

        return $this;
    }

    /**
     * Get assignmentId.
     *
     * @return int|null
     */
    public function getAssignmentId()
    {
        return $this->assignment_id;
    }

    /**
     * Set studentId.
     *
     * @param int|null $studentId
     *
     * @return AssignmentSubmission
     */
    public function setStudentId($studentId = null)
    {
        $this->student_id = $studentId;

        return $this;
    }

    /**
     * Get studentId.
     *
     * @return int|null
     */
    public function getStudentId()
    {
        return $this->student_id;
    }

    /**
     * Set submissionDate.
     *
     * @param string|null $submissionDate
     *
     * @return AssignmentSubmission
     */
    public function setSubmissionDate($submissionDate = null)
    {
        $this->submission_date = $submissionDate;

        return $this;
    }

    /**
     * Get submissionDate.
     *
     * @return string|null
     */
    public function getSubmissionDate()
    {
        return $this->submission_date;
    }

    /**
     * Set assignmentText.
     *
     * @param string|null $assignmentText
     *
     * @return AssignmentSubmission
     */
    public function setAssignmentText($assignmentText = null)
    {
        $this->assignment_text = $assignmentText;

        return $this;
    }

    /**
     * Get assignmentText.
     *
     * @return string|null
     */
    public function getAssignmentText()
    {
        return $this->assignment_text;
    }

    /**
     * Set uploadInfo.
     *
     * @param array|null $uploadInfo
     *
     * @return AssignmentSubmission
     */
    public function setUploadInfo($uploadInfo = null)
    {
        $this->upload_info = $uploadInfo;

        return $this;
    }

    /**
     * Get uploadInfo.
     *
     * @return array|null
     */
    public function getUploadInfo()
    {
        return $this->upload_info;
    }

    /**
     * Set timeStamp.
     *
     * @param string|null $timeStamp
     *
     * @return AssignmentSubmission
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->time_stamp = $timeStamp;

        return $this;
    }

    /**
     * Get timeStamp.
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->time_stamp;
    }

    /**
     * Set assignment.
     *
     * @param \Assignment|null $assignment
     *
     * @return AssignmentSubmission
     */
    public function setAssignment(\Assignment $assignment = null)
    {
        $this->assignment = $assignment;

        return $this;
    }

    /**
     * Get assignment.
     *
     * @return \Assignment|null
     */
    public function getAssignment()
    {
        return $this->assignment;
    }

    public function toArray() {
        return get_object_vars($this);
    }

    /**
     * Set checked.
     *
     * @param int|null $checked
     *
     * @return AssignmentSubmission
     */
    public function setChecked($checked = null)
    {
        $this->checked = $checked;

        return $this;
    }

    /**
     * Get checked.
     *
     * @return int|null
     */
    public function getChecked()
    {
        return $this->checked;
    }
}
