<?php

/**
 * @Entity(repositoryClass="AttendanceRepository") @Table(name="attendance")
 */

class Attendance
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $stream;

    /**
     * @Column(type="string",length=10, nullable=true)
     */
    protected $section;

    /**
     * @Column(type="string",length=80, nullable=true)
     */
    protected $sub_code;


    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $paper_code;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $by_username;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $dept_code;

    /**
     * @Column(type="text", nullable=true)
     */
    protected $topic;

    /**
     * @Column(type="string", nullable=true, length=30)
     */
    protected $date1;

    /**
     * @Column(type="integer", nullable=true, length=11)
     */
    protected $period_number;

    /**
     * @Column(type="string", nullable=true, length=10)
     */
    protected $day;

    /**
     * @Column(type="integer",length=11)
     */
    protected $semester;

    /**
     * @Column(type="json_array")
     */
    protected $attendance;

    /**
     * @Column(type="json_array")
     */
    protected $photo;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $time_stamp;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $session;

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return Attendance
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set stream.
     *
     * @param string|null $stream
     *
     * @return Attendance
     */
    public function setStream($stream = null)
    {
        $this->stream = $stream;

        return $this;
    }

    /**
     * Get stream.
     *
     * @return string|null
     */
    public function getStream()
    {
        return $this->stream;
    }

    /**
     * Set subCode.
     *
     * @param string|null $subCode
     *
     * @return Attendance
     */
    public function setSubCode($subCode = null)
    {
        $this->sub_code = $subCode;

        return $this;
    }

    /**
     * Get subCode.
     *
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->sub_code;
    }

    /**
     * Set byUsername.
     *
     * @param string|null $byUsername
     *
     * @return Attendance
     */
    public function setByUsername($byUsername = null)
    {
        $this->by_username = $byUsername;

        return $this;
    }

    /**
     * Get byUsername.
     *
     * @return string|null
     */
    public function getByUsername()
    {
        return $this->by_username;
    }

    /**
     * Set deptCode.
     *
     * @param string|null $deptCode
     *
     * @return Attendance
     */
    public function setDeptCode($deptCode = null)
    {
        $this->dept_code = $deptCode;

        return $this;
    }

    /**
     * Get deptCode.
     *
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->dept_code;
    }

    /**
     * Set topic.
     *
     * @param string|null $topic
     *
     * @return Attendance
     */
    public function setTopic($topic = null)
    {
        $this->topic = $topic;

        return $this;
    }

    /**
     * Get topic.
     *
     * @return string|null
     */
    public function getTopic()
    {
        return $this->topic;
    }

    /**
     * Set date1.
     *
     * @param string|null $date1
     *
     * @return Attendance
     */
    public function setDate1($date1 = null)
    {
        $this->date1 = $date1;

        return $this;
    }

    /**
     * Get date1.
     *
     * @return string|null
     */
    public function getDate1()
    {
        return $this->date1;
    }

    /**
     * Set semester.
     *
     * @param int $semester
     *
     * @return Attendance
     */
    public function setSemester($semester)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return int
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set attendance.
     *
     * @param array $attendance
     *
     * @return Attendance
     */
    public function setAttendance($attendance)
    {
        $this->attendance = $attendance;

        return $this;
    }

    /**
     * Get attendance.
     *
     * @return array
     */
    public function getAttendance()
    {
        return $this->attendance;
    }

    /**
     * Set timeStamp.
     *
     * @param string|null $timeStamp
     *
     * @return Attendance
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->time_stamp = $timeStamp;

        return $this;
    }

    /**
     * Get timeStamp.
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->time_stamp;
    }

    /**
     * Set session.
     *
     * @param string|null $session
     *
     * @return Attendance
     */
    public function setSession($session = null)
    {
        $this->session = $session;

        return $this;
    }

    /**
     * Get session.
     *
     * @return string|null
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Set photo.
     *
     * @param array $photo
     *
     * @return Attendance
     */
    public function setPhoto($photo)
    {
        $this->photo = $photo;

        return $this;
    }

    /**
     * Get photo.
     *
     * @return array
     */
    public function getPhoto()
    {
        return $this->photo;
    }

    /**
     * Set day.
     *
     * @param string|null $day
     *
     * @return Attendance
     */
    public function setDay($day = null)
    {
        $this->day = $day;

        return $this;
    }

    /**
     * Get day.
     *
     * @return string|null
     */
    public function getDay()
    {
        return $this->day;
    }

    /**
     * Set periodNumber.
     *
     * @param int|null $periodNumber
     *
     * @return Attendance
     */
    public function setPeriodNumber($periodNumber = null)
    {
        $this->period_number = $periodNumber;

        return $this;
    }

    /**
     * Get periodNumber.
     *
     * @return int|null
     */
    public function getPeriodNumber()
    {
        return $this->period_number;
    }

    /**
     * Set section.
     *
     * @param string|null $section
     *
     * @return Attendance
     */
    public function setSection($section = null)
    {
        $this->section = $section;

        return $this;
    }

    /**
     * Get section.
     *
     * @return string|null
     */
    public function getSection()
    {
        return $this->section;
    }

    /**
     * Set paperCode.
     *
     * @param string|null $paperCode
     *
     * @return Attendance
     */
    public function setPaperCode($paperCode = null)
    {
        $this->paper_code = $paperCode;

        return $this;
    }

    /**
     * Get paperCode.
     *
     * @return string|null
     */
    public function getPaperCode()
    {
        return $this->paper_code;
    }
}
