<?php

/**
 * @Entity(repositoryClass="CertificateRepository") @Table(name="certificate")
 */

class Certificate
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $type;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $from_no;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $slr_no;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $entry_date;

    /**
     * @Column(type="string",length=200, nullable=true)
     */
    protected $name;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $roll;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $no;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $part;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $year;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $major;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $division;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $time_stamp;


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set type.
     *
     * @param string|null $type
     *
     * @return Certificate
     */
    public function setType($type = null)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type.
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set fromNo.
     *
     * @param string|null $fromNo
     *
     * @return Certificate
     */
    public function setFromNo($fromNo = null)
    {
        $this->from_no = $fromNo;

        return $this;
    }

    /**
     * Get fromNo.
     *
     * @return string|null
     */
    public function getFromNo()
    {
        return $this->from_no;
    }

    /**
     * Set slrNo.
     *
     * @param string|null $slrNo
     *
     * @return Certificate
     */
    public function setSlrNo($slrNo = null)
    {
        $this->slr_no = $slrNo;

        return $this;
    }

    /**
     * Get slrNo.
     *
     * @return string|null
     */
    public function getSlrNo()
    {
        return $this->slr_no;
    }

    /**
     * Set entryDate.
     *
     * @param string|null $entryDate
     *
     * @return Certificate
     */
    public function setEntryDate($entryDate = null)
    {
        $this->entry_date = $entryDate;

        return $this;
    }

    /**
     * Get entryDate.
     *
     * @return string|null
     */
    public function getEntryDate()
    {
        return $this->entry_date;
    }

    /**
     * Set name.
     *
     * @param string|null $name
     *
     * @return Certificate
     */
    public function setName($name = null)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set roll.
     *
     * @param string|null $roll
     *
     * @return Certificate
     */
    public function setRoll($roll = null)
    {
        $this->roll = $roll;

        return $this;
    }

    /**
     * Get roll.
     *
     * @return string|null
     */
    public function getRoll()
    {
        return $this->roll;
    }

    /**
     * Set no.
     *
     * @param string|null $no
     *
     * @return Certificate
     */
    public function setNo($no = null)
    {
        $this->no = $no;

        return $this;
    }

    /**
     * Get no.
     *
     * @return string|null
     */
    public function getNo()
    {
        return $this->no;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return Certificate
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set part.
     *
     * @param string|null $part
     *
     * @return Certificate
     */
    public function setPart($part = null)
    {
        $this->part = $part;

        return $this;
    }

    /**
     * Get part.
     *
     * @return string|null
     */
    public function getPart()
    {
        return $this->part;
    }

    /**
     * Set year.
     *
     * @param string|null $year
     *
     * @return Certificate
     */
    public function setYear($year = null)
    {
        $this->year = $year;

        return $this;
    }

    /**
     * Get year.
     *
     * @return string|null
     */
    public function getYear()
    {
        return $this->year;
    }

    /**
     * Set major.
     *
     * @param string|null $major
     *
     * @return Certificate
     */
    public function setMajor($major = null)
    {
        $this->major = $major;

        return $this;
    }

    /**
     * Get major.
     *
     * @return string|null
     */
    public function getMajor()
    {
        return $this->major;
    }

    /**
     * Set division.
     *
     * @param string|null $division
     *
     * @return Certificate
     */
    public function setDivision($division = null)
    {
        $this->division = $division;

        return $this;
    }

    /**
     * Get division.
     *
     * @return string|null
     */
    public function getDivision()
    {
        return $this->division;
    }

    /**
     * Set timeStamp.
     *
     * @param string|null $timeStamp
     *
     * @return Certificate
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->time_stamp = $timeStamp;

        return $this;
    }

    /**
     * Get timeStamp.
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->time_stamp;
    }
}
