<?php

/**
 * @Entity(repositoryClass="CertificateRequestRepository") @Table(name="certificate_request")
 */

class CertificateRequest
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $student_id;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $certificate_id;

    /**
     * @Column(type="string",length=200, nullable=true)
     */
    protected $name;

    /**
     * @Column(type="string",length=200, nullable=true)
     */
    protected $father_name;

    /**
     * @Column(type="string",length=200, nullable=true)
     */
    protected $mother_name;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $gender;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $address;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=10, nullable=true)
     */
    protected $semester;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $roll_no;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $university_roll_no;

    /**
     * @Column(type="integer",options={"default:0"})
     */
    protected $status=0;

    
    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $time_stamp;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $cancel_reason;



    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set studentId.
     *
     * @param string|null $studentId
     *
     * @return CertificateRequest
     */
    public function setStudentId($studentId = null)
    {
        $this->student_id = $studentId;

        return $this;
    }

    /**
     * Get studentId.
     *
     * @return string|null
     */
    public function getStudentId()
    {
        return $this->student_id;
    }

    /**
     * Set certificateId.
     *
     * @param string|null $certificateId
     *
     * @return CertificateRequest
     */
    public function setCertificateId($certificateId = null)
    {
        $this->certificate_id = $certificateId;

        return $this;
    }

    /**
     * Get certificateId.
     *
     * @return string|null
     */
    public function getCertificateId()
    {
        return $this->certificate_id;
    }

    /**
     * Set name.
     *
     * @param string|null $name
     *
     * @return CertificateRequest
     */
    public function setName($name = null)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set fatherName.
     *
     * @param string|null $fatherName
     *
     * @return CertificateRequest
     */
    public function setFatherName($fatherName = null)
    {
        $this->father_name = $fatherName;

        return $this;
    }

    /**
     * Get fatherName.
     *
     * @return string|null
     */
    public function getFatherName()
    {
        return $this->father_name;
    }

    /**
     * Set motherName.
     *
     * @param string|null $motherName
     *
     * @return CertificateRequest
     */
    public function setMotherName($motherName = null)
    {
        $this->mother_name = $motherName;

        return $this;
    }

    /**
     * Get motherName.
     *
     * @return string|null
     */
    public function getMotherName()
    {
        return $this->mother_name;
    }

    /**
     * Set gender.
     *
     * @param string|null $gender
     *
     * @return CertificateRequest
     */
    public function setGender($gender = null)
    {
        $this->gender = $gender;

        return $this;
    }

    /**
     * Get gender.
     *
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Set address.
     *
     * @param string|null $address
     *
     * @return CertificateRequest
     */
    public function setAddress($address = null)
    {
        $this->address = $address;

        return $this;
    }

    /**
     * Get address.
     *
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return CertificateRequest
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set semester.
     *
     * @param string|null $semester
     *
     * @return CertificateRequest
     */
    public function setSemester($semester = null)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return string|null
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set rollNo.
     *
     * @param string|null $rollNo
     *
     * @return CertificateRequest
     */
    public function setRollNo($rollNo = null)
    {
        $this->roll_no = $rollNo;

        return $this;
    }

    /**
     * Get rollNo.
     *
     * @return string|null
     */
    public function getRollNo()
    {
        return $this->roll_no;
    }

    /**
     * Set universityRollNo.
     *
     * @param string|null $universityRollNo
     *
     * @return CertificateRequest
     */
    public function setUniversityRollNo($universityRollNo = null)
    {
        $this->university_roll_no = $universityRollNo;

        return $this;
    }

    /**
     * Get universityRollNo.
     *
     * @return string|null
     */
    public function getUniversityRollNo()
    {
        return $this->university_roll_no;
    }

    /**
     * Set status.
     *
     * @param int $status
     *
     * @return CertificateRequest
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status.
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set timeStamp.
     *
     * @param string|null $timeStamp
     *
     * @return CertificateRequest
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->time_stamp = $timeStamp;

        return $this;
    }

    /**
     * Get timeStamp.
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->time_stamp;
    }

    /**
     * Set cancelReason.
     *
     * @param string|null $cancelReason
     *
     * @return CertificateRequest
     */
    public function setCancelReason($cancelReason = null)
    {
        $this->cancel_reason = $cancelReason;

        return $this;
    }

    /**
     * Get cancelReason.
     *
     * @return string|null
     */
    public function getCancelReason()
    {
        return $this->cancel_reason;
    }
}
