<?php

use Doctrine\ORM\EntityRepository;

class ClassAssignmentRepository extends EntityRepository
{
    public function countAssigned($date, $teacher)
    {
        if ($teacher == '') {
            return 0;

        } else {
            $dql = "SELECT count(r.id) as c FROM ClassAssignment r WHERE r.date1=:date1 AND r.teacher=:teacher";
            $query = $this->getEntityManager()->createQuery($dql)->setParameter('date1', $date)->setParameter('teacher', $teacher);
            $r = $query->getResult();
            return $r[0]['c'];

        }

    }

    public function addAssignedClass($email, $body)
    {
        $entityManager = $this->getEntityManager();
        $course = addslashes(strip_tags(trim($body['course'])));
        $stream = addslashes(strip_tags(trim($body['stream'])));
        $sub_code = addslashes(strip_tags(trim($body['sub_code'])));
        $semester = addslashes(strip_tags(trim($body['semester'])));
        $session = addslashes(strip_tags(trim($body['session'])));
        $day = addslashes(strip_tags(trim($body['day'])));
        $teacher = addslashes(strip_tags(trim($body['teacher'])));
        $assigned_by = addslashes(strip_tags(trim($body['assigned_by'])));
        $room_number = addslashes(strip_tags(trim($body['room_number'])));
        $period = addslashes(strip_tags(trim($body['period_number'])));
        $start_time = addslashes(strip_tags(trim($body['start_time'])));
        $end_time = addslashes(strip_tags(trim($body['end_time'])));
        $section = addslashes(strip_tags(trim($body['section'])));
        $date1 = date('d-m-Y');
        if (sizeof($this->checkAssignedClass($body)) == 0) {
            $routine = new ClassAssignment();
            $routine->setSession($session);
            $routine->setCourse($course);
            $routine->setStream($stream);
            $routine->setSubCode($sub_code);
            $routine->setTeacher($teacher);
            $routine->setAssignedBy($email);
            $routine->setDay($day);
            $routine->setSemester($semester);
            $routine->setRoomNumber($room_number);
            $routine->setPeriodNumber($period);
            $routine->setStartTime($start_time);
            $routine->setEndTime($end_time);
            $routine->setDate1($date1);
            $routine->setSection($section);
            $entityManager->persist($routine);
            $entityManager->flush();
            return 'Class Assigned Successfully';
        } else {
            return 'Already Exists';
        }

    }

    public function getRoutine()
    {
        $dql = "SELECT r.id,r.session,r.course,r.stream,r.sub_code,r.teacher,r.day,r.semester,r.room_number,r.period_number,r.start_time,r.end_time,s.name as teacher_name FROM Routine r, Employee s WHERE r.teacher=s.email";
        $query = $this->getEntityManager()->createQuery($dql);
        return $query->getResult();
    }
    private function getRoutineForEdit($id)
    {
        $dql = "SELECT r From Routine r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function getRoutineSingle($id)
    {
        $dql = "SELECT r.id,r.session,r.course,r.stream,r.sub_code,r.teacher,r.day,r.semester,r.room_number,r.period_number,r.start_time,r.end_time FROM Routine r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();

    }

    public function getAssignedClass($email, $current_session)
    {
        $day = date('D');
        $date1 = date('d-m-Y');
        $dql = "SELECT r.id,r.session,r.course,r.stream,r.sub_code,r.teacher,r.day,r.semester,r.room_number,r.period_number,r.start_time,r.end_time,r.assigned_by,r.date1, r.section,s.sub_name,u.dept_code FROM ClassAssignment r,SubjectMaster s, Employee u WHERE r.teacher=u.email AND r.teacher=:teacher AND r.sub_code=s.sub_code AND r.day=:day AND r.date1=:date1  ORDER BY r.day";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('teacher', $email)
            ->setParameter('date1', $date1)
            ->setParameter('day', $day);
        $result = $query->getResult();

        $entityManager = $this->getEntityManager();

        $index = 0;
        foreach ($result as $r) {
            $result[$index]['nos'] = $entityManager->getRepository('Employee')->countClasses($email, $r, $current_session);
            $result[$index]['status'] = $entityManager->getRepository('Employee')->checkAttendance($email, $r, $current_session);
            $result[$index]['cancel'] = $entityManager->getRepository('ClassCancel')->checkCancelClassForStatus($r);
            $result[$index]['assignment'] = 0;
            $index++;
        }

        return $result;
    }

    public function UpdateRoutine($id, $body)
    {
        $entityManager = $this->getEntityManager();
        $course = addslashes(strip_tags(trim($body['course'])));
        $stream = addslashes(strip_tags(trim($body['stream'])));
        $sub_code = addslashes(strip_tags(trim($body['sub_code'])));
        $semester = addslashes(strip_tags(trim($body['semester'])));
        $session = addslashes(strip_tags(trim($body['session'])));
        $day = addslashes(strip_tags(trim($body['day'])));
        $teacher = addslashes(strip_tags(trim($body['teacher'])));
        $room_number = addslashes(strip_tags(trim($body['room_number'])));
        $period = addslashes(strip_tags(trim($body['period_number'])));
        $start_time = addslashes(strip_tags(trim($body['start_time'])));
        $end_time = addslashes(strip_tags(trim($body['end_time'])));

        $result = $this->getRoutineForEdit($id);

        if (sizeof($result) == 1) {
            $result[0]->setSession($session);
            $result[0]->setCourse($course);
            $result[0]->setStream($stream);
            $result[0]->setSubCode($sub_code);
            $result[0]->setTeacher($teacher);
            $result[0]->setDay($day);
            $result[0]->setSemester($semester);
            $result[0]->setRoomNumber($room_number);
            $result[0]->setPeriodNumber($period);
            $result[0]->setStartTime($start_time);
            $result[0]->setEndTime($end_time);
            $entityManager->persist($result[0]);
            $entityManager->flush();
            return "Routine Updated Successfully.";
        } else {
            return "Not Found.";
        }

    }

    public function checkAssignedClass($body)
    {

        $course = addslashes(strip_tags(trim($body['course'])));
        $stream = addslashes(strip_tags(trim($body['stream'])));
        $sub_code = addslashes(strip_tags(trim($body['sub_code'])));
        $semester = addslashes(strip_tags(trim($body['semester'])));
        $session = addslashes(strip_tags(trim($body['session'])));
        $day = addslashes(strip_tags(trim($body['day'])));
        $teacher = addslashes(strip_tags(trim($body['teacher'])));
        $assigned_by = addslashes(strip_tags(trim($body['assigned_by'])));
        $room_number = addslashes(strip_tags(trim($body['room_number'])));
        $period = addslashes(strip_tags(trim($body['period_number'])));
        $start_time = addslashes(strip_tags(trim($body['start_time'])));
        $end_time = addslashes(strip_tags(trim($body['end_time'])));
        $date1 = date('d-m-Y');

        $dql = 'SELECT r FROM ClassAssignment r WHERE r.course=:course AND r.stream=:stream AND r.sub_code=:sub_code AND r.semester=:semester AND r.session=:session AND r.day=:day AND r.teacher=:teacher AND r.period_number=:period AND r.start_time=:start_time AND r.end_time=:end_time AND r.assigned_by=:assigned_by AND r.date1=:date1';
        $query = $this->getEntityManager()
            ->createQuery($dql)
            ->setParameter('course', $course)
            ->setParameter('stream', $stream)
            ->setParameter('sub_code', $sub_code)
            ->setParameter('semester', $semester)
            ->setParameter('session', $session)
            ->setParameter('day', $day)
            ->setParameter('teacher', $teacher)
            ->setParameter('assigned_by', $assigned_by)
            ->setParameter('start_time', $start_time)
            ->setParameter('end_time', $end_time)
            ->setParameter('date1', $date1)
            ->setParameter('period', $period);
        return $query->getResult();
    }

    public function checkAssignedClassForStatus($body)
    {

        $course = addslashes(strip_tags(trim($body['course'])));
        
        $sub_code = addslashes(strip_tags(trim($body['sub_code'])));
        $semester = addslashes(strip_tags(trim($body['semester'])));
        $session = addslashes(strip_tags(trim($body['session'])));
        $day = addslashes(strip_tags(trim($body['day'])));
        $assigned_by = addslashes(strip_tags(trim($body['teacher'])));
        $room_number = addslashes(strip_tags(trim($body['room_number'])));
        $period = addslashes(strip_tags(trim($body['period_number'])));
        $start_time = addslashes(strip_tags(trim($body['start_time'])));
        $end_time = addslashes(strip_tags(trim($body['end_time'])));
        $date1 = date('d-m-Y');

        $dql = 'SELECT r FROM ClassAssignment r WHERE r.course=:course AND r.sub_code=:sub_code AND r.semester=:semester AND r.session=:session AND r.day=:day AND r.period_number=:period AND r.start_time=:start_time AND r.end_time=:end_time AND r.assigned_by=:assigned_by AND r.date1=:date1';
        $query = $this->getEntityManager()
            ->createQuery($dql)
            ->setParameter('course', $course)
            
            ->setParameter('sub_code', $sub_code)
            ->setParameter('semester', $semester)
            ->setParameter('session', $session)
            ->setParameter('day', $day)
            ->setParameter('assigned_by', $assigned_by)
            ->setParameter('start_time', $start_time)
            ->setParameter('end_time', $end_time)
            ->setParameter('date1', $date1)
            ->setParameter('period', $period);
        return sizeof($query->getResult());
    }

    public function deleteRoutine($id)
    {
        $dql = 'DELETE FROM Routine r WHERE r.id=:id';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $query->getResult();
        return true;
    }
}
