<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="ClassNotesRepository") @Table(name="class_notes")
 */

class ClassNotes
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $course;


    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $course_type;

    /**
     * @Column(type="integer",length=11, nullable=true)
     */
    protected $semester;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $sub_code;


    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $entry_date;


    /**
     * @Column(type="string",length=300, nullable=true)
     */
    protected $title;

    /**
     * @Column(type="string",length=300, nullable=true)
     */
    protected $description;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $created_by;

    /**
     * @Column(type="json_array", nullable=true)
     */
    protected $upload_info;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $time_stamp;

    


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return ClassNotes
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set stream.
     *
     * @param string|null $stream
     *
     * @return ClassNotes
     */
    public function setStream($stream = null)
    {
        $this->stream = $stream;

        return $this;
    }

    /**
     * Get stream.
     *
     * @return string|null
     */
    public function getStream()
    {
        return $this->stream;
    }

    /**
     * Set courseType.
     *
     * @param string|null $courseType
     *
     * @return ClassNotes
     */
    public function setCourseType($courseType = null)
    {
        $this->course_type = $courseType;

        return $this;
    }

    /**
     * Get courseType.
     *
     * @return string|null
     */
    public function getCourseType()
    {
        return $this->course_type;
    }

    /**
     * Set semester.
     *
     * @param int|null $semester
     *
     * @return ClassNotes
     */
    public function setSemester($semester = null)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return int|null
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set subCode.
     *
     * @param string|null $subCode
     *
     * @return ClassNotes
     */
    public function setSubCode($subCode = null)
    {
        $this->sub_code = $subCode;

        return $this;
    }

    /**
     * Get subCode.
     *
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->sub_code;
    }

    /**
     * Set entryDate.
     *
     * @param string|null $entryDate
     *
     * @return ClassNotes
     */
    public function setEntryDate($entryDate = null)
    {
        $this->entry_date = $entryDate;

        return $this;
    }

    /**
     * Get entryDate.
     *
     * @return string|null
     */
    public function getEntryDate()
    {
        return $this->entry_date;
    }

    /**
     * Set title.
     *
     * @param string|null $title
     *
     * @return ClassNotes
     */
    public function setTitle($title = null)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title.
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set description.
     *
     * @param string|null $description
     *
     * @return ClassNotes
     */
    public function setDescription($description = null)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description.
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set createdBy.
     *
     * @param string|null $createdBy
     *
     * @return ClassNotes
     */
    public function setCreatedBy($createdBy = null)
    {
        $this->created_by = $createdBy;

        return $this;
    }

    /**
     * Get createdBy.
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->created_by;
    }

    /**
     * Set uploadInfo.
     *
     * @param array|null $uploadInfo
     *
     * @return ClassNotes
     */
    public function setUploadInfo($uploadInfo = null)
    {
        $this->upload_info = $uploadInfo;

        return $this;
    }

    /**
     * Get uploadInfo.
     *
     * @return array|null
     */
    public function getUploadInfo()
    {
        return $this->upload_info;
    }

    /**
     * Set timeStamp.
     *
     * @param string|null $timeStamp
     *
     * @return ClassNotes
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->time_stamp = $timeStamp;

        return $this;
    }

    /**
     * Get timeStamp.
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->time_stamp;
    }
}
