<?php

use Doctrine\ORM\EntityRepository;

class ClassNotesRepository extends EntityRepository
{

    

    public function getMyClassNotes($student, $student_id)
    {

        $today = date('d-m-Y');
       
        $data = [];
        foreach ($student['subjects'] as $subject) {
            $sql = "SELECT r.id,r.course,r.course_type,r.semester,r.sub_code,r.title,r.created_by,r.entry_date,r.upload_info,r.time_stamp,s.sub_name,u.name FROM class_notes r, subject_master s, employee u WHERE r.created_by=u.email AND r.sub_code=s.sub_code  AND r.sub_code=:sub_code AND r.course=:course AND r.semester=:semester AND r.course_type=:course_type ORDER BY r.id DESC";
            $stmt = $this->getEntityManager()->getConnection()->prepare($sql);
            $stmt->bindParam(':sub_code', $subject['sub_code'], PDO::PARAM_STR);
            $stmt->bindParam(':course', $student['course'], PDO::PARAM_STR);
        
            $stmt->bindParam(':course_type', $student['course_type'], PDO::PARAM_STR);
            $stmt->bindParam(':semester', $student['semester'], PDO::PARAM_INT);
            $stmt->execute();
            $result = $stmt->fetchAll();
            $index = 0;
            foreach ($result as $r) {
                $upload_info = json_decode($r['upload_info'], true);
                $result[$index]['upload_info'] = $this->getUrls($upload_info);
                $index++;
            }

            $data = array_merge($data, $result);
        }

        // arrange the array
        return $data;
    }


    public function getUrls($upload_info)
    {

        //$baseURL = 'https://filecdn.bhcollege.ac.in';
        //$baseURL = 'http://localhost/demo-college/api/src/uploads';
        $baseURL = 'https://backend.pragjyotishcollege.ac.in/src/uploads';

        $data = [];
        if (is_array($upload_info)) {
            foreach ($upload_info as $ui) {
                $file_id = $ui['file_id'];
                $sql = "SELECT r.id,r.type,r.path FROM master_file r WHERE r.file_id=:file_id ";
                $stmt = $this->getEntityManager()->getConnection()->prepare($sql);
                $stmt->bindParam(':file_id', $file_id, PDO::PARAM_STR);
                $stmt->execute();
                $result = $stmt->fetchAll();
                if(sizeof($result)> 0){
                    $link = $baseURL . '/' . $result[0]['type'] . '/' . $result[0]['path'];
                    array_push($data, $link);
                }
                
            }
        }
        return $data;
    }
   
}
