<?php

/**
 * @Entity(repositoryClass="ClasstestRepository") @Table(name="classtest")
 */

class Classtest
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $type;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $date;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $stream;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $sub_code;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $course_type;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $paper_code;

    /**
     * @Column(type="integer",length=10, nullable=true)
     */
    protected $semester;

    /**
     * @Column(type="string",length=20, nullable=true)
     */
    protected $section;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $teacher;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $total_marks;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $pass_marks;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $entry_date;

    /**
     * @Column(type="json_array", nullable=true)
     */
    protected $marks;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $time_stamp;




    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set type.
     *
     * @param string|null $type
     *
     * @return Classtest
     */
    public function setType($type = null)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type.
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set date.
     *
     * @param string|null $date
     *
     * @return Classtest
     */
    public function setDate($date = null)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * Get date.
     *
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Set subCode.
     *
     * @param string|null $subCode
     *
     * @return Classtest
     */
    public function setSubCode($subCode = null)
    {
        $this->sub_code = $subCode;

        return $this;
    }

    /**
     * Get subCode.
     *
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->sub_code;
    }

    /**
     * Set courseType.
     *
     * @param string|null $courseType
     *
     * @return Classtest
     */
    public function setCourseType($courseType = null)
    {
        $this->course_type = $courseType;

        return $this;
    }

    /**
     * Get courseType.
     *
     * @return string|null
     */
    public function getCourseType()
    {
        return $this->course_type;
    }

    /**
     * Set semester.
     *
     * @param int|null $semester
     *
     * @return Classtest
     */
    public function setSemester($semester = null)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return int|null
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set teacher.
     *
     * @param string|null $teacher
     *
     * @return Classtest
     */
    public function setTeacher($teacher = null)
    {
        $this->teacher = $teacher;

        return $this;
    }

    /**
     * Get teacher.
     *
     * @return string|null
     */
    public function getTeacher()
    {
        return $this->teacher;
    }

    /**
     * Set totalMarks.
     *
     * @param string|null $totalMarks
     *
     * @return Classtest
     */
    public function setTotalMarks($totalMarks = null)
    {
        $this->total_marks = $totalMarks;

        return $this;
    }

    /**
     * Get totalMarks.
     *
     * @return string|null
     */
    public function getTotalMarks()
    {
        return $this->total_marks;
    }

    /**
     * Set passMarks.
     *
     * @param string|null $passMarks
     *
     * @return Classtest
     */
    public function setPassMarks($passMarks = null)
    {
        $this->pass_marks = $passMarks;

        return $this;
    }

    /**
     * Get passMarks.
     *
     * @return string|null
     */
    public function getPassMarks()
    {
        return $this->pass_marks;
    }

    /**
     * Set entryDate.
     *
     * @param string|null $entryDate
     *
     * @return Classtest
     */
    public function setEntryDate($entryDate = null)
    {
        $this->entry_date = $entryDate;

        return $this;
    }

    /**
     * Get entryDate.
     *
     * @return string|null
     */
    public function getEntryDate()
    {
        return $this->entry_date;
    }

    /**
     * Set marks.
     *
     * @param array|null $marks
     *
     * @return Classtest
     */
    public function setMarks($marks = null)
    {
        $this->marks = $marks;

        return $this;
    }

    /**
     * Get marks.
     *
     * @return array|null
     */
    public function getMarks()
    {
        return $this->marks;
    }

    /**
     * Set timeStamp.
     *
     * @param string|null $timeStamp
     *
     * @return Classtest
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->time_stamp = $timeStamp;

        return $this;
    }

    /**
     * Get timeStamp.
     *
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->time_stamp;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return Classtest
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set stream.
     *
     * @param string|null $stream
     *
     * @return Classtest
     */
    public function setStream($stream = null)
    {
        $this->stream = $stream;

        return $this;
    }

    /**
     * Get stream.
     *
     * @return string|null
     */
    public function getStream()
    {
        return $this->stream;
    }

    /**
     * Set section.
     *
     * @param string|null $section
     *
     * @return Classtest
     */
    public function setSection($section = null)
    {
        $this->section = $section;

        return $this;
    }

    /**
     * Get section.
     *
     * @return string|null
     */
    public function getSection()
    {
        return $this->section;
    }

    /**
     * Set paperCode.
     *
     * @param string|null $paperCode
     *
     * @return Classtest
     */
    public function setPaperCode($paperCode = null)
    {
        $this->paper_code = $paperCode;

        return $this;
    }

    /**
     * Get paperCode.
     *
     * @return string|null
     */
    public function getPaperCode()
    {
        return $this->paper_code;
    }
}
