<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="CourseRepository") @Table(name="course")
 */

class Course
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=30)
     */
    protected $name;

    /**
     * @Column(type="string",length=200)
     */
    protected $label;
     
     /**
     * @Column(type="string",length=10)
     */
    protected $tenure;

    /**
     * @Column(type="integer")
     */
    protected $no_of_term;

    

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return Course
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set tenure.
     *
     * @param string $tenure
     *
     * @return Course
     */
    public function setTenure($tenure)
    {
        $this->tenure = $tenure;

        return $this;
    }

    /**
     * Get tenure.
     *
     * @return string
     */
    public function getTenure()
    {
        return $this->tenure;
    }

    /**
     * Set noOfTerm.
     *
     * @param int $noOfTerm
     *
     * @return Course
     */
    public function setNoOfTerm($noOfTerm)
    {
        $this->no_of_term = $noOfTerm;

        return $this;
    }

    /**
     * Get noOfTerm.
     *
     * @return int
     */
    public function getNoOfTerm()
    {
        return $this->no_of_term;
    }

   

    /**
     * Set label.
     *
     * @param string $label
     *
     * @return Course
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label.
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }
}
