<?php

use Doctrine\ORM\EntityRepository;

class CourseRepository extends EntityRepository
{

    public function addCourse($body)
    {
        $entityManager = $this->getEntityManager();
        $name = addslashes(strip_tags(trim($body['name'])));
        $label = addslashes(strip_tags(trim($body['label'])));
        $tenure = addslashes(strip_tags(trim($body['tenure'])));
        $no_of_term = addslashes(strip_tags(trim($body['no_of_term'])));
        
        if (sizeof($this->checkCourse($name)) == 0) {
            $course = new Course();
            $course->setName($name);
            $course->setLabel($label);
            $course->setTenure($tenure);
            $course->setNoOfTerm($no_of_term);
            
            $entityManager->persist($course);
            $entityManager->flush();
            return "Course Registered Successfully.";
        } else {
            return "Course already registered.";
        }

    }

    public function getCourse()
    {
        $dql = "SELECT r.id,r.name,r.label,r.tenure,r.no_of_term FROM Course r";
        $query = $this->getEntityManager()->createQuery($dql);
        return $query->getResult();
    }

    public function getCourseCount()
    {
        $dql = "SELECT COUNT(r.id) as c from Course r";
        $query = $this->getEntityManager()->createQuery($dql);
        $result = $query->getResult();
        return $result[0]['c'];
    }
    private function getCourseForEdit($name)
    {
        $dql = "SELECT r FROM Course r WHERE r.id=:name";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('name', $name);
        return $query->getResult();
    }

    public function getCourseSingle($name)
    {
        $dql = "SELECT r.id,r.name,r.label,r.tenure,r.no_of_term FROM Course r WHERE r.name=:name";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('name', $name);
        return $query->getResult();
    }

    public function updateCourse($name, $body)
    {
        $entityManager = $this->getEntityManager();

        $label = addslashes(strip_tags(trim($body['label'])));
        $tenure = addslashes(strip_tags(trim($body['tenure'])));
        $no_of_term = addslashes(strip_tags(trim($body['no_of_term'])));
        
        $result = $this->getCourseForEdit($name);

        if (sizeof($result) == 1) {
            $result[0]->setTenure($tenure);
            $result[0]->setLabel($label);
            
            $result[0]->setNoOfTerm($no_of_term);
            $entityManager->persist($result[0]);
            $entityManager->flush();
            return "Course Updated Successfully.";
        } else {
            return "Not Found.";
        }

    }

    public function checkCourse($name)
    {
        $dql = 'SELECT r FROM Course r WHERE r.name=:name';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('name', $name);
        return $query->getResult();
    }

    public function deleteCourse($name)
    {
        $dql = 'DELETE FROM Course r WHERE r.id=:name';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('name', $name);
        $query->getResult();
        return 'Successfully deleted.';
    }
}
