<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="DepartmentRepository") @Table(name="department")
 */

class Department
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;


    /**
     * @Column(type="string",length=30)
     */
    protected $dept_code;

     
     /**
     * @Column(type="string",length=100)
     */
    protected $dept_name;


     /**
     * @Column(type="integer")
     */
    protected $is_teaching;

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set deptCode.
     *
     * @param string $deptCode
     *
     * @return Department
     */
    public function setDeptCode($deptCode)
    {
        $this->dept_code = $deptCode;

        return $this;
    }

    /**
     * Get deptCode.
     *
     * @return string
     */
    public function getDeptCode()
    {
        return $this->dept_code;
    }

    /**
     * Set deptName.
     *
     * @param string $deptName
     *
     * @return Department
     */
    public function setDeptName($deptName)
    {
        $this->dept_name = $deptName;

        return $this;
    }

    /**
     * Get deptName.
     *
     * @return string
     */
    public function getDeptName()
    {
        return $this->dept_name;
    }

    /**
     * Set isTeaching.
     *
     * @param int $isTeaching
     *
     * @return Department
     */
    public function setIsTeaching($isTeaching)
    {
        $this->is_teaching = $isTeaching;

        return $this;
    }

    /**
     * Get isTeaching.
     *
     * @return int
     */
    public function getIsTeaching()
    {
        return $this->is_teaching;
    }
}
