<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="EmployeeRepository") @Table(name="employee")
 */

class Employee
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=10)
     */
    protected $empid;


    /**
     * @Column(type="string",length=100)
     */
    protected $type;
    
    /**
     * @Column(type="string",length=20)
     */
    protected $dept_code;
    
    
    /**
     * @Column(type="string",length=100)
     */
    protected $name;

    /**
     * @Column(type="string",length=15, nullable=true)
     */
    protected $date_of_birth;
    
    /**
     * @Column(type="string",length=20)
     */
    protected $gender;

    /**
     * @Column(type="string",length=50)
     */
    protected $caste;

    /**
     * @Column(type="string",length=50)
     */
    protected $phone;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $email;

    /**
     * @Column(type="json_array")
     */
    protected $present_address;

    /**
     * @Column(type="json_array")
     */
    protected $permanent_address;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $qualification;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $designation;

    /**
     * @Column(type="string",length=200,nullable=true)
     */
    protected $specialisation;


    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $teaching_mode;

    /**
     * @Column(type="json_array", nullable=true)
     */
    protected $details;

     /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $date_of_appointment;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $dp;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $cv;

    /**
     * @Column(type="integer")
     */
    protected $is_HOD;

    
    /**
     * @Column(type="integer")
     */
    protected $el_leave;

    
    /**
     * @Column(type="integer")
     */
    protected $ccl;


    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $subjects;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $students;

    


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set empid.
     *
     * @param string $empid
     *
     * @return Employee
     */
    public function setEmpid($empid)
    {
        $this->empid = $empid;

        return $this;
    }

    /**
     * Get empid.
     *
     * @return string
     */
    public function getEmpid()
    {
        return $this->empid;
    }

    /**
     * Set type.
     *
     * @param string $type
     *
     * @return Employee
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type.
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set deptCode.
     *
     * @param string $deptCode
     *
     * @return Employee
     */
    public function setDeptCode($deptCode)
    {
        $this->dept_code = $deptCode;

        return $this;
    }

    /**
     * Get deptCode.
     *
     * @return string
     */
    public function getDeptCode()
    {
        return $this->dept_code;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return Employee
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set dateOfBirth.
     *
     * @param string $dateOfBirth
     *
     * @return Employee
     */
    public function setDateOfBirth($dateOfBirth)
    {
        $this->date_of_birth = $dateOfBirth;

        return $this;
    }

    /**
     * Get dateOfBirth.
     *
     * @return string
     */
    public function getDateOfBirth()
    {
        return $this->date_of_birth;
    }

    /**
     * Set gender.
     *
     * @param string $gender
     *
     * @return Employee
     */
    public function setGender($gender)
    {
        $this->gender = $gender;

        return $this;
    }

    /**
     * Get gender.
     *
     * @return string
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Set caste.
     *
     * @param string $caste
     *
     * @return Employee
     */
    public function setCaste($caste)
    {
        $this->caste = $caste;

        return $this;
    }

    /**
     * Get caste.
     *
     * @return string
     */
    public function getCaste()
    {
        return $this->caste;
    }

    /**
     * Set phone.
     *
     * @param string $phone
     *
     * @return Employee
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * Get phone.
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Set email.
     *
     * @param string|null $email
     *
     * @return Employee
     */
    public function setEmail($email = null)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email.
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set presentAddress.
     *
     * @param array $presentAddress
     *
     * @return Employee
     */
    public function setPresentAddress($presentAddress)
    {
        $this->present_address = $presentAddress;

        return $this;
    }

    /**
     * Get presentAddress.
     *
     * @return array
     */
    public function getPresentAddress()
    {
        return $this->present_address;
    }

    /**
     * Set permanentAddress.
     *
     * @param array $permanentAddress
     *
     * @return Employee
     */
    public function setPermanentAddress($permanentAddress)
    {
        $this->permanent_address = $permanentAddress;

        return $this;
    }

    /**
     * Get permanentAddress.
     *
     * @return array
     */
    public function getPermanentAddress()
    {
        return $this->permanent_address;
    }

    /**
     * Set qualification.
     *
     * @param array|null $qualification
     *
     * @return Employee
     */
    public function setQualification($qualification = null)
    {
        $this->qualification = $qualification;

        return $this;
    }

    /**
     * Get qualification.
     *
     * @return array|null
     */
    public function getQualification()
    {
        return $this->qualification;
    }

    /**
     * Set designation.
     *
     * @param string|null $designation
     *
     * @return Employee
     */
    public function setDesignation($designation = null)
    {
        $this->designation = $designation;

        return $this;
    }

    /**
     * Get designation.
     *
     * @return string|null
     */
    public function getDesignation()
    {
        return $this->designation;
    }

    /**
     * Set specialisation.
     *
     * @param string|null $specialisation
     *
     * @return Employee
     */
    public function setSpecialisation($specialisation = null)
    {
        $this->specialisation = $specialisation;

        return $this;
    }

    /**
     * Get specialisation.
     *
     * @return string|null
     */
    public function getSpecialisation()
    {
        return $this->specialisation;
    }

    /**
     * Set teachingMode.
     *
     * @param string|null $teachingMode
     *
     * @return Employee
     */
    public function setTeachingMode($teachingMode = null)
    {
        $this->teaching_mode = $teachingMode;

        return $this;
    }

    /**
     * Get teachingMode.
     *
     * @return string|null
     */
    public function getTeachingMode()
    {
        return $this->teaching_mode;
    }

    /**
     * Set details.
     *
     * @param array|null $details
     *
     * @return Employee
     */
    public function setDetails($details = null)
    {
        $this->details = $details;

        return $this;
    }

    /**
     * Get details.
     *
     * @return array|null
     */
    public function getDetails()
    {
        return $this->details;
    }

    /**
     * Set dateOfAppointment.
     *
     * @param string|null $dateOfAppointment
     *
     * @return Employee
     */
    public function setDateOfAppointment($dateOfAppointment = null)
    {
        $this->date_of_appointment = $dateOfAppointment;

        return $this;
    }

    /**
     * Get dateOfAppointment.
     *
     * @return string|null
     */
    public function getDateOfAppointment()
    {
        return $this->date_of_appointment;
    }

    /**
     * Set dp.
     *
     * @param array|null $dp
     *
     * @return Employee
     */
    public function setDp($dp = null)
    {
        $this->dp = $dp;

        return $this;
    }

    /**
     * Get dp.
     *
     * @return array|null
     */
    public function getDp()
    {
        return $this->dp;
    }

    /**
     * Set cv.
     *
     * @param array|null $cv
     *
     * @return Employee
     */
    public function setCv($cv = null)
    {
        $this->cv = $cv;

        return $this;
    }

    /**
     * Get cv.
     *
     * @return array|null
     */
    public function getCv()
    {
        return $this->cv;
    }

    /**
     * Set isHOD.
     *
     * @param int $isHOD
     *
     * @return Employee
     */
    public function setIsHOD($isHOD)
    {
        $this->is_HOD = $isHOD;

        return $this;
    }

    /**
     * Get isHOD.
     *
     * @return int
     */
    public function getIsHOD()
    {
        return $this->is_HOD;
    }

    /**
     * Set elLeave.
     *
     * @param int $elLeave
     *
     * @return Employee
     */
    public function setElLeave($elLeave)
    {
        $this->el_leave = $elLeave;

        return $this;
    }

    /**
     * Get elLeave.
     *
     * @return int
     */
    public function getElLeave()
    {
        return $this->el_leave;
    }

    /**
     * Set ccl.
     *
     * @param int $ccl
     *
     * @return Employee
     */
    public function setCcl($ccl)
    {
        $this->ccl = $ccl;

        return $this;
    }

    /**
     * Get ccl.
     *
     * @return int
     */
    public function getCcl()
    {
        return $this->ccl;
    }

    /**
     * Set subjects.
     *
     * @param array|null $subjects
     *
     * @return Employee
     */
    public function setSubjects($subjects = null)
    {
        $this->subjects = $subjects;

        return $this;
    }

    /**
     * Get subjects.
     *
     * @return array|null
     */
    public function getSubjects()
    {
        return $this->subjects;
    }

    /**
     * Set students.
     *
     * @param array|null $students
     *
     * @return Employee
     */
    public function setStudents($students = null)
    {
        $this->students = $students;

        return $this;
    }

    /**
     * Get students.
     *
     * @return array|null
     */
    public function getStudents()
    {
        return $this->students;
    }
}
