<?php

use Doctrine\ORM\EntityRepository;

class EmployeeRepository extends EntityRepository
{

   

   


    public function getEmployeeDetailsById($id)
    {
        $dql = "SELECT r.id,r.empid,r.type,r.dept_code,r.name,r.date_of_birth,r.phone,r.email,r.present_address,r.permanent_address,r.qualification,r.designation,r.specialisation,r.gender,r.caste,r.teaching_mode,r.details,r.date_of_appointment,r.is_HOD,r.el_leave,r.ccl From Employee r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('id', $id);
        $result = $query->getResult();
        if (sizeof($result) > 0) {
            return $result[0];
        } else {
            return false;
        }
        
    }

   

    public function getLibraryEmployee()
    {
        $dql = "SELECT r.id,r.name from Employee r where r.dept_code='LIBRARY'";
        $query = $this->getEntityManager()->createQuery($dql);
        return $query->getResult();
    }

   



   

    public function checkAttendance($email, $b, $current_session)
    {
        $entityManager = $this->getEntityManager();
        $data = $this->getEntityManager()->getRepository('Attendance')->checkAttendance($email, $b, $current_session);
        if (sizeof($data) == 0) {
            return false;
        } else {
            return true;
        }
    }

    public function countClasses($email, $b, $current_session)
    {
        $entityManager = $this->getEntityManager();
        $data = $this->getEntityManager()->getRepository('Attendance')->checkAttendanceAll($email, $b, $current_session);
        return sizeof($data);
    }

    private function array_2d_to_1d($input_array)
    {

        $output_array = [];
        foreach ($input_array as $b1) {

            $el = $b1;

            $el1 = str_replace('"', '', $el);
            $el1 = str_replace('[', '', $el1);
            $el1 = str_replace(']', '', $el1);

            $el1 = explode(',', $el1);

            foreach ($el1 as $b) {

                if (!array_search(trim($b), $output_array)) {
                    array_push($output_array, trim($b));
                }
            }
        }

        return $output_array;
    }

    public function getTeacherByEmail($email)
    {
        $dql = "SELECT r.name,r.dept_code,r.id,r.email,r.dp,s.dept_name FROM Employee r, Department s WHERE r.email=:email AND r.dept_code=s.dept_code";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('email', $email);
        $result = $query->getResult();
        if (sizeof($result) > 0) {
            $d = $result[0];
            // require_once __DIR__ . '/../utility.php';
            // $file = new FileUpload();
            // $d['dp'] = $file->getFile($d['dp'], []);

            return $d;

        } else {
            return false;
        }

    }

}
