<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="FeedbackCategoryRepository") @Table(name="feedback_category")
 */

class FeedbackCategory
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;


    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $by_whom;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $on_whom;

    /**
     * @Column(type="integer", nullable=true, length=10)
     */
    protected $on_teacher;
    
    /**
     * @Column(type="text", nullable=true)
     */
    protected $name_en;
    
    
    /**
     * @Column(type="text", nullable=true)
     */
    protected $name_as;

    /**
     * @Column(type="text", nullable=true)
     */
    protected $description;

    /**
     * @Column(type="integer", nullable=true, length=10)
     */
    protected $is_shown;
    
    

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set byWhom.
     *
     * @param string $byWhom
     *
     * @return FeedbackCategory
     */
    public function setByWhom($byWhom)
    {
        $this->by_whom = $byWhom;

        return $this;
    }

    /**
     * Get byWhom.
     *
     * @return string
     */
    public function getByWhom()
    {
        return $this->by_whom;
    }

    /**
     * Set onWhom.
     *
     * @param string $onWhom
     *
     * @return FeedbackCategory
     */
    public function setOnWhom($onWhom)
    {
        $this->on_whom = $onWhom;

        return $this;
    }

    /**
     * Get onWhom.
     *
     * @return string
     */
    public function getOnWhom()
    {
        return $this->on_whom;
    }

    /**
     * Set onTeacher.
     *
     * @param int $onTeacher
     *
     * @return FeedbackCategory
     */
    public function setOnTeacher($onTeacher)
    {
        $this->on_teacher = $onTeacher;

        return $this;
    }

    /**
     * Get onTeacher.
     *
     * @return int
     */
    public function getOnTeacher()
    {
        return $this->on_teacher;
    }

    /**
     * Set nameEn.
     *
     * @param string $nameEn
     *
     * @return FeedbackCategory
     */
    public function setNameEn($nameEn)
    {
        $this->name_en = $nameEn;

        return $this;
    }

    /**
     * Get nameEn.
     *
     * @return string
     */
    public function getNameEn()
    {
        return $this->name_en;
    }

    /**
     * Set nameAs.
     *
     * @param string $nameAs
     *
     * @return FeedbackCategory
     */
    public function setNameAs($nameAs)
    {
        $this->name_as = $nameAs;

        return $this;
    }

    /**
     * Get nameAs.
     *
     * @return string
     */
    public function getNameAs()
    {
        return $this->name_as;
    }

    /**
     * Set description.
     *
     * @param string $description
     *
     * @return FeedbackCategory
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set isShown.
     *
     * @param int|null $isShown
     *
     * @return FeedbackCategory
     */
    public function setIsShown($isShown = null)
    {
        $this->is_shown = $isShown;

        return $this;
    }

    /**
     * Get isShown.
     *
     * @return int|null
     */
    public function getIsShown()
    {
        return $this->is_shown;
    }
}
