<?php

use Doctrine\ORM\EntityRepository;

class FeedbackCategoryRepository extends EntityRepository
{

   

    public function getFeedbackCategory()
    {
        $dql = "SELECT r.id,r.by_whom,r.on_whom,r.on_teacher,r.name_as,r.name_en,r.description, r.is_shown FROM FeedbackCategory r";
        $query = $this->getEntityManager()->createQuery($dql);
        return $result = $query->getResult();

    }

    public function getFeedbackCategoryForEdit($id)
    {
        $dql = "SELECT r FROM FeedbackCategory r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function getFeedbackCategoryForStudent($email)
    {
        $entityManager = $this->getEntityManager();
        $session_id = $entityManager->getRepository('FeedbackSession')->getActiveFeedbackSession();
        if ($session_id !== false) {
            $dql = "SELECT r.id,r.by_whom,r.on_whom,r.on_teacher,r.name_en,r.name_as,r.description, r.is_shown FROM FeedbackCategory r WHERE r.by_whom='STUDENT' AND r.is_shown='1'";
            $query = $this->getEntityManager()->createQuery($dql);
            $result = $query->getResult();
            $a = array();

            foreach ($result as $r) {
                if (!$this->getFeedbackCategoryForStudentFilled($email, $r['id'], $session_id)) {
                    array_push($a,$r);
                }
            }

            if(!empty($a)){
                return $a;
            }else{
                return '102';
            }
            

        } else {
            return false;
        }

    }


    public function getFeedbackCategoryForTeacher($email)
    {
        $entityManager = $this->getEntityManager();
        $session_id = $entityManager->getRepository('FeedbackSession')->getActiveFeedbackSession();
        if ($session_id !== false) {
            $dql = "SELECT r.id,r.by_whom,r.on_whom,r.on_teacher,r.name_en,r.name_as,r.description,r.is_shown FROM FeedbackCategory r WHERE r.by_whom='TEACHER' AND r.is_shown='1'";
            $query = $this->getEntityManager()->createQuery($dql);
            $result = $query->getResult();
            $a = array();

            foreach ($result as $r) {
                if (!$this->getFeedbackCategoryForStudentFilled($email, $r['id'], $session_id)) {
                    array_push($a,$r);
                }
            }

            if(!empty($a)){
                return $a;
            }else{
                return '102';
            }
            

        } else {
            return false;
        }

    }

    private function getFeedbackCategoryForStudentFilled($email, $id,$session_id)
    {

        $dql = "SELECT r.category_id FROM Feedbacks r WHERE r.email=:email AND r.session_id=:session_id AND r.category_id=:id";
        $query = $this->getEntityManager()
            ->createQuery($dql)
            ->setParameter('email', $email)
            ->setParameter('session_id', $session_id)
            ->setParameter('id', $id);
        $result = $query->getResult();
        if (sizeof($result) > 0) {
            return true;
        } else {
            return false;
        }

    }

    public function getFeedbackCategorySingle($id)
    {
        $dql = "SELECT r.id,r.by_whom,r.on_whom,r.on_teacher,r.name_as,r.name_en,r.description,r.is_shown FROM FeedbackCategory r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $result = $query->getResult();
    }


    public function checkFeedbackCategory($by_whom, $on_whom)
    {
        $dql = 'SELECT r FROM FeedbackCategory r WHERE r.by_whom=:by_whom AND r.on_whom=:on_whom';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('by_whom', $by_whom)->setParameter('on_whom', $on_whom);
        return $query->getResult();
    }

    public function isNeededTeacherList($id)
    {
        $dql = 'SELECT r.on_teacher FROM FeedbackCategory r WHERE r.id=:id';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $result = $query->getResult();
        return $result[0]['on_teacher'];
    }

}
