<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="FeedbackQuestionRepository") @Table(name="feedback_question")
 */

class FeedbackQuestion
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="integer")
     */
    protected $category_id;

    /**
     * @Column(type="text")
     */
    protected $title_en;

    /**
     * @Column(type="text")
     */
    protected $title_as;

    /**
     * @Column(type="json_array")
     */
    protected $question_options;
    

    

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set categoryId.
     *
     * @param int $categoryId
     *
     * @return FeedbackQuestion
     */
    public function setCategoryId($categoryId)
    {
        $this->category_id = $categoryId;

        return $this;
    }

    /**
     * Get categoryId.
     *
     * @return int
     */
    public function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * Set titleEn.
     *
     * @param string $titleEn
     *
     * @return FeedbackQuestion
     */
    public function setTitleEn($titleEn)
    {
        $this->title_en = $titleEn;

        return $this;
    }

    /**
     * Get titleEn.
     *
     * @return string
     */
    public function getTitleEn()
    {
        return $this->title_en;
    }

    /**
     * Set titleAs.
     *
     * @param string $titleAs
     *
     * @return FeedbackQuestion
     */
    public function setTitleAs($titleAs)
    {
        $this->title_as = $titleAs;

        return $this;
    }

    /**
     * Get titleAs.
     *
     * @return string
     */
    public function getTitleAs()
    {
        return $this->title_as;
    }

    /**
     * Set questionOptions.
     *
     * @param array $questionOptions
     *
     * @return FeedbackQuestion
     */
    public function setQuestionOptions($questionOptions)
    {
        $this->question_options = $questionOptions;

        return $this;
    }

    /**
     * Get questionOptions.
     *
     * @return array
     */
    public function getQuestionOptions()
    {
        return $this->question_options;
    }
}
