<?php

use Doctrine\ORM\EntityRepository;

class FeedbackQuestionRepository extends EntityRepository
{
    
    public function addFeedbackQuestion($body)
    {
        $entityManager = $this->getEntityManager();
        
        $category_id = addslashes(strip_tags(trim($body['category_id'])));
        $title_as = addslashes(strip_tags(trim($body['title_as'])));
        $title_en = addslashes(strip_tags(trim($body['title_en'])));
        $question_options = $body['question_options'];

        //if (sizeof($this->checkFeedbackQuestion($title_as,$title_en)) == 0) {
            $emp = new FeedbackQuestion();
            
            $emp->setCategoryId($category_id);
            $emp->setTitleAs($title_as);
            $emp->setTitleEn($title_en);
            $emp->setQuestionOptions($question_options);
            $entityManager->persist($emp);
            $entityManager->flush();
            if(null !=$emp->getId()){ 
            return "Registered Successfully.";
            }
        //} else {
            return "Feedback title already exist.";
        //}

    }

    public function getFeedbackQuestion()
    {
        $dql = "SELECT r.id,r.category_id,r.title_as,r.title_en,r.question_options,s.name_en,s.name_as,s.by_whom,s.on_whom,s.on_teacher,s.description From FeedbackQuestion r,FeedbackCategory s where r.category_id=s.id";
        $query = $this->getEntityManager()->createQuery($dql);
        return $result = $query->getResult();
        
    }


    public function getFeedbackQuestionByCategory($id)
    {   
        
        $dql = "SELECT r.id,r.category_id,r.title_as,r.title_en,r.question_options,s.name_en,s.name_as,s.by_whom,s.on_whom,s.on_teacher,s.description From FeedbackQuestion r,FeedbackCategory s where r.category_id=s.id AND r.category_id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $result = $query->getResult();
        
    }


    Public function getFeedbackQuestionForEdit($id)
    {
        $dql = "SELECT r from FeedbackQuestion r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function getFeedbackQuestionSingle($id)
    {
        $dql = "SELECT r.id,r.category_id,r.title_as,r.title_en,r.question_options,s.name_en,s.name_as,s.by_whom,s.on_whom,s.on_teacher,s.description From FeedbackQuestion r,FeedbackCategory s where r.category_id=s.id AND r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $result = $query->getResult();
    }
   
    
    public function updateFeedbackQuestion($id, $body)
    {
        $entityManager = $this->getEntityManager();
        $category_id = addslashes(strip_tags(trim($body['category_id'])));
        $title_as = addslashes(strip_tags(trim($body['title_as'])));
        $title_en = addslashes(strip_tags(trim($body['title_en'])));
        $question_options = $body['question_options'];
        
        $result = $this->getFeedbackQuestionForEdit($id);
        if (sizeof($result) == 1) {

            
            $result[0]->setCategoryId($category_id);
            $result[0]->setTitleAs($title_as);
            $result[0]->setTitleEn($title_en);
            $result[0]->setQuestionOptions($question_options);
            $entityManager->persist($result[0]);
            $entityManager->flush();
            return "Updated Successfully.";
        } else {
            return "Invalid Type.";
        }

    }

    public function deleteFeedbackQuestion($id)
    {   
        $dql = "DELETE FROM FeedbackQuestion r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $query->getResult();
        return "Succesfully deleted";
    }

    public function checkFeedbackQuestion($title_as,$title_en)
    {
        $dql = 'SELECT r FROM FeedbackQuestion r WHERE r.title_as=:title_as OR r.title_en=:title_en';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('title_en', $title_en)->setParameter('title_as', $title_as);
        return $query->getResult();
    }

    

}
