<?php

use Doctrine\ORM\EntityRepository;

class FeedbackSessionRepository extends EntityRepository
{

    public function addFeedbackSession($body)
    {
        $entityManager = $this->getEntityManager();

        $session_name = addslashes(strip_tags(trim($body['session_name'])));
        $is_active = addslashes(strip_tags(trim($body['is_active'])));

        if (sizeof($this->checkFeedbackSession($session_name)) == 0) {
            $sm = new FeedbackSession();

            $sm->setSessionName($session_name);
            $sm->setIsActive($is_active);
            $entityManager->persist($sm);
            $entityManager->flush();
            if($is_active == 1)
            {
            $dql2 = "UPDATE FeedbackSession r set r.is_active=0";
            $query = $this->getEntityManager()->createQuery($dql2);
            $query->getResult();
            }
            return "Session Registered Successfully.";
        } else {
            return "Session already registered.";
        }

        
        
    }

    public function getActiveFeedbackSession()
    {
        $dql = "SELECT r From FeedbackSession r where r.is_active=1";
        $query = $this->getEntityManager()->createQuery($dql)->setMaxResults(1);
        $result = $query->getResult();
        if(sizeof($result) > 0){
            return $result[0]->getId();
        }else{
            return false;
        }
    }

    public function getFeedbackSession()
    {
        $dql = "SELECT r.id,r.session_name,r.is_active From FeedbackSession r";
        $query = $this->getEntityManager()->createQuery($dql);
        return $query->getResult();
    }

    public function getFeedbackSessionSingle($id)
    {
        $dql = "SELECT r.id,r.session_name,r.is_active From FeedbackSession r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    private function getFeedbackSessionForEdit($id)
    {
        $dql = "SELECT r from FeedbackSession r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function updateFeedbackSession($id, $body)
    {
        $entityManager = $this->getEntityManager();

        $session_name = addslashes(strip_tags(trim($body['session_name'])));
        $is_active = addslashes(strip_tags(trim($body['is_active'])));

        $result = $this->getFeedbackSessionForEdit($id);
        if (sizeof($result) == 1 && sizeof($this->checkFeedbackSession($session_name)) == 1) {

            $result[0]->setSessionName($session_name);
            $result[0]->setIsActive($is_active);
            
            $entityManager->persist($result[0]);
            $entityManager->flush();
            return "Session Updated Successfully.";
        } else {
            return "Not Found.";
        }

    }

    public function checkFeedbackSession($session_name)
    {
        $dql = 'SELECT r FROM FeedbackSession r WHERE r.session_name=:session_name';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('session_name', $session_name);
        return $query->getResult();
    }

    public function deleteFeedbackSession($id)
    {
        $dql = 'DELETE  FROM FeedbackSession r WHERE r.id=:id';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $query->getResult();
        return true;
    }
}
