<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="FeedbacksRepository") @Table(name="feedbacks")
 */

class Feedbacks
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="integer")
     */
    protected $type;


    /**
     * @Column(type="integer")
     */
    protected $category_id;

    /**
     * @Column(type="string",length=100)
     */
    protected $email;

    /**
     * @Column(type="integer")
     */
    protected $session_id;
    
    /**
     * @Column(type="json_array")
     */
    protected $responses;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $comment;
    
    
    /**
     * @Column(type="string",length=50)
     */
    protected $time_stamp;

    

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set type.
     *
     * @param int $type
     *
     * @return Feedbacks
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type.
     *
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set categoryId.
     *
     * @param int $categoryId
     *
     * @return Feedbacks
     */
    public function setCategoryId($categoryId)
    {
        $this->category_id = $categoryId;

        return $this;
    }

    /**
     * Get categoryId.
     *
     * @return int
     */
    public function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * Set email.
     *
     * @param string $email
     *
     * @return Feedbacks
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email.
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set sessionId.
     *
     * @param int $sessionId
     *
     * @return Feedbacks
     */
    public function setSessionId($sessionId)
    {
        $this->session_id = $sessionId;

        return $this;
    }

    /**
     * Get sessionId.
     *
     * @return int
     */
    public function getSessionId()
    {
        return $this->session_id;
    }

    /**
     * Set responses.
     *
     * @param array $responses
     *
     * @return Feedbacks
     */
    public function setResponses($responses)
    {
        $this->responses = $responses;

        return $this;
    }

    /**
     * Get responses.
     *
     * @return array
     */
    public function getResponses()
    {
        return $this->responses;
    }

    /**
     * Set comment.
     *
     * @param string|null $comment
     *
     * @return Feedbacks
     */
    public function setComment($comment = null)
    {
        $this->comment = $comment;

        return $this;
    }

    /**
     * Get comment.
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }

    

    /**
     * Set timeStamp.
     *
     * @param string $timeStamp
     *
     * @return Feedbacks
     */
    public function setTimeStamp($timeStamp)
    {
        $this->time_stamp = $timeStamp;

        return $this;
    }

    /**
     * Get timeStamp.
     *
     * @return string
     */
    public function getTimeStamp()
    {
        return $this->time_stamp;
    }
}
