<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="GeneralUserRepository") @Table(name="general_user")
 */
class GeneralUser
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    
    /**
     * @Column(type="string", length=100, options={"default": 0})
     */
    protected $email;

    /**
     * @Column(type="string", length=200, options={"default": 0})
     */
    protected $password;

    /**
     * @Column(type="string", length=300, nullable=true, options={"default": 0})
     */
    protected $token;

   

    /**
     * @Column(type="integer", length=1, options={"default": 1})
     */
    protected $active;

    /**
     * @Column(type="string", length=50, options={"default": 0})
     */
    protected $role;


    

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set password.
     *
     * @param string $password
     *
     * @return GeneralUser
     */
    public function setPassword($password)
    {
        $this->password = $password;

        return $this;
    }

    /**
     * Get password.
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Set token.
     *
     * @param string $token
     *
     * @return GeneralUser
     */
    public function setToken($token)
    {
        $this->token = $token;

        return $this;
    }

    /**
     * Get token.
     *
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * Set active.
     *
     * @param int $active
     *
     * @return GeneralUser
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * Get active.
     *
     * @return int
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set role.
     *
     * @param string $role
     *
     * @return GeneralUser
     */
    public function setRole($role)
    {
        $this->role = $role;

        return $this;
    }

    /**
     * Get role.
     *
     * @return string
     */
    public function getRole()
    {
        return $this->role;
    }

    /**
     * Set email.
     *
     * @param string $email
     *
     * @return GeneralUser
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email.
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
}
