<?php

/**
 * @Entity(repositoryClass="HolidayRepository") @Table(name="holiday")
 */

class Holiday
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $date;

    /**
     * @Column(type="string",length=300, nullable=true)
     */
    protected $holiday;


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set date.
     *
     * @param string|null $date
     *
     * @return Holiday
     */
    public function setDate($date = null)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * Get date.
     *
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Set holiday.
     *
     * @param string|null $holiday
     *
     * @return Holiday
     */
    public function setHoliday($holiday = null)
    {
        $this->holiday = $holiday;

        return $this;
    }

    /**
     * Get holiday.
     *
     * @return string|null
     */
    public function getHoliday()
    {
        return $this->holiday;
    }
}
