<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="MarksEntryRepository") @Table(name="marks_entry")
 */

class MarksEntry
{

    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=500,nullable=true)
     */
    protected $marksheet_title;

     /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $type;

     /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $marksheet_no;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $entry_date;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $student_id;

     
    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $semester;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $marks_details;

    /**
     * @Column(type="string",length=10,nullable=true)
     */
    protected $grand_marks;


    /**
     * @Column(type="string",length=10,nullable=true)
     */
    protected $grand_pass;


    /**
     * @Column(type="string",length=10,nullable=true)
     */
    protected $grand_obtained;


    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $result;

    /**
     * @Column(type="integer",length=11,nullable=true,options={"default":0})
     */
    protected $is_cbcs=0;
    

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set marksheetTitle.
     *
     * @param string|null $marksheetTitle
     *
     * @return MarksEntry
     */
    public function setMarksheetTitle($marksheetTitle = null)
    {
        $this->marksheet_title = $marksheetTitle;

        return $this;
    }

    /**
     * Get marksheetTitle.
     *
     * @return string|null
     */
    public function getMarksheetTitle()
    {
        return $this->marksheet_title;
    }

    /**
     * Set type.
     *
     * @param string|null $type
     *
     * @return MarksEntry
     */
    public function setType($type = null)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type.
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set marksheetNo.
     *
     * @param string|null $marksheetNo
     *
     * @return MarksEntry
     */
    public function setMarksheetNo($marksheetNo = null)
    {
        $this->marksheet_no = $marksheetNo;

        return $this;
    }

    /**
     * Get marksheetNo.
     *
     * @return string|null
     */
    public function getMarksheetNo()
    {
        return $this->marksheet_no;
    }

    /**
     * Set entryDate.
     *
     * @param string|null $entryDate
     *
     * @return MarksEntry
     */
    public function setEntryDate($entryDate = null)
    {
        $this->entry_date = $entryDate;

        return $this;
    }

    /**
     * Get entryDate.
     *
     * @return string|null
     */
    public function getEntryDate()
    {
        return $this->entry_date;
    }


    /**
     * Set studentId.
     *
     * @param string|null $studentId
     *
     * @return MarksEntry
     */
    public function setStudentId($studentId = null)
    {
        $this->student_id = $studentId;

        return $this;
    }

    /**
     * Get studentId.
     *
     * @return string|null
     */
    public function getStudentId()
    {
        return $this->student_id;
    }

    /**
     * Set semester.
     *
     * @param string|null $semester
     *
     * @return MarksEntry
     */
    public function setSemester($semester = null)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return string|null
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set marksDetails.
     *
     * @param array|null $marksDetails
     *
     * @return MarksEntry
     */
    public function setMarksDetails($marksDetails = null)
    {
        $this->marks_details = $marksDetails;

        return $this;
    }

    /**
     * Get marksDetails.
     *
     * @return array|null
     */
    public function getMarksDetails()
    {
        return $this->marks_details;
    }

    /**
     * Set grandMarks.
     *
     * @param string|null $grandMarks
     *
     * @return MarksEntry
     */
    public function setGrandMarks($grandMarks = null)
    {
        $this->grand_marks = $grandMarks;

        return $this;
    }

    /**
     * Get grandMarks.
     *
     * @return string|null
     */
    public function getGrandMarks()
    {
        return $this->grand_marks;
    }

    /**
     * Set grandPass.
     *
     * @param string|null $grandPass
     *
     * @return MarksEntry
     */
    public function setGrandPass($grandPass = null)
    {
        $this->grand_pass = $grandPass;

        return $this;
    }

    /**
     * Get grandPass.
     *
     * @return string|null
     */
    public function getGrandPass()
    {
        return $this->grand_pass;
    }

    /**
     * Set grandObtained.
     *
     * @param string|null $grandObtained
     *
     * @return MarksEntry
     */
    public function setGrandObtained($grandObtained = null)
    {
        $this->grand_obtained = $grandObtained;

        return $this;
    }

    /**
     * Get grandObtained.
     *
     * @return string|null
     */
    public function getGrandObtained()
    {
        return $this->grand_obtained;
    }

    /**
     * Set result.
     *
     * @param string|null $result
     *
     * @return MarksEntry
     */
    public function setResult($result = null)
    {
        $this->result = $result;

        return $this;
    }

    /**
     * Get result.
     *
     * @return string|null
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * Set isCbcs.
     *
     * @param int|null $isCbcs
     *
     * @return MarksEntry
     */
    public function setIsCbcs($isCbcs = null)
    {
        $this->is_cbcs = $isCbcs;

        return $this;
    }

    /**
     * Get isCbcs.
     *
     * @return int|null
     */
    public function getIsCbcs()
    {
        return $this->is_cbcs;
    }
}
