<?php

use Doctrine\ORM\EntityRepository;

class MarksEntryRepository extends EntityRepository
{

    public function addMarksNonCbcs($body)
    {
        $em = $this->getEntityManager();

        $a = array();
        $marksheet_title = addslashes(strip_tags(trim($body['marks_title'])));
        $type = addslashes(strip_tags(trim($body['type'])));
        $entry_date = addslashes(strip_tags(trim($body['date'])));
        $marksheet_no = $this->getLastId();
        $email = addslashes(strip_tags(trim($body['email'])));

        $semester = addslashes(strip_tags(trim($body['semester'])));
        $marks = $body['table_data'];
        $grand_marks = addslashes(strip_tags(trim($body['grand_marks'])));
       
        $grand_obtained = addslashes(strip_tags(trim($body['grand_obtained'])));
        $result = addslashes(strip_tags(trim($body['overall_status'])));

        if (sizeof($em->getRepository('Student')->getStudentForMark($email)) > 0) {
            $obj = new MarksEntry();
            $obj->setMarksheetTitle($marksheet_title);
            $obj->setType($type);
            $obj->setMarksheetNo($marksheet_no);
            $obj->setEntryDate($entry_date);
            $obj->setStudentId($email);
            $obj->setSemester($semester);
            $obj->setMarksDetails($marks);
            $obj->setGrandMarks($grand_marks);
            
            $obj->setGrandObtained($grand_obtained);
            $obj->setResult($result);
            $obj->setIsCbcs(1);
            $em->persist($obj);
            $em->flush();
            if (null != $obj->getId()) {
                if (is_array($marks) && sizeof($marks) > 0) {
                    foreach ($marks as $m) {
                        $r = $em->getRepository('SubjectMaster')->getSubjectForEdit($m['sub_code']);
                        if (sizeof($r) > 0) {
                            $r[0]->setTotalMarks($m['total_marks']);
                           // $r[0]->setPassMarks($m['pass_marks']);
                            $em->persist($r[0]);
                            $em->flush();
                        }
                    }
                }
                $a['message'] = 'Marks added successfully.';
                $a['id'] = $obj->getId();
            } else {
                $a['message'] = 'Failed';
            }

        } else {
            $a['message'] = 'Failed';
        }

        return $a;
    }

    public function addMarks($body)
    {
        $em = $this->getEntityManager();

        $a = array();
        $marksheet_title = addslashes(strip_tags(trim($body['marks_title'])));
        $type = addslashes(strip_tags(trim($body['type'])));
        $entry_date = addslashes(strip_tags(trim($body['date'])));
        $marksheet_no = $this->getLastId();
        $student_id = addslashes(strip_tags(trim($body['student_id'])));

        $semester = addslashes(strip_tags(trim($body['semester'])));
        $marks = $body['table_data'];
        $grand_marks = addslashes(strip_tags(trim($body['grand_marks'])));
        $grand_pass = addslashes(strip_tags(trim($body['grand_pass'])));
        $grand_obtained = addslashes(strip_tags(trim($body['grand_obtained'])));
        $result = addslashes(strip_tags(trim($body['overall_status'])));

        if (sizeof($em->getRepository('Student')->getStudentByRollNo($student_id)) > 0) {
            $obj = new MarksEntry();
            $obj->setMarksheetTitle($marksheet_title);
            $obj->setType($type);
            $obj->setMarksheetNo($marksheet_no);
            $obj->setEntryDate($entry_date);
            $obj->setStudentId($student_id);
            $obj->setSemester($semester);
            $obj->setMarksDetails($marks);
            $obj->setGrandMarks($grand_marks);
            $obj->setGrandPass($grand_pass);
            $obj->setGrandObtained($grand_obtained);
            $obj->setResult($result);
            $em->persist($obj);
            $em->flush();
            if (null != $obj->getId()) {
                if (is_array($marks) && sizeof($marks) > 0) {
                    foreach ($marks as $m) {
                        $r = $em->getRepository('PaperMaster')->getPaperByPaperCode($m['paper_code']);
                        if (sizeof($r) > 0) {
                            $r[0]->setTotalMarks($m['total_marks']);
                            $r[0]->setPassMarks($m['pass_marks']);
                            $em->persist($r[0]);
                            $em->flush();
                        }
                    }
                }
                $a['message'] = 'Marks added successfully.';
                $a['id'] = $obj->getId();
            } else {
                $a['message'] = 'Failed';
            }

        } else {
            $a['message'] = 'Failed';
        }

        return $a;
    }

    private function getLastId()
    {
        $dql = "SELECT MAX(r.id) as id FROM MarksEntry r";
        $query = $this->getEntityManager()->createQuery($dql);
        $r = $query->getResult();
        if(sizeof($r) > 0){
            return $r[0]['id']+1;
        }else{
            return 1;
        }

    }

    public function getMarks()
    {
        $dql = "SELECT r.id,r.marksheet_title,r.type,r.marksheet_no,r.entry_date,r.student_id,r.semester,r.marks_details,r.grand_marks,r.grand_pass,r.grand_obtained,r.result,r.is_cbcs FROM MarksEntry r ";
        $query = $this->getEntityManager()->createQuery($dql);
        return $query->getResult();
    }

    public function getMarksSingle($id)
    {
        $dql = "SELECT r.id,r.marksheet_title,r.type,r.marksheet_no,r.entry_date,r.student_id,r.student_id as email,r.semester,r.marks_details,r.grand_marks,r.grand_pass,r.grand_obtained,r.result,r.is_cbcs,s.name,s.roll_no FROM MarksEntry r,Student s WHERE r.id=:id AND (r.student_id=s.roll_no OR r.student_id=s.email)";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $r = $query->getResult();
        if (sizeof($r) > 0) {
            $r[0]['entry_date'] = date('d-m-Y', strtotime($r[0]['entry_date']));
            return $r;
        } else {
            return [];
        }
    }

    public function deleteMarksheet($id)
    {
        $dql = "DELETE  FROM MarksEntry r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function getMarksheetForEdit($id)
    {
        $dql = "SELECT r  FROM MarksEntry r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function updateMarks($body)
    {
        $em = $this->getEntityManager();
        $a = array();
        $id = addslashes(strip_tags(trim($body['id'])));
        $marksheet_title = addslashes(strip_tags(trim($body['marks_title'])));
        $type = addslashes(strip_tags(trim($body['type'])));
        $entry_date = addslashes(strip_tags(trim($body['date'])));
        $marksheet_no = addslashes(strip_tags(trim($body['sl_no'])));
        $student_id = addslashes(strip_tags(trim($body['student_id'])));

        $semester = addslashes(strip_tags(trim($body['semester'])));
        $marks = $body['table_data'];
        $grand_marks = addslashes(strip_tags(trim($body['grand_marks'])));
        $grand_pass = addslashes(strip_tags(trim($body['grand_pass'])));
        $grand_obtained = addslashes(strip_tags(trim($body['grand_obtained'])));
        $result = addslashes(strip_tags(trim($body['overall_status'])));

        if (sizeof($em->getRepository('Student')->getStudentByRollNo($student_id)) > 0 && sizeof($this->getMarksSingle($id)) > 0) {
            $obj = $this->getMarksheetForEdit($id);
            $obj[0]->setMarksheetTitle($marksheet_title);
            $obj[0]->setType($type);
            $obj[0]->setMarksheetNo($marksheet_no);
            $obj[0]->setEntryDate($entry_date);
            $obj[0]->setStudentId($student_id);
            $obj[0]->setSemester($semester);
            $obj[0]->setMarksDetails($marks);
            $obj[0]->setGrandMarks($grand_marks);
            $obj[0]->setGrandPass($grand_pass);
            $obj[0]->setGrandObtained($grand_obtained);
            $obj[0]->setResult($result);
            $em->persist($obj[0]);
            $em->flush();
            if (null != $obj[0]->getId()) {
                if (is_array($marks) && sizeof($marks) > 0) {
                    foreach ($marks as $m) {
                        $r = $em->getRepository('PaperMaster')->getPaperByPaperCode($m['paper_code']);
                        if (sizeof($r) > 0) {
                            $r[0]->setTotalMarks($m['total_marks']);
                            $r[0]->setPassMarks($m['pass_marks']);
                            $em->persist($r[0]);
                            $em->flush();
                        }
                    }
                    $a['message'] = 'Marks added successfully.';
                    $a['id'] = $id;
                } else {
                    $a['message'] = 'Failed';
                }

            } else {
                $a['message'] = 'Failed';
            }

        }
        return $a;
    }


    public function updateMarksNonCbcs($body)
    {
        $em = $this->getEntityManager();

        $a = array();
        $id = addslashes(strip_tags(trim($body['id'])));
        $marksheet_title = addslashes(strip_tags(trim($body['marks_title'])));
        $type = addslashes(strip_tags(trim($body['type'])));
        $entry_date = addslashes(strip_tags(trim($body['date'])));
        $marksheet_no = $this->getLastId();
        $email = addslashes(strip_tags(trim($body['email'])));

        $semester = addslashes(strip_tags(trim($body['semester'])));
        $marks = $body['table_data'];
        $grand_marks = addslashes(strip_tags(trim($body['grand_marks'])));
       
        $grand_obtained = addslashes(strip_tags(trim($body['grand_obtained'])));
        $result = addslashes(strip_tags(trim($body['overall_status'])));

        if (sizeof($em->getRepository('Student')->getStudentForMark($email)) > 0 && sizeof($this->getMarksSingle($id)) > 0) {
            $obj = $this->getMarksheetForEdit($id);
            $obj[0]->setMarksheetTitle($marksheet_title);
            $obj[0]->setType($type);
            $obj[0]->setMarksheetNo($marksheet_no);
            $obj[0]->setEntryDate($entry_date);
            $obj[0]->setStudentId($email);
            $obj[0]->setSemester($semester);
            $obj[0]->setMarksDetails($marks);
            $obj[0]->setGrandMarks($grand_marks);
            
            $obj[0]->setGrandObtained($grand_obtained);
            $obj[0]->setResult($result);
            $em->persist($obj[0]);
            $em->flush();
            if (null != $obj[0]->getId()) {
                if (is_array($marks) && sizeof($marks) > 0) {
                    foreach ($marks as $m) {
                        $r = $em->getRepository('SubjectMaster')->getSubjectForEdit($m['sub_code']);
                        if (sizeof($r) > 0) {
                            $r[0]->setTotalMarks($m['total_marks']);
                           // $r[0]->setPassMarks($m['pass_marks']);
                            $em->persist($r[0]);
                            $em->flush();
                        }
                    }
                    $a['message'] = 'Marks updated successfully.';
                    $a['id'] = $id;
                } else {
                    $a['message'] = 'Failed';
                }

            } else {
                $a['message'] = 'Failed';
            }

        }
        return $a;
    }
}
