<?php

/**
 * @Entity(repositoryClass="MasterFileRepository") @Table(name="master_file")
 */

class MasterFile
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=300)
     */
    protected $file_id;

    /**
     * @Column(type="string",length=100)
     */
    protected $type;

    /**
     * @Column(type="string",length=200)
     */
    protected $path;

    /**
     * @Column(type="string",length=200)
     */
    protected $mime;

    /**
     * @Column(type="string",length=50)
     */
    protected $extension;

    /**
     * @Column(type="string",length=300)
     */
    protected $timestamp;


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fileId.
     *
     * @param string $fileId
     *
     * @return MasterFile
     */
    public function setFileId($fileId)
    {
        $this->file_id = $fileId;

        return $this;
    }

    /**
     * Get fileId.
     *
     * @return string
     */
    public function getFileId()
    {
        return $this->file_id;
    }

    /**
     * Set type.
     *
     * @param string $type
     *
     * @return MasterFile
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type.
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set path.
     *
     * @param string $path
     *
     * @return MasterFile
     */
    public function setPath($path)
    {
        $this->path = $path;

        return $this;
    }

    /**
     * Get path.
     *
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Set mime.
     *
     * @param string $mime
     *
     * @return MasterFile
     */
    public function setMime($mime)
    {
        $this->mime = $mime;

        return $this;
    }

    /**
     * Get mime.
     *
     * @return string
     */
    public function getMime()
    {
        return $this->mime;
    }

    /**
     * Set timestamp.
     *
     * @param string $timestamp
     *
     * @return MasterFile
     */
    public function setTimestamp($timestamp)
    {
        $this->timestamp = $timestamp;

        return $this;
    }

    /**
     * Get timestamp.
     *
     * @return string
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }

    /**
     * Set extension.
     *
     * @param string $extension
     *
     * @return MasterFile
     */
    public function setExtension($extension)
    {
        $this->extension = $extension;

        return $this;
    }

    /**
     * Get extension.
     *
     * @return string
     */
    public function getExtension()
    {
        return $this->extension;
    }
}
