<?php

use Doctrine\ORM\EntityRepository;

class MasterFileRepository extends EntityRepository
{

    public function addFile($body)
    {
        $i = 0;
        $em = $this->getEntityManager();
        $sp = new FileUpload();
        
        $b = $sp->reArrayFiles($body['file']);
        $type = addslashes(strip_tags(trim($body['type'])));

        $path_array = [];

        if (is_array($b) && sizeof($b) > 0) {
            foreach ($b as $val) {
                //store file in folder

                $a = $sp->addFileMultiple($val, $type);
                $file_id = strtoUpper($body['type'] . '_' . $sp->generateRandomString());
                // store in table
                if (is_array($a) && sizeof($a) > 0) {
                    $file = new MasterFile();
                    $file->setFileId($file_id);
                    $file->setType($a['type']);
                    $file->setPath($a['path']);
                    $file->setMime($a['mime']);
                    $file->setExtension($a['ext']);
                    $file->setTimestamp(date('Y-m-d h:i:a'));
                    $em->persist($file);
                    $em->flush();
                    if (null != $file->getId()) {
                        $path_array[$i]['file_id'] = $file_id;
                        $i++;
                    }
                }
            }
            return $path_array;
        } else {
            return "Failed to store file.";
        }

    }

    public function getFileAll()
    {
        $dql = "SELECT r.id,r.file_id,r.type,r.path,r.mime,r.extension,r.timestamp FROM MasterFile r";
        $query = $this->getEntityManager()->createQuery($dql);
        $a = $query->getResult();
        $r = array();
        $i = 0;
        $sp = new FileUpload();
        foreach ($a as $b) {
            $body['type'] = $b['type'];
            $body['path'] = $b['path'];
            $body['mime'] = $b['mime'];

            $r[$i] = $sp->getFileSingle($body);
        }
        return $r;
    }

    public function getFileId()
    {
        $dql = "SELECT r.file_id FROM MAsterFile r";
        $query = $this->getEntityManager()->createQuery($dql);
        return $a = $query->getResult();
    }

    public function getFileObject($file_id)
    {
        $dql = "SELECT r FROM MasterFile r where r.file_id=:file_id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('file_id', $file_id);
        $a = $query->getResult();
        return $a;
    }

    public function getFileSingle($file_id)
    {
        $dql = "SELECT r.id,r.file_id,r.type,r.path,r.mime,r.extension,r.timestamp FROM MasterFile r where r.file_id=:file_id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('file_id', $file_id);
        $a = $query->getResult();
        $r = array();
        $i = 0;
        $sp = new FileUpload();
        foreach ($a as $b) {
            $body['type'] = $b['type'];
            $body['path'] = $b['path'];
            $body['mime'] = $b['mime'];

            $r = $sp->getFileSingle($body);
        }
        return $r;
    }

    public function getFileSingle1($file_id)
    {
        $dql = "SELECT r.id,r.file_id,r.type,r.path,r.mime,r.extension,r.timestamp FROM MasterFile r where r.file_id=:file_id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('file_id', $file_id);
        $a = $query->getResult();
        $r = array();
        $i = 0;
        $sp = new FileUpload();
        foreach ($a as $b) {
            $body['type'] = $b['type'];
            $body['path'] = $b['path'];
            $body['mime'] = $b['mime'];

            $r = $sp->getFileSingle($body);
        }

        $d = '';
        if($r['data'] != ''){
            $d = 'data:'.$r['mime'].';base64,'.$r['data'];
        }
        return $d;
    }

    public function deleteFile($file_id)
    {
        $dql1 = "SELECT r.type,r.path from MasterFile r where r.file_id=:file_id";
        $query1 = $this->getEntityManager()->createQuery($dql1)->setParameter('file_id', $file_id);
        $a = $query1->getResult();
        if (sizeof($a) > 0) {
            $sp = new FileUpload();
            if ($sp->deleteFile($a[0]['type'], $a[0]['path']) == true) {
                $dql2 = "DELETE  from MasterFile r where r.file_id=:file_id";
                $query2 = $this->getEntityManager()->createQuery($dql2)->setParameter('file_id', $file_id);
                $a = $query2->getResult();
                return "Successfully deleted";
            }
        }
    }
}
