<?php

/**
 * @Entity(repositoryClass="NotificationsRepository") @Table(name="notifications")
 */

class Notifications
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $notification_text;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $to_all;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $to_type;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $to_course;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $to_dept;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $to_sem;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $to_stream;

    /**
     * @Column(type="integer", length=11, nullable=true)
     */
    protected $is_active;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $by_username;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $posted_on;

    /**
     * @Column(type="text", nullable=true)
     */
    protected $title;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $deactivate_on;

    /**
     * @Column(type="json_array",nullable=true)
     */
    protected $application_file;

    

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set notificationText.
     *
     * @param string|null $notificationText
     *
     * @return Notifications
     */
    public function setNotificationText($notificationText = null)
    {
        $this->notification_text = $notificationText;

        return $this;
    }

    /**
     * Get notificationText.
     *
     * @return string|null
     */
    public function getNotificationText()
    {
        return $this->notification_text;
    }

    /**
     * Set toAll.
     *
     * @param string|null $toAll
     *
     * @return Notifications
     */
    public function setToAll($toAll = null)
    {
        $this->to_all = $toAll;

        return $this;
    }

    /**
     * Get toAll.
     *
     * @return string|null
     */
    public function getToAll()
    {
        return $this->to_all;
    }

    /**
     * Set toType.
     *
     * @param string|null $toType
     *
     * @return Notifications
     */
    public function setToType($toType = null)
    {
        $this->to_type = $toType;

        return $this;
    }

    /**
     * Get toType.
     *
     * @return string|null
     */
    public function getToType()
    {
        return $this->to_type;
    }

    /**
     * Set toCourse.
     *
     * @param string|null $toCourse
     *
     * @return Notifications
     */
    public function setToCourse($toCourse = null)
    {
        $this->to_course = $toCourse;

        return $this;
    }

    /**
     * Get toCourse.
     *
     * @return string|null
     */
    public function getToCourse()
    {
        return $this->to_course;
    }

    /**
     * Set toDept.
     *
     * @param string|null $toDept
     *
     * @return Notifications
     */
    public function setToDept($toDept = null)
    {
        $this->to_dept = $toDept;

        return $this;
    }

    /**
     * Get toDept.
     *
     * @return string|null
     */
    public function getToDept()
    {
        return $this->to_dept;
    }

    /**
     * Set toSem.
     *
     * @param string|null $toSem
     *
     * @return Notifications
     */
    public function setToSem($toSem = null)
    {
        $this->to_sem = $toSem;

        return $this;
    }

    /**
     * Get toSem.
     *
     * @return string|null
     */
    public function getToSem()
    {
        return $this->to_sem;
    }

    /**
     * Set toStream.
     *
     * @param string|null $toStream
     *
     * @return Notifications
     */
    public function setToStream($toStream = null)
    {
        $this->to_stream = $toStream;

        return $this;
    }

    /**
     * Get toStream.
     *
     * @return string|null
     */
    public function getToStream()
    {
        return $this->to_stream;
    }

    /**
     * Set isActive.
     *
     * @param int|null $isActive
     *
     * @return Notifications
     */
    public function setIsActive($isActive = null)
    {
        $this->is_active = $isActive;

        return $this;
    }

    /**
     * Get isActive.
     *
     * @return int|null
     */
    public function getIsActive()
    {
        return $this->is_active;
    }

    /**
     * Set byUsername.
     *
     * @param string|null $byUsername
     *
     * @return Notifications
     */
    public function setByUsername($byUsername = null)
    {
        $this->by_username = $byUsername;

        return $this;
    }

    /**
     * Get byUsername.
     *
     * @return string|null
     */
    public function getByUsername()
    {
        return $this->by_username;
    }

    /**
     * Set postedOn.
     *
     * @param string|null $postedOn
     *
     * @return Notifications
     */
    public function setPostedOn($postedOn = null)
    {
        $this->posted_on = $postedOn;

        return $this;
    }

    /**
     * Get postedOn.
     *
     * @return string|null
     */
    public function getPostedOn()
    {
        return $this->posted_on;
    }

    /**
     * Set deactivateOn.
     *
     * @param string|null $deactivateOn
     *
     * @return Notifications
     */
    public function setDeactivateOn($deactivateOn = null)
    {
        $this->deactivate_on = $deactivateOn;

        return $this;
    }

    /**
     * Get deactivateOn.
     *
     * @return string|null
     */
    public function getDeactivateOn()
    {
        return $this->deactivate_on;
    }

    /**
     * Set applicationFile.
     *
     * @param array|null $applicationFile
     *
     * @return Notifications
     */
    public function setApplicationFile($applicationFile = null)
    {
        $this->application_file = $applicationFile;

        return $this;
    }

    /**
     * Get applicationFile.
     *
     * @return array|null
     */
    public function getApplicationFile()
    {
        return $this->application_file;
    }

    /**
     * Set title.
     *
     * @param string|null $title
     *
     * @return Notifications
     */
    public function setTitle($title = null)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title.
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
}
