<?php

use Doctrine\ORM\EntityRepository;

class NotificationsRepository extends EntityRepository
{

    public function addNotification($body)
    {
        $entityManager = $this->getEntityManager();

        //get the body data

        $notification_text = addslashes(strip_tags(trim($body['notification_text'])));
        $to_all = addslashes(strip_tags(trim($body['to_all'])));
        $to_type = addslashes(strip_tags(trim($body['to_type'])));
        $to_course = addslashes(strip_tags(trim($body['to_course'])));
        $to_dept = addslashes(strip_tags(trim($body['to_dept'])));
        $to_sem = addslashes(strip_tags(trim($body['to_sem'])));
        $to_stream = addslashes(strip_tags(trim($body['to_stream'])));
        $by_username = addslashes(strip_tags(trim($body['by_username'])));
        $posted_on = date('d-m-Y H:i:s');
        $deactivate_on = addslashes(strip_tags(trim($body['deactivate_on'])));

        $noti = new Notifications();
        $noti->setNotificationText($notification_text);
        $noti->setToAll($to_all);
        $noti->setToType($to_type);
        $noti->setToCourse($to_course);
        $noti->setToDept($to_dept);
        $noti->setToSem($to_sem);
        $noti->setToStream($to_stream);
        $noti->setIsActive(1);
        $noti->setByUsername($by_username);
        $noti->setPostedOn($posted_on);
        $noti->setDeactivateOn($deactivate_on);
        $entityManager->persist($noti);
        $entityManager->flush();

        return "Successfully Submitted & broadcasted";
    }

    public function updateNotification($id, $body)
    {
        $entityManager = $this->getEntityManager();

        //get the body data

        $notification_text = addslashes(strip_tags(trim($body['notification_text'])));
        $to_all = addslashes(strip_tags(trim($body['to_all'])));
        $to_type = addslashes(strip_tags(trim($body['to_type'])));
        $to_course = addslashes(strip_tags(trim($body['to_course'])));
        $to_dept = addslashes(strip_tags(trim($body['to_dept'])));
        $to_sem = addslashes(strip_tags(trim($body['to_sem'])));
        $to_stream = addslashes(strip_tags(trim($body['to_stream'])));
        $by_username = addslashes(strip_tags(trim($body['by_username'])));
        $posted_on = date('d-m-Y H:i:s');
        $deactivate_on = addslashes(strip_tags(trim($body['deactivate_on'])));

        $r = $this->getNotificationForEdit($id);
        if (sizeof($r) > 0) {
            $r[0]->setNotificationText($notification_text);
            $r[0]->setToAll($to_all);
            $r[0]->setToType($to_type);
            $r[0]->setToCourse($to_course);
            $r[0]->setToDept($to_dept);
            $r[0]->setToSem($to_sem);
            $r[0]->setToStream($to_stream);
            $r[0]->setIsActive(1);
            $r[0]->setByUsername($by_username);
            $r[0]->setPostedOn($posted_on);
            $r[0]->setDeactivateOn($deactivate_on);
            $entityManager->persist($r[0]);
            $entityManager->flush();

            return "Updated Successfully";

        } else {

            return "Not Exists";

        }

    }

    public function deleteNotification($id)
    {
        $dql = "DELETE FROM Notifications r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $query->getResult();
        return "Successfully deleted";
    }

    private function getNotificationForEdit($id)
    {
        $dql = "SELECT r FROM Notifications r WHERE r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function getNotifications()
    {
        $dql = "SELECT r.id,r.notification_text,r.to_all,r.to_type,r.to_course,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r order by r.id desc";
        $query = $this->getEntityManager()->createQuery($dql);
        return $query->getResult();
    }

    public function getNotificationsEmployee()
    {
        $a = array();
        $i = 0;

        $today = date('Y-m-d');

        $dql1 = "SELECT r.id,r.notification_text,r.to_all,r.to_type,r.to_course,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_all='YES' AND r.deactivate_on >= :today order by r.posted_on desc";
        $query1 = $this->getEntityManager()->createQuery($dql1)->setParameter('today', $today);
        if (sizeof($query1->getResult()) > 0) {
            $r = $query1->getResult();
            $a = array_merge($a, $r);
        }

        $dql2 = "SELECT r.id,r.notification_text,r.to_all,r.to_type,r.to_course,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_type='TEACHER' AND r.deactivate_on >= :today order by r.posted_on desc";
        $query2 = $this->getEntityManager()->createQuery($dql2)->setParameter('today', $today);
        if (sizeof($query2->getResult()) > 0) {
            $r = $query2->getResult();
            $a = array_merge($a, $r);
        }
        return $a;
    }

    public function getNotificationsStudent($email)
    {
        $a = array();
        $b = array();
        $i = 0;
        $today = date('Y-m-d');

        $b[0] = $this->getEntityManager()->getRepository('Student')->getStudentByEmail($email);

        $dql1 = "SELECT r.id,r.notification_text,r.title,r.to_all,r.to_type,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_all='YES'   order by r.posted_on desc";
        $query1 = $this->getEntityManager()->createQuery($dql1);
            
        if (sizeof($query1->getResult()) > 0) {
            $r = $query1->getResult();
            $a = array_merge($a, $r);

        }

        $dql2 = "SELECT r.id,r.title,r.notification_text,r.to_all,r.to_type,r.to_dept,r.to_sem,r.to_stream, r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_type='STUDENT' AND r.to_dept='' AND r.to_sem='' AND r.to_stream=''   order by r.posted_on desc";
        $query2 = $this->getEntityManager()->createQuery($dql2);
            
        if (sizeof($query2->getResult()) > 0) {
            $r = $query2->getResult();
            $a = array_merge($a, $r);

        }

        $dql33 = "SELECT r.id,r.title,r.notification_text,r.to_all,r.to_type,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_type='STUDENT' AND r.to_course=:course AND r.to_dept='' AND r.to_sem='' AND r.to_stream=''  order by r.posted_on desc";
        $query33 = $this->getEntityManager()->createQuery($dql33)
            ->setParameter('course', $b[0]['course']);
           
        if (sizeof($query33->getResult()) > 0) {
            $r = $query33->getResult();
            $a = array_merge($a, $r);

        }

        $dql3 = "SELECT r.id,r.title,r.notification_text,r.to_all,r.to_type,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_type='STUDENT' AND r.to_course=:course AND r.to_dept=:dept_code AND r.to_sem='' AND r.to_stream='' order by r.posted_on desc";
        $query3 = $this->getEntityManager()->createQuery($dql3)
            ->setParameter('dept_code', $b[0]['dept_code'])
            ->setParameter('course', $b[0]['course']);
           
        if (sizeof($query3->getResult()) > 0) {
            $r = $query3->getResult();
            $a = array_merge($a, $r);

        }

        /*$dql3 = "SELECT r.id,r.notification_text,r.to_all,r.to_type,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_type='STUDENT' AND r.to_course=:course AND r.to_dept=:dept_code AND r.to_sem='' AND r.to_stream='' AND r.deactivate_on >= :today order by r.posted_on desc";
        $query3 = $this->getEntityManager()->createQuery($dql3)
        ->setParameter('dept_code', $b[0]['dept_code'])
        ->setParameter('course', $b[0]['course'])
        ->setParameter('today', $today);
        if (sizeof($query3->getResult()) > 0) {
        $r = $query3->getResult();
        $a = array_merge($a, $r);

        }

        $dql4 = "SELECT r.id,r.notification_text,r.to_all,r.to_type,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_type='STUDENT' AND r.to_course=:course AND r.to_dept=:dept_code AND r.to_sem=:sem AND r.to_stream='' AND r.deactivate_on >= :today order by r.posted_on desc";
        $query4 = $this->getEntityManager()->createQuery($dql4)->setParameter('dept_code', $b[0]['dept_code'])
        ->setParameter('course', $b[0]['course'])
        ->setParameter('sem', $b[0]['semester'])
        ->setParameter('today', $today);
        if (sizeof($query4->getResult()) > 0) {
        $r = $query4->getResult();
        $a = array_merge($a, $r);

        }

        $dql5 = "SELECT r.id,r.notification_text,r.to_all,r.to_type,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_type='STUDENT' AND r.to_course=:course AND r.to_dept=:dept_code AND r.to_sem=:sem AND r.to_stream=:stream AND r.deactivate_on >= :today order by r.posted_on desc";
        $query5 = $this->getEntityManager()->createQuery($dql5)->setParameter('dept_code', $b[0]['dept_code'])
        ->setParameter('course', $b[0]['course'])
        ->setParameter('sem', $b[0]['semester'])
        ->setParameter('stream', $b[0]['stream'])
        ->setParameter('today', $today);
        if (sizeof($query5->getResult()) > 0) {
        $r = $query5->getResult();
        $a = array_merge($a, $r);
        }

        $dql5 = "SELECT r.id,r.notification_text,r.to_all,r.to_type,r.to_dept,r.to_sem,r.to_stream,r.by_username,r.posted_on,r.is_active,r.deactivate_on FROM Notifications r where r.to_type='STUDENT' AND r.to_course=:course AND r.to_dept='' AND r.to_sem=:sem AND r.to_stream=:stream AND r.deactivate_on >= :today order by r.posted_on desc";
        $query5 = $this->getEntityManager()->createQuery($dql5)
        ->setParameter('course', $b[0]['course'])
        ->setParameter('sem', $b[0]['semester'])
        ->setParameter('stream', $b[0]['stream'])
        ->setParameter('today', $today);
        if (sizeof($query5->getResult()) > 0) {
        $r = $query5->getResult();
        $a = array_merge($a, $r);

        } */

        usort($a, function ($a1, $b1) { //Sort the array using a user defined function

            return $a1['id'] > $b1['id'] ? -1 : 1; //Compare the scores
        });

        return $a;
    }

    // public function getNotificationsSingle($email)
    // {
    //     if()
    // }

    public function updateStatusOfNotification($id, $status)
    {
        $entityManager = $this->getEntityManager();

        $result = $this->getNotificationForEdit($id);
        if (sizeof($result) > 0) {
            $result[0]->setIsActive($status);
            $entityManager->persist($result[0]);
            $entityManager->flush();

            return "Successfully Updated";
        } else {
            return "Update not successful";
        }
    }

}
