<?php

/**
 * @Entity(repositoryClass="PaperMasterRepository") @Table(name="paper_master")
 */

class PaperMaster
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=10, nullable=true)
     */
    protected $semester;



    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $sub_code;

     

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $paper_code;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $paper_name;


    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $paper_tp_type;

    /**
     * @Column(type="string",length=10)
     */
    protected $paper_credit_theory;

    /**
     * @Column(type="string",length=10)
     */
    protected $paper_credit_practical;

    /**
     * @Column(type="string",length=10)
     */
    protected $paper_credit_project;

    /**
     * @Column(type="string",length=200, nullable=true)
     */
    protected $link;

    

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return PaperMaster
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set semester.
     *
     * @param string|null $semester
     *
     * @return PaperMaster
     */
    public function setSemester($semester = null)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return string|null
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set subCode.
     *
     * @param string|null $subCode
     *
     * @return PaperMaster
     */
    public function setSubCode($subCode = null)
    {
        $this->sub_code = $subCode;

        return $this;
    }

    /**
     * Get subCode.
     *
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->sub_code;
    }

    /**
     * Set paperCode.
     *
     * @param string|null $paperCode
     *
     * @return PaperMaster
     */
    public function setPaperCode($paperCode = null)
    {
        $this->paper_code = $paperCode;

        return $this;
    }

    /**
     * Get paperCode.
     *
     * @return string|null
     */
    public function getPaperCode()
    {
        return $this->paper_code;
    }

    /**
     * Set paperName.
     *
     * @param string|null $paperName
     *
     * @return PaperMaster
     */
    public function setPaperName($paperName = null)
    {
        $this->paper_name = $paperName;

        return $this;
    }

    /**
     * Get paperName.
     *
     * @return string|null
     */
    public function getPaperName()
    {
        return $this->paper_name;
    }

    /**
     * Set paperTpType.
     *
     * @param string|null $paperTpType
     *
     * @return PaperMaster
     */
    public function setPaperTpType($paperTpType = null)
    {
        $this->paper_tp_type = $paperTpType;

        return $this;
    }

    /**
     * Get paperTpType.
     *
     * @return string|null
     */
    public function getPaperTpType()
    {
        return $this->paper_tp_type;
    }

    /**
     * Set paperCreditTheory.
     *
     * @param string $paperCreditTheory
     *
     * @return PaperMaster
     */
    public function setPaperCreditTheory($paperCreditTheory)
    {
        $this->paper_credit_theory = $paperCreditTheory;

        return $this;
    }

    /**
     * Get paperCreditTheory.
     *
     * @return string
     */
    public function getPaperCreditTheory()
    {
        return $this->paper_credit_theory;
    }

    /**
     * Set paperCreditPractical.
     *
     * @param string $paperCreditPractical
     *
     * @return PaperMaster
     */
    public function setPaperCreditPractical($paperCreditPractical)
    {
        $this->paper_credit_practical = $paperCreditPractical;

        return $this;
    }

    /**
     * Get paperCreditPractical.
     *
     * @return string
     */
    public function getPaperCreditPractical()
    {
        return $this->paper_credit_practical;
    }

    /**
     * Set paperCreditProject.
     *
     * @param string $paperCreditProject
     *
     * @return PaperMaster
     */
    public function setPaperCreditProject($paperCreditProject)
    {
        $this->paper_credit_project = $paperCreditProject;

        return $this;
    }

    /**
     * Get paperCreditProject.
     *
     * @return string
     */
    public function getPaperCreditProject()
    {
        return $this->paper_credit_project;
    }

    /**
     * Set link.
     *
     * @param string|null $link
     *
     * @return PaperMaster
     */
    public function setLink($link = null)
    {
        $this->link = $link;

        return $this;
    }

    /**
     * Get link.
     *
     * @return string|null
     */
    public function getLink()
    {
        return $this->link;
    }
}
