<?php

use Doctrine\ORM\EntityRepository;

class PaperMasterRepository extends EntityRepository
{

    public function addPaperMaster($body)
    {
        $entityManager = $this->getEntityManager();

        $sub_id = addslashes(strip_tags(trim($body['sub_id'])));
        $paper_code = addslashes(strip_tags(trim($body['paper_code'])));
        $paper_title = addslashes(strip_tags(trim($body['paper_title'])));
        $total_marks = addslashes(strip_tags(trim($body['total_marks'])));
        $pass_marks = addslashes(strip_tags(trim($body['pass_marks'])));
        $semester = addslashes(strip_tags(trim($body['semester'])));

        if (sizeof($this->checkPaperCode($paper_code)) == 0) {
            $sub = new PaperMaster();
            $sub->setSubId($sub_id);
            $sub->setPaperCode($paper_code);
            $sub->setPaperTitle($paper_title);
            $sub->setTotalMarks($total_marks);
            $sub->setPassMarks($pass_marks);
            $sub->setSemester($semester);
            $entityManager->persist($sub);
            $entityManager->flush();
            if (null != $sub->getId()) {
                return "Paper Code Registered Successfully.";
            }
        } else {
            return "Paper Code already registered.";
        }
    }


    public function getPaperByCode($body)
    {

        $semester = addslashes(strip_tags(trim($body['semester'])));
        $sub_code = addslashes(strip_tags(trim($body['sub_code'])));

        $dql = "SELECT r.id,r.sub_id,r.paper_code,r.semester,r.paper_title,r.total_marks,r.pass_marks, s.sub_name,s.sub_code From PaperMaster r, SubjectMaster s WHERE r.sub_id=s.id AND s.sub_code=:sub_code AND r.semester=:semester";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('sub_code', $sub_code)
            ->setParameter('semester', $semester);
        $result = $query->getResult();
        return $result;
    }


    public function getPaperCode()
    {
        $dql = "SELECT r.id,r.sub_id,r.paper_code,r.semester,r.paper_title,r.total_marks,r.pass_marks, s.sub_name,s.sub_code From PaperMaster r, SubjectMaster s WHERE r.sub_id=s.id";
        $query = $this->getEntityManager()->createQuery($dql);
        $result = $query->getResult();
        $index = 0;
        foreach ($result as $r) {
            $result[$index]['value'] = $r['paper_code'];
            $result[$index]['label'] = $r['sub_name'] . ' - ' . $r['paper_code'];
            $index++;
        }

        return $result;
    }

    public function getPaperCodeBySubCode($sub_code)
    {

        $dql = "SELECT r.id,r.course,r.semester,r.sub_code,r.paper_code,r.paper_name,r.paper_tp_type,r.paper_credit_theory,r.paper_credit_practical,r.paper_credit_project,r.link,s.sub_name,s.sub_type From PaperMaster r, SubjectMaster s WHERE r.sub_code=s.sub_code AND r.sub_code=:sub_code";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('sub_code', $sub_code);
        $result = $query->getResult();
        $index = 0;
        foreach ($result as $r) {
            $result[$index]['value'] = $r['paper_code'];
            $result[$index]['label'] = $r['paper_name'] . ' - ' . $r['paper_code'];
            $index++;
        }

        return $result;

    }

    public function getPaperName($paper_code)
    {
        $dql = "SELECT r.paper_title From PaperMaster r where r.paper_code=:paper_code";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('paper_code', $paper_code);
        $result = $query->getResult();
        if (sizeof($result) > 0) {
            return $result[0]['paper_title'];
        } else {
            return null;
        }
    }

    private function getPaperCodeForEdit($id)
    {
        $dql = "SELECT r from PaperMaster r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function getPaperByPaperCode($paper_code)
    {
        $dql = "SELECT r from PaperMaster r where r.paper_code=:paper_code";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('paper_code', $paper_code);
        return $query->getResult();
    }

    public function updatePaperCode($id, $body)
    {

        $entityManager = $this->getEntityManager();
        $sub_id = addslashes(strip_tags(trim($body['sub_id'])));
        $paper_code = addslashes(strip_tags(trim($body['paper_code'])));
        $paper_title = addslashes(strip_tags(trim($body['paper_title'])));
        $total_marks = addslashes(strip_tags(trim($body['total_marks'])));
        $pass_marks = addslashes(strip_tags(trim($body['pass_marks'])));
        $semester = addslashes(strip_tags(trim($body['semester'])));

        $result = $this->getPaperCodeForEdit($id);
        if (sizeof($result) == 1) {
            $result[0]->setSubId($sub_id);
            $result[0]->setPaperCode($paper_code);
            
            $result[0]->setPaperTitle($paper_title);
            
            $result[0]->setTotalMarks($total_marks);
            $result[0]->setPassMarks($pass_marks);
            $result[0]->setSemester($semester);
            $entityManager->persist($result[0]);
            $entityManager->flush();
            if ($result[0]->getId() != null) {

                return "Paper Code Updated Successfully.";
            }
        } else {
            return "Not Found.";
        }
    }

    public function checkPaperCode($paper_code)
    {
        $dql = 'SELECT r FROM PaperMaster r WHERE r.paper_code=:paper_code';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('paper_code', $paper_code);
        return $query->getResult();
    }

    public function deletePaperCode($id)
    {
        $dql = 'DELETE  FROM PaperMaster r WHERE r.id=:id';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $query->getResult();
        return 'Successfully Deleted';
    }
}
