<?php

/**
 * @Entity(repositoryClass="RoutineRepository") @Table(name="routine")
 */

class Routine
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

     /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $session;

    /**
     * @Column(type="string",length=10, nullable=true)
     */
    protected $section;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $stream;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $sub_code;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $course_type;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $teacher;

    /**
     * @Column(type="string",length=30, nullable=true)
     */
    protected $day;

    /**
     * @Column(type="integer",length=11)
     */
    protected $semester;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $room_number;


    /**
     * @Column(type="integer",length=11)
     */
    protected $period_number;


    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $start_time;


    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $end_time;
   


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set session.
     *
     * @param string|null $session
     *
     * @return Routine
     */
    public function setSession($session = null)
    {
        $this->session = $session;

        return $this;
    }

    /**
     * Get session.
     *
     * @return string|null
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return Routine
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set stream.
     *
     * @param string|null $stream
     *
     * @return Routine
     */
    public function setStream($stream = null)
    {
        $this->stream = $stream;

        return $this;
    }

    /**
     * Get stream.
     *
     * @return string|null
     */
    public function getStream()
    {
        return $this->stream;
    }

    /**
     * Set subCode.
     *
     * @param string|null $subCode
     *
     * @return Routine
     */
    public function setSubCode($subCode = null)
    {
        $this->sub_code = $subCode;

        return $this;
    }

    /**
     * Get subCode.
     *
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->sub_code;
    }

    /**
     * Set teacher.
     *
     * @param string|null $teacher
     *
     * @return Routine
     */
    public function setTeacher($teacher = null)
    {
        $this->teacher = $teacher;

        return $this;
    }

    /**
     * Get teacher.
     *
     * @return string|null
     */
    public function getTeacher()
    {
        return $this->teacher;
    }

    /**
     * Set day.
     *
     * @param string|null $day
     *
     * @return Routine
     */
    public function setDay($day = null)
    {
        $this->day = $day;

        return $this;
    }

    /**
     * Get day.
     *
     * @return string|null
     */
    public function getDay()
    {
        return $this->day;
    }

    /**
     * Set semester.
     *
     * @param int $semester
     *
     * @return Routine
     */
    public function setSemester($semester)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return int
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set roomNumber.
     *
     * @param int $roomNumber
     *
     * @return Routine
     */
    public function setRoomNumber($roomNumber)
    {
        $this->room_number = $roomNumber;

        return $this;
    }

    /**
     * Get roomNumber.
     *
     * @return int
     */
    public function getRoomNumber()
    {
        return $this->room_number;
    }

    /**
     * Set periodNumber.
     *
     * @param int $periodNumber
     *
     * @return Routine
     */
    public function setPeriodNumber($periodNumber)
    {
        $this->period_number = $periodNumber;

        return $this;
    }

    /**
     * Get periodNumber.
     *
     * @return int
     */
    public function getPeriodNumber()
    {
        return $this->period_number;
    }

    /**
     * Set startTime.
     *
     * @param string|null $startTime
     *
     * @return Routine
     */
    public function setStartTime($startTime = null)
    {
        $this->start_time = $startTime;

        return $this;
    }

    /**
     * Get startTime.
     *
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    /**
     * Set endTime.
     *
     * @param string|null $endTime
     *
     * @return Routine
     */
    public function setEndTime($endTime = null)
    {
        $this->end_time = $endTime;

        return $this;
    }

    /**
     * Get endTime.
     *
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    /**
     * Set section.
     *
     * @param string|null $section
     *
     * @return Routine
     */
    public function setSection($section = null)
    {
        $this->section = $section;

        return $this;
    }

    /**
     * Get section.
     *
     * @return string|null
     */
    public function getSection()
    {
        return $this->section;
    }

    /**
     * Set courseType.
     *
     * @param string|null $courseType
     *
     * @return Routine
     */
    public function setCourseType($courseType = null)
    {
        $this->course_type = $courseType;

        return $this;
    }

    /**
     * Get courseType.
     *
     * @return string|null
     */
    public function getCourseType()
    {
        return $this->course_type;
    }
}
