<?php

use Doctrine\ORM\EntityRepository;

class RoutineRepository extends EntityRepository
{

    public function getStudentClassesShort($body)
    {
        $em = $this->getEntityManager();


        $rr = [];
        $a = array();

        $c = array();
        foreach ($body['subjects'] as $s) {
            array_push($a, $s['sub_code']);
        }

        

        foreach ($a as $b) {

            $course = $body['course'];
            $semester = $body['semester'];

            $c = $em->getRepository('Section')->getSemSection($body['id'], $b);
            if ($c == false) {
                // get
                $sql = "SELECT r.id,r.section,r.sub_code,r.teacher,r.day,r.semester,r.course_type,r.room_number,r.period_number,r.start_time,r.end_time,s.sub_name,u.dept_code, u.name From routine r,subject_master s, employee u WHERE r.course_completed=0 AND r.teacher=u.email AND  r.sub_code=s.sub_code  AND r.semester=:semester AND r.sub_code=:sub_code  AND r.course=:course order by r.period_number ASC";
                $stmt = $em->getConnection()->prepare($sql);

               
                $stmt->bindParam(':course', $course, PDO::PARAM_STR);
                
                $stmt->bindParam(':sub_code', $b, PDO::PARAM_STR);
                
                $stmt->bindParam(':semester', $semester, PDO::PARAM_INT);
                $stmt->execute();
                $r1 = $stmt->fetchAll();

                // now we perform a course type check

                $r2 = [];

                foreach ($r1 as $routine) {
                    if ($routine['course_type'] == '') {
                        array_push($r2, $routine);
                    } else {
                        if ($body['course_type'] == $routine['course_type']) {
                            array_push($r2, $routine);
                        }
                    }
                }

                $r1 = $r2;
            } else {

                $sec = $c['section'];

                $sql = "SELECT r.id,r.section,r.sub_code,r.teacher,r.day,r.semester,r.course_type,r.room_number,r.period_number,r.start_time,r.end_time,s.sub_name,u.dept_code, u.name From routine r,subject_master s, employee u WHERE r.course_completed=0 AND r.teacher=u.email AND  r.sub_code=s.sub_code  AND r.semester=:semester AND r.sub_code=:sub_code AND r.section=:section AND r.course=:course order by r.period_number ASC";
                $stmt = $em->getConnection()->prepare($sql);
                $stmt->bindParam(':course', $course, PDO::PARAM_STR);
                $stmt->bindParam(':section', $sec, PDO::PARAM_STR);
                $stmt->bindParam(':sub_code', $b, PDO::PARAM_STR);
                $stmt->bindParam(':semester', $semester, PDO::PARAM_INT);
                $stmt->execute();
                $r1 = $stmt->fetchAll();
            }

            $rr = array_merge($rr, $r1);
            $r1 = [];
        }
        return $rr;
    }


    public function getOneClassDetails($body)
    {

        $r1 = [];

        $date1 = date('d-m-Y');
        $course = addslashes(strip_tags(trim($body['course'])));
        
        $semester = addslashes(strip_tags(trim($body['semester'])));
        $sub_code = addslashes(strip_tags(trim($body['sub_code'])));
        $course_type = addslashes(strip_tags(trim($body['course_type'])));
        $teacher = addslashes(strip_tags(trim($body['teacher'])));

        $section = addslashes(strip_tags(trim($body['section'])));
        $email = addslashes(strip_tags(trim($body['email'])));
        $student_id = addslashes(strip_tags(trim($body['student_id'])));
        $period_number = addslashes(strip_tags(trim($body['period_number'])));

        // check attendance

        $sql = "SELECT * FROM attendance WHERE date1=:date1 AND sub_code=:sub_code AND semester=:semester AND period_number=:period_number AND course=:course AND json_contains(attendance->'$[*].id', json_array(:id))";
        $stmt = $this->getEntityManager()->getConnection()->prepare($sql);
        $stmt->bindParam(':date1', $date1, PDO::PARAM_STR);
        $stmt->bindParam(':semester', $semester, PDO::PARAM_STR);
        $stmt->bindParam(':sub_code', $sub_code, PDO::PARAM_STR);
        $stmt->bindParam(':course', $course, PDO::PARAM_STR);
        $stmt->bindParam(':id', $student_id, PDO::PARAM_STR);
        $stmt->bindParam(':period_number', $period_number, PDO::PARAM_INT);
        $stmt->execute();

        $r11 = $stmt->fetchAll();

        if (sizeof($r11) > 0) {

            $json = json_decode($r11[0]['attendance']);
            foreach ($json as $j) {
                if ($j->id === $student_id) {
                    if ($j->status === true) {
                        $r1['astatus'] = true;


                        

                        $main_topic = $r11[0]['paper_code']. " :: ".$r11[0]['topic'];

                        $r1['atopic'] = $main_topic;
                    } else {
                        $r1['astatus'] = false;
                        $r1['atopic'] = "You were absent in the class";
                    }
                    break;
                }
            }

        } else {
            $r1['astatus'] = false;
            $r1['atopic'] = "";

            $sql1 = "SELECT * FROM class_cancel WHERE sub_code=:sub_code AND teacher=:teacher AND period_number=:period_number AND date1=:date1";
            $stmt1 = $this->getEntityManager()->getConnection()->prepare($sql1);
            $stmt1->bindParam(':date1', $date1, PDO::PARAM_STR);
            $stmt1->bindParam(':sub_code', $sub_code, PDO::PARAM_STR);
            $stmt1->bindParam(':teacher', $teacher, PDO::PARAM_STR);
            $stmt1->bindParam(':period_number', $period_number, PDO::PARAM_INT);
            $stmt1->execute();

            $rr = $stmt1->fetchAll();

            if (sizeof($rr) > 0) {
                $r1['status'] = true;
                $r1['reason'] = $rr[0]['reason'];
            } else {
                $r1['status'] = false;
                $r1['reason'] = '';

            }

        }

        return $r1;

    }
}
