<?php

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Entity(repositoryClass="SectionRepository") @Table(name="section")
 */

class Section
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;


     /**
     * @Column(type="string",length=10)
     */
    protected $section;

    /**
     * @Column(type="integer",length=11)
     */
    protected $semester;

    /**
     * @Column(type="string",length=30)
     */
    protected $sub_code;

    /**
     * @Column(type="string",length=30)
     */
    protected $course;

    /**
     * @Column(type="string",length=30)
     */
    protected $session;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $student_data;


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set sectionName.
     *
     * @param string|null $sectionName
     *
     * @return Section
     */
    public function setSection($section = null)
    {
        $this->section = $section;

        return $this;
    }

    /**
     * Get sectionName.
     *
     * @return string|null
     */
    public function getSection()
    {
        return $this->section;
    }

    /**
     * Set semester.
     *
     * @param int|null $semester
     *
     * @return Section
     */
    public function setSemester($semester = null)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return int|null
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set subCode.
     *
     * @param string|null $subCode
     *
     * @return Section
     */
    public function setSubCode($subCode = null)
    {
        $this->sub_code = $subCode;

        return $this;
    }

    /**
     * Get subCode.
     *
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->sub_code;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return Section
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set session.
     *
     * @param string $session
     *
     * @return Section
     */
    public function setSession($session)
    {
        $this->session = $session;

        return $this;
    }

    /**
     * Get session.
     *
     * @return string
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Set studentData.
     *
     * @param array|null $studentData
     *
     * @return Section
     */
    public function setStudentData($studentData = null)
    {
        $this->student_data = $studentData;

        return $this;
    }

    /**
     * Get studentData.
     *
     * @return array|null
     */
    public function getStudentData()
    {
        return $this->student_data;
    }
}
