<?php

use Doctrine\ORM\EntityRepository;

class SessionMasterRepository extends EntityRepository
{

    public function addSession($body)
    {
        $entityManager = $this->getEntityManager();

        $session_name = addslashes(strip_tags(trim($body['session_name'])));
        $is_active = addslashes(strip_tags(trim($body['is_active'])));

        if (sizeof($this->checkSession($session_name)) == 0) {
            $sm = new SessionMaster();

            $sm->setSessionName($session_name);
            $sm->setIsActive($is_active);
            $entityManager->persist($sm);
            $entityManager->flush();
            return "Session Registered Successfully.";
        } else {
            return "Session already registered.";
        }

    }

    public function getActiveSession()
    {
        $dql = "SELECT r From SessionMaster r where r.is_active=1 order by r.id desc";
        $query = $this->getEntityManager()->createQuery($dql)->setMaxResults(1);
        return $query->getResult();
    }

    public function getSession()
    {
        $dql = "SELECT r.id,r.session_name,r.is_active From SessionMaster r";
        $query = $this->getEntityManager()->createQuery($dql);
        return $query->getResult();
    }

    public function getSessionSingle($id)
    {
        $dql = "SELECT r.id,r.session_name,r.is_active From SessionMaster r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    private function getSessionForEdit($id)
    {
        $dql = "SELECT r from SessionMaster r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        return $query->getResult();
    }

    public function updateSession($id, $body)
    {
        $entityManager = $this->getEntityManager();

        $session_name = addslashes(strip_tags(trim($body['session_name'])));
        $is_active = addslashes(strip_tags(trim($body['is_active'])));

        $result = $this->getSessionForEdit($id);
        if (sizeof($result) == 1 && sizeof($this->checkSession($session_name)) == 1) {

            $result[0]->setSessionName($session_name);
            $result[0]->setIsActive($is_active);
            
            $entityManager->persist($result[0]);
            $entityManager->flush();
            return "Session Updated Successfully.";
        } else {
            return "Not Found.";
        }

    }

    public function checkSession($session_name)
    {
        $dql = 'SELECT r FROM SessionMaster r WHERE r.session_name=:session_name';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('session_name', $session_name);
        return $query->getResult();
    }

    public function deleteSession($id)
    {
        $dql = 'DELETE  FROM SessionMaster r WHERE r.id=:id';
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $query->getResult();
        return true;
    }

    public function getActiveSessionSingle()
    {
        $dql = "SELECT r From SessionMaster r where r.is_active=1 order by r.id desc";
        $query = $this->getEntityManager()->createQuery($dql)->setMaxResults(1);
        $result = $query->getResult();

        if(sizeof($result) > 0){
            return $result[0]->getId();
        }else{
            return 0;
        }
    }
}
