<?php

/**
 * @Entity(repositoryClass="StudentRepository") @Table(name="student")
 */

class Student
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="integer",nullable=true,options={"default" : 0})
     */
    protected $class_id;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $course_type;


     /**
     * @Column(type="string",length=300,nullable=true)
     */
    protected $unique_id;
    

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $course;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $stream;

    /**
     * @Column(type="string",length=30,nullable=true)
     */
    protected $dept_code;

    /**
     * @Column(type="integer",length=11,nullable=true)
     */
    protected $semester;

    /**
     * @Column(type="integer",length=11,nullable=true)
     */
    protected $roll_serial;

    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */
    protected $session_id;


    /**
     * @Column(type="integer",nullable=true,options={"default":0})
     */
    protected $profile_updated=0;

    /**
     * @Column(type="string",length=100)
     */
    protected $name;

    /**
     * @Column(type="string",length=50)
     */
    protected $email;

   
    /**
     * @Column(type="string",length=20,nullable=true)
     */
    protected $gender;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $caste;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $date_of_birth;

    /**
     * @Column(type="string",length=15)
     */
    protected $phone;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $year_of_admission;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $roll_no;


    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $samarth_roll_no;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $registration_no;

     /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $university_roll_no;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $quota;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $state;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $religion;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $nationality;

    /**
     * @Column(type="string",length=10,nullable=true)
     */
    protected $is_handicapped;

    /**
     * @Column(type="text",nullable=true)
     */
    protected $disability;

    /**
     * @Column(type="string",length=10,nullable=true)
     */
    protected $is_ews;


    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $attendance;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $class_data;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $present_address;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $permanent_address;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $educational_details;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $last_exam;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $best_subjects;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $achievements;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $dp;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $signature;

    /**
     * @Column(type="integer",options={"default":0}, nullable=true)
     */

    protected $is_del;

    /**
     * @Column(type="json_array",nullable=true)
     */

    protected $subjects;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $bood_group;

    /**
     * @Column(type="string",length=200,nullable=true)
     */
    protected $local_g;

    /**
     * @Column(type="string",length=1000,nullable=true)
     */
    protected $extra_curr;

    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $p_occupation;

    /**
     * @Column(type="integer",options={"default":0},nullable=true)
     */

    protected $is_free_admission;

    /**
     * @Column(type="integer",options={"default":0},nullable=true)
     */

    protected $is_alumni;


    /**
     * @Column(type="integer",options={"default":0},nullable=true)
     */

    protected $has_promoted;

    /**
     * @Column(type="string",nullable=true)
     */

    protected $form_id;


    /**
     * @Column(type="string",nullable=true)
     */

    protected $shift;

    /**
     * @Column(type="integer",options={"default":0},nullable=true)
     */

    protected $is_newly_admitted;

    /**
     * @Column(type="integer",options={"default":0}, nullable=true)
     */

    protected $admission_type;


    /**
     * @Column(type="string",length=100,nullable=true)
     */

     protected $hostel;

      /**
     * @Column(type="string",length=100,nullable=true)
     */

     protected $primary_email;


    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $maratial_status;
 

    /**
     * @Column(type="string",length=20,nullable=true)
     */
    protected $is_pwd;

     /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $blood_group;

     /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $father_name;

     /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $father_phone;


        /**
     * @Column(type="string",length=120,nullable=true)
     */
    protected $father_email;

     /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $father_qualification;


    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $father_profession;



    /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $mother_name;



    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $mother_phone;


     /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $mother_qualification;


     /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $mother_profession;


      /**
     * @Column(type="string",length=100,nullable=true)
     */
    protected $annual_income;


     /**
     * @Column(type="json_array",nullable=true)
     */
    protected $local_address;

     /**
     * @Column(type="json_array",nullable=true)
     */
    protected $activities;


    /**
     * @Column(type="string",length=200,nullable=true)
     */
    protected $account_holder;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $account_no;

    /**
     * @Column(type="string",length=150,nullable=true)
     */
    protected $account_bank;


    /**
     * @Column(type="string",length=150,nullable=true)
     */
    protected $account_branch;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $account_ifsc;


    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $account_micr;




    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set classId.
     *
     * @param int|null $classId
     *
     * @return Student
     */
    public function setClassId($classId = null)
    {
        $this->class_id = $classId;

        return $this;
    }

    /**
     * Get classId.
     *
     * @return int|null
     */
    public function getClassId()
    {
        return $this->class_id;
    }

    /**
     * Set courseType.
     *
     * @param string|null $courseType
     *
     * @return Student
     */
    public function setCourseType($courseType = null)
    {
        $this->course_type = $courseType;

        return $this;
    }

    /**
     * Get courseType.
     *
     * @return string|null
     */
    public function getCourseType()
    {
        return $this->course_type;
    }

    /**
     * Set uniqueId.
     *
     * @param string|null $uniqueId
     *
     * @return Student
     */
    public function setUniqueId($uniqueId = null)
    {
        $this->unique_id = $uniqueId;

        return $this;
    }

    /**
     * Get uniqueId.
     *
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->unique_id;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return Student
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set stream.
     *
     * @param string|null $stream
     *
     * @return Student
     */
    public function setStream($stream = null)
    {
        $this->stream = $stream;

        return $this;
    }

    /**
     * Get stream.
     *
     * @return string|null
     */
    public function getStream()
    {
        return $this->stream;
    }

    /**
     * Set deptCode.
     *
     * @param string|null $deptCode
     *
     * @return Student
     */
    public function setDeptCode($deptCode = null)
    {
        $this->dept_code = $deptCode;

        return $this;
    }

    /**
     * Get deptCode.
     *
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->dept_code;
    }

    /**
     * Set semester.
     *
     * @param int|null $semester
     *
     * @return Student
     */
    public function setSemester($semester = null)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return int|null
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set rollSerial.
     *
     * @param int|null $rollSerial
     *
     * @return Student
     */
    public function setRollSerial($rollSerial = null)
    {
        $this->roll_serial = $rollSerial;

        return $this;
    }

    /**
     * Get rollSerial.
     *
     * @return int|null
     */
    public function getRollSerial()
    {
        return $this->roll_serial;
    }

    /**
     * Set sessionId.
     *
     * @param int|null $sessionId
     *
     * @return Student
     */
    public function setSessionId($sessionId = null)
    {
        $this->session_id = $sessionId;

        return $this;
    }

    /**
     * Get sessionId.
     *
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->session_id;
    }

    /**
     * Set profileUpdated.
     *
     * @param int|null $profileUpdated
     *
     * @return Student
     */
    public function setProfileUpdated($profileUpdated = null)
    {
        $this->profile_updated = $profileUpdated;

        return $this;
    }

    /**
     * Get profileUpdated.
     *
     * @return int|null
     */
    public function getProfileUpdated()
    {
        return $this->profile_updated;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return Student
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set email.
     *
     * @param string $email
     *
     * @return Student
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email.
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set gender.
     *
     * @param string|null $gender
     *
     * @return Student
     */
    public function setGender($gender = null)
    {
        $this->gender = $gender;

        return $this;
    }

    /**
     * Get gender.
     *
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Set caste.
     *
     * @param string|null $caste
     *
     * @return Student
     */
    public function setCaste($caste = null)
    {
        $this->caste = $caste;

        return $this;
    }

    /**
     * Get caste.
     *
     * @return string|null
     */
    public function getCaste()
    {
        return $this->caste;
    }

    /**
     * Set dateOfBirth.
     *
     * @param string|null $dateOfBirth
     *
     * @return Student
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        $this->date_of_birth = $dateOfBirth;

        return $this;
    }

    /**
     * Get dateOfBirth.
     *
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->date_of_birth;
    }

    /**
     * Set phone.
     *
     * @param string $phone
     *
     * @return Student
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * Get phone.
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Set yearOfAdmission.
     *
     * @param string|null $yearOfAdmission
     *
     * @return Student
     */
    public function setYearOfAdmission($yearOfAdmission = null)
    {
        $this->year_of_admission = $yearOfAdmission;

        return $this;
    }

    /**
     * Get yearOfAdmission.
     *
     * @return string|null
     */
    public function getYearOfAdmission()
    {
        return $this->year_of_admission;
    }

    /**
     * Set rollNo.
     *
     * @param string|null $rollNo
     *
     * @return Student
     */
    public function setRollNo($rollNo = null)
    {
        $this->roll_no = $rollNo;

        return $this;
    }

    /**
     * Get rollNo.
     *
     * @return string|null
     */
    public function getRollNo()
    {
        return $this->roll_no;
    }

    /**
     * Set registrationNo.
     *
     * @param string|null $registrationNo
     *
     * @return Student
     */
    public function setRegistrationNo($registrationNo = null)
    {
        $this->registration_no = $registrationNo;

        return $this;
    }

    /**
     * Get registrationNo.
     *
     * @return string|null
     */
    public function getRegistrationNo()
    {
        return $this->registration_no;
    }

    /**
     * Set universityRollNo.
     *
     * @param string|null $universityRollNo
     *
     * @return Student
     */
    public function setUniversityRollNo($universityRollNo = null)
    {
        $this->university_roll_no = $universityRollNo;

        return $this;
    }

    /**
     * Get universityRollNo.
     *
     * @return string|null
     */
    public function getUniversityRollNo()
    {
        return $this->university_roll_no;
    }

    /**
     * Set quota.
     *
     * @param string|null $quota
     *
     * @return Student
     */
    public function setQuota($quota = null)
    {
        $this->quota = $quota;

        return $this;
    }

    /**
     * Get quota.
     *
     * @return string|null
     */
    public function getQuota()
    {
        return $this->quota;
    }

    /**
     * Set state.
     *
     * @param string|null $state
     *
     * @return Student
     */
    public function setState($state = null)
    {
        $this->state = $state;

        return $this;
    }

    /**
     * Get state.
     *
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set religion.
     *
     * @param string|null $religion
     *
     * @return Student
     */
    public function setReligion($religion = null)
    {
        $this->religion = $religion;

        return $this;
    }

    /**
     * Get religion.
     *
     * @return string|null
     */
    public function getReligion()
    {
        return $this->religion;
    }

    /**
     * Set nationality.
     *
     * @param string|null $nationality
     *
     * @return Student
     */
    public function setNationality($nationality = null)
    {
        $this->nationality = $nationality;

        return $this;
    }

    /**
     * Get nationality.
     *
     * @return string|null
     */
    public function getNationality()
    {
        return $this->nationality;
    }

    /**
     * Set isHandicapped.
     *
     * @param string|null $isHandicapped
     *
     * @return Student
     */
    public function setIsHandicapped($isHandicapped = null)
    {
        $this->is_handicapped = $isHandicapped;

        return $this;
    }

    /**
     * Get isHandicapped.
     *
     * @return string|null
     */
    public function getIsHandicapped()
    {
        return $this->is_handicapped;
    }

    /**
     * Set disability.
     *
     * @param string|null $disability
     *
     * @return Student
     */
    public function setDisability($disability = null)
    {
        $this->disability = $disability;

        return $this;
    }

    /**
     * Get disability.
     *
     * @return string|null
     */
    public function getDisability()
    {
        return $this->disability;
    }

    /**
     * Set isEws.
     *
     * @param string|null $isEws
     *
     * @return Student
     */
    public function setIsEws($isEws = null)
    {
        $this->is_ews = $isEws;

        return $this;
    }

    /**
     * Get isEws.
     *
     * @return string|null
     */
    public function getIsEws()
    {
        return $this->is_ews;
    }

    /**
     * Set attendance.
     *
     * @param array|null $attendance
     *
     * @return Student
     */
    public function setAttendance($attendance = null)
    {
        $this->attendance = $attendance;

        return $this;
    }

    /**
     * Get attendance.
     *
     * @return array|null
     */
    public function getAttendance()
    {
        return $this->attendance;
    }

    /**
     * Set classData.
     *
     * @param array|null $classData
     *
     * @return Student
     */
    public function setClassData($classData = null)
    {
        $this->class_data = $classData;

        return $this;
    }

    /**
     * Get classData.
     *
     * @return array|null
     */
    public function getClassData()
    {
        return $this->class_data;
    }

    /**
     * Set presentAddress.
     *
     * @param array|null $presentAddress
     *
     * @return Student
     */
    public function setPresentAddress($presentAddress = null)
    {
        $this->present_address = $presentAddress;

        return $this;
    }

    /**
     * Get presentAddress.
     *
     * @return array|null
     */
    public function getPresentAddress()
    {
        return $this->present_address;
    }

    /**
     * Set permanentAddress.
     *
     * @param array|null $permanentAddress
     *
     * @return Student
     */
    public function setPermanentAddress($permanentAddress = null)
    {
        $this->permanent_address = $permanentAddress;

        return $this;
    }

    /**
     * Get permanentAddress.
     *
     * @return array|null
     */
    public function getPermanentAddress()
    {
        return $this->permanent_address;
    }

    /**
     * Set educationalDetails.
     *
     * @param array|null $educationalDetails
     *
     * @return Student
     */
    public function setEducationalDetails($educationalDetails = null)
    {
        $this->educational_details = $educationalDetails;

        return $this;
    }

    /**
     * Get educationalDetails.
     *
     * @return array|null
     */
    public function getEducationalDetails()
    {
        return $this->educational_details;
    }

    /**
     * Set lastExam.
     *
     * @param array|null $lastExam
     *
     * @return Student
     */
    public function setLastExam($lastExam = null)
    {
        $this->last_exam = $lastExam;

        return $this;
    }

    /**
     * Get lastExam.
     *
     * @return array|null
     */
    public function getLastExam()
    {
        return $this->last_exam;
    }

    /**
     * Set bestSubjects.
     *
     * @param array|null $bestSubjects
     *
     * @return Student
     */
    public function setBestSubjects($bestSubjects = null)
    {
        $this->best_subjects = $bestSubjects;

        return $this;
    }

    /**
     * Get bestSubjects.
     *
     * @return array|null
     */
    public function getBestSubjects()
    {
        return $this->best_subjects;
    }

    /**
     * Set achievements.
     *
     * @param array|null $achievements
     *
     * @return Student
     */
    public function setAchievements($achievements = null)
    {
        $this->achievements = $achievements;

        return $this;
    }

    /**
     * Get achievements.
     *
     * @return array|null
     */
    public function getAchievements()
    {
        return $this->achievements;
    }

    /**
     * Set dp.
     *
     * @param array|null $dp
     *
     * @return Student
     */
    public function setDp($dp = null)
    {
        $this->dp = $dp;

        return $this;
    }

    /**
     * Get dp.
     *
     * @return array|null
     */
    public function getDp()
    {
        return $this->dp;
    }

    /**
     * Set signature.
     *
     * @param array|null $signature
     *
     * @return Student
     */
    public function setSignature($signature = null)
    {
        $this->signature = $signature;

        return $this;
    }

    /**
     * Get signature.
     *
     * @return array|null
     */
    public function getSignature()
    {
        return $this->signature;
    }

    /**
     * Set isDel.
     *
     * @param int|null $isDel
     *
     * @return Student
     */
    public function setIsDel($isDel = null)
    {
        $this->is_del = $isDel;

        return $this;
    }

    /**
     * Get isDel.
     *
     * @return int|null
     */
    public function getIsDel()
    {
        return $this->is_del;
    }

    /**
     * Set subjects.
     *
     * @param array|null $subjects
     *
     * @return Student
     */
    public function setSubjects($subjects = null)
    {
        $this->subjects = $subjects;

        return $this;
    }

    /**
     * Get subjects.
     *
     * @return array|null
     */
    public function getSubjects()
    {
        return $this->subjects;
    }

    /**
     * Set boodGroup.
     *
     * @param string|null $boodGroup
     *
     * @return Student
     */
    public function setBoodGroup($boodGroup = null)
    {
        $this->bood_group = $boodGroup;

        return $this;
    }

    /**
     * Get boodGroup.
     *
     * @return string|null
     */
    public function getBoodGroup()
    {
        return $this->bood_group;
    }

    /**
     * Set localG.
     *
     * @param string|null $localG
     *
     * @return Student
     */
    public function setLocalG($localG = null)
    {
        $this->local_g = $localG;

        return $this;
    }

    /**
     * Get localG.
     *
     * @return string|null
     */
    public function getLocalG()
    {
        return $this->local_g;
    }

    /**
     * Set extraCurr.
     *
     * @param string|null $extraCurr
     *
     * @return Student
     */
    public function setExtraCurr($extraCurr = null)
    {
        $this->extra_curr = $extraCurr;

        return $this;
    }

    /**
     * Get extraCurr.
     *
     * @return string|null
     */
    public function getExtraCurr()
    {
        return $this->extra_curr;
    }

    /**
     * Set pOccupation.
     *
     * @param string|null $pOccupation
     *
     * @return Student
     */
    public function setPOccupation($pOccupation = null)
    {
        $this->p_occupation = $pOccupation;

        return $this;
    }

    /**
     * Get pOccupation.
     *
     * @return string|null
     */
    public function getPOccupation()
    {
        return $this->p_occupation;
    }

    /**
     * Set isFreeAdmission.
     *
     * @param int|null $isFreeAdmission
     *
     * @return Student
     */
    public function setIsFreeAdmission($isFreeAdmission = null)
    {
        $this->is_free_admission = $isFreeAdmission;

        return $this;
    }

    /**
     * Get isFreeAdmission.
     *
     * @return int|null
     */
    public function getIsFreeAdmission()
    {
        return $this->is_free_admission;
    }

    /**
     * Set isAlumni.
     *
     * @param int|null $isAlumni
     *
     * @return Student
     */
    public function setIsAlumni($isAlumni = null)
    {
        $this->is_alumni = $isAlumni;

        return $this;
    }

    /**
     * Get isAlumni.
     *
     * @return int|null
     */
    public function getIsAlumni()
    {
        return $this->is_alumni;
    }

    /**
     * Set hasPromoted.
     *
     * @param int|null $hasPromoted
     *
     * @return Student
     */
    public function setHasPromoted($hasPromoted = null)
    {
        $this->has_promoted = $hasPromoted;

        return $this;
    }

    /**
     * Get hasPromoted.
     *
     * @return int|null
     */
    public function getHasPromoted()
    {
        return $this->has_promoted;
    }

    /**
     * Set formId.
     *
     * @param string|null $formId
     *
     * @return Student
     */
    public function setFormId($formId = null)
    {
        $this->form_id = $formId;

        return $this;
    }

    /**
     * Get formId.
     *
     * @return string|null
     */
    public function getFormId()
    {
        return $this->form_id;
    }

    /**
     * Set shift.
     *
     * @param string|null $shift
     *
     * @return Student
     */
    public function setShift($shift = null)
    {
        $this->shift = $shift;

        return $this;
    }

    /**
     * Get shift.
     *
     * @return string|null
     */
    public function getShift()
    {
        return $this->shift;
    }

    /**
     * Set isNewlyAdmitted.
     *
     * @param int|null $isNewlyAdmitted
     *
     * @return Student
     */
    public function setIsNewlyAdmitted($isNewlyAdmitted = null)
    {
        $this->is_newly_admitted = $isNewlyAdmitted;

        return $this;
    }

    /**
     * Get isNewlyAdmitted.
     *
     * @return int|null
     */
    public function getIsNewlyAdmitted()
    {
        return $this->is_newly_admitted;
    }

    /**
     * Set admissionType.
     *
     * @param int|null $admissionType
     *
     * @return Student
     */
    public function setAdmissionType($admissionType = null)
    {
        $this->admission_type = $admissionType;

        return $this;
    }

    /**
     * Get admissionType.
     *
     * @return int|null
     */
    public function getAdmissionType()
    {
        return $this->admission_type;
    }

    /**
     * Set hostel.
     *
     * @param string|null $hostel
     *
     * @return Student
     */
    public function setHostel($hostel = null)
    {
        $this->hostel = $hostel;

        return $this;
    }

    /**
     * Get hostel.
     *
     * @return string|null
     */
    public function getHostel()
    {
        return $this->hostel;
    }

    /**
     * Set primaryEmail.
     *
     * @param string|null $primaryEmail
     *
     * @return Student
     */
    public function setPrimaryEmail($primaryEmail = null)
    {
        $this->primary_email = $primaryEmail;

        return $this;
    }

    /**
     * Get primaryEmail.
     *
     * @return string|null
     */
    public function getPrimaryEmail()
    {
        return $this->primary_email;
    }

    /**
     * Set maratialStatus.
     *
     * @param string|null $maratialStatus
     *
     * @return Student
     */
    public function setMaratialStatus($maratialStatus = null)
    {
        $this->maratial_status = $maratialStatus;

        return $this;
    }

    /**
     * Get maratialStatus.
     *
     * @return string|null
     */
    public function getMaratialStatus()
    {
        return $this->maratial_status;
    }

    /**
     * Set isPwd.
     *
     * @param string|null $isPwd
     *
     * @return Student
     */
    public function setIsPwd($isPwd = null)
    {
        $this->is_pwd = $isPwd;

        return $this;
    }

    /**
     * Get isPwd.
     *
     * @return string|null
     */
    public function getIsPwd()
    {
        return $this->is_pwd;
    }

    /**
     * Set bloodGroup.
     *
     * @param string|null $bloodGroup
     *
     * @return Student
     */
    public function setBloodGroup($bloodGroup = null)
    {
        $this->blood_group = $bloodGroup;

        return $this;
    }

    /**
     * Get bloodGroup.
     *
     * @return string|null
     */
    public function getBloodGroup()
    {
        return $this->blood_group;
    }

    /**
     * Set fatherName.
     *
     * @param string|null $fatherName
     *
     * @return Student
     */
    public function setFatherName($fatherName = null)
    {
        $this->father_name = $fatherName;

        return $this;
    }

    /**
     * Get fatherName.
     *
     * @return string|null
     */
    public function getFatherName()
    {
        return $this->father_name;
    }

    /**
     * Set fatherPhone.
     *
     * @param string|null $fatherPhone
     *
     * @return Student
     */
    public function setFatherPhone($fatherPhone = null)
    {
        $this->father_phone = $fatherPhone;

        return $this;
    }

    /**
     * Get fatherPhone.
     *
     * @return string|null
     */
    public function getFatherPhone()
    {
        return $this->father_phone;
    }

    /**
     * Set fatherEmail.
     *
     * @param string|null $fatherEmail
     *
     * @return Student
     */
    public function setFatherEmail($fatherEmail = null)
    {
        $this->father_email = $fatherEmail;

        return $this;
    }

    /**
     * Get fatherEmail.
     *
     * @return string|null
     */
    public function getFatherEmail()
    {
        return $this->father_email;
    }

    /**
     * Set fatherQualification.
     *
     * @param string|null $fatherQualification
     *
     * @return Student
     */
    public function setFatherQualification($fatherQualification = null)
    {
        $this->father_qualification = $fatherQualification;

        return $this;
    }

    /**
     * Get fatherQualification.
     *
     * @return string|null
     */
    public function getFatherQualification()
    {
        return $this->father_qualification;
    }

    /**
     * Set fatherProfession.
     *
     * @param string|null $fatherProfession
     *
     * @return Student
     */
    public function setFatherProfession($fatherProfession = null)
    {
        $this->father_profession = $fatherProfession;

        return $this;
    }

    /**
     * Get fatherProfession.
     *
     * @return string|null
     */
    public function getFatherProfession()
    {
        return $this->father_profession;
    }

    /**
     * Set motherName.
     *
     * @param string|null $motherName
     *
     * @return Student
     */
    public function setMotherName($motherName = null)
    {
        $this->mother_name = $motherName;

        return $this;
    }

    /**
     * Get motherName.
     *
     * @return string|null
     */
    public function getMotherName()
    {
        return $this->mother_name;
    }

    /**
     * Set motherPhone.
     *
     * @param string|null $motherPhone
     *
     * @return Student
     */
    public function setMotherPhone($motherPhone = null)
    {
        $this->mother_phone = $motherPhone;

        return $this;
    }

    /**
     * Get motherPhone.
     *
     * @return string|null
     */
    public function getMotherPhone()
    {
        return $this->mother_phone;
    }

    /**
     * Set motherQualification.
     *
     * @param string|null $motherQualification
     *
     * @return Student
     */
    public function setMotherQualification($motherQualification = null)
    {
        $this->mother_qualification = $motherQualification;

        return $this;
    }

    /**
     * Get motherQualification.
     *
     * @return string|null
     */
    public function getMotherQualification()
    {
        return $this->mother_qualification;
    }

    /**
     * Set motherProfession.
     *
     * @param string|null $motherProfession
     *
     * @return Student
     */
    public function setMotherProfession($motherProfession = null)
    {
        $this->mother_profession = $motherProfession;

        return $this;
    }

    /**
     * Get motherProfession.
     *
     * @return string|null
     */
    public function getMotherProfession()
    {
        return $this->mother_profession;
    }

    /**
     * Set annualIncome.
     *
     * @param string|null $annualIncome
     *
     * @return Student
     */
    public function setAnnualIncome($annualIncome = null)
    {
        $this->annual_income = $annualIncome;

        return $this;
    }

    /**
     * Get annualIncome.
     *
     * @return string|null
     */
    public function getAnnualIncome()
    {
        return $this->annual_income;
    }

    /**
     * Set localAddress.
     *
     * @param array|null $localAddress
     *
     * @return Student
     */
    public function setLocalAddress($localAddress = null)
    {
        $this->local_address = $localAddress;

        return $this;
    }

    /**
     * Get localAddress.
     *
     * @return array|null
     */
    public function getLocalAddress()
    {
        return $this->local_address;
    }

    /**
     * Set activities.
     *
     * @param array|null $activities
     *
     * @return Student
     */
    public function setActivities($activities = null)
    {
        $this->activities = $activities;

        return $this;
    }

    /**
     * Get activities.
     *
     * @return array|null
     */
    public function getActivities()
    {
        return $this->activities;
    }

    /**
     * Set accountHolder.
     *
     * @param string|null $accountHolder
     *
     * @return Student
     */
    public function setAccountHolder($accountHolder = null)
    {
        $this->account_holder = $accountHolder;

        return $this;
    }

    /**
     * Get accountHolder.
     *
     * @return string|null
     */
    public function getAccountHolder()
    {
        return $this->account_holder;
    }

    /**
     * Set accountNo.
     *
     * @param string|null $accountNo
     *
     * @return Student
     */
    public function setAccountNo($accountNo = null)
    {
        $this->account_no = $accountNo;

        return $this;
    }

    /**
     * Get accountNo.
     *
     * @return string|null
     */
    public function getAccountNo()
    {
        return $this->account_no;
    }

    /**
     * Set accountBank.
     *
     * @param string|null $accountBank
     *
     * @return Student
     */
    public function setAccountBank($accountBank = null)
    {
        $this->account_bank = $accountBank;

        return $this;
    }

    /**
     * Get accountBank.
     *
     * @return string|null
     */
    public function getAccountBank()
    {
        return $this->account_bank;
    }

    /**
     * Set accountBranch.
     *
     * @param string|null $accountBranch
     *
     * @return Student
     */
    public function setAccountBranch($accountBranch = null)
    {
        $this->account_branch = $accountBranch;

        return $this;
    }

    /**
     * Get accountBranch.
     *
     * @return string|null
     */
    public function getAccountBranch()
    {
        return $this->account_branch;
    }

    /**
     * Set accountIfsc.
     *
     * @param string|null $accountIfsc
     *
     * @return Student
     */
    public function setAccountIfsc($accountIfsc = null)
    {
        $this->account_ifsc = $accountIfsc;

        return $this;
    }

    /**
     * Get accountIfsc.
     *
     * @return string|null
     */
    public function getAccountIfsc()
    {
        return $this->account_ifsc;
    }

    /**
     * Set accountMicr.
     *
     * @param string|null $accountMicr
     *
     * @return Student
     */
    public function setAccountMicr($accountMicr = null)
    {
        $this->account_micr = $accountMicr;

        return $this;
    }

    /**
     * Get accountMicr.
     *
     * @return string|null
     */
    public function getAccountMicr()
    {
        return $this->account_micr;
    }

    /**
     * Set samarthRollNo.
     *
     * @param string|null $samarthRollNo
     *
     * @return Student
     */
    public function setSamarthRollNo($samarthRollNo = null)
    {
        $this->samarth_roll_no = $samarthRollNo;

        return $this;
    }

    /**
     * Get samarthRollNo.
     *
     * @return string|null
     */
    public function getSamarthRollNo()
    {
        return $this->samarth_roll_no;
    }
}
