<?php

use Doctrine\ORM\EntityRepository;

class StudentRepository extends EntityRepository
{


    public function getStudentByEmail($email)
    {
        $dql = "SELECT r.id,r.course,r.stream,r.dept_code,r.semester,r.phone,r.course_type,r.email,r.name,r.subjects,r.roll_no,r.university_roll_no from Student r where r.email=:email";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('email', $email);
        $result = $query->getResult();
        if (sizeof($result) > 0) {
            return $result[0];
        } else {
            return false;
        }
    }



    private function getStudentForEdit($id)
    {
        $dql = "SELECT r from Student r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('id', $id);
        return $query->getResult();
    }


    public function findStudentWithEmail($email)
    {
        $dql = "SELECT r.id, r.name,r.father_name,r.roll_no,r.email,r.primary_email,r.course,r.semester,r.profile_updated,r.registration_no,r.samarth_roll_no,r.university_roll_no from Student r where r.primary_email=:email";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('email', $email);
        $results = $query->getResult();

        $index = 0;
        foreach ($results as $result) {
            // get the subjects also
            $subjects = $this->getEntityManager()->getRepository('StudentSubjects')->getStudentSubject($result['id'], $result['semester']);
            $results[$index]['subjects'] = $subjects;
            $index++;
        }



        return $results;
    }


    public function getSmallUploadedDetails($body)
    {
        $em = $this->getEntityManager();
        $student_id = addslashes(strip_tags(trim($body['student_id'])));

        $Student = $em->getRepository('Student')->find($student_id);

        $data = [];
        $data['profile_updated'] = $Student->getProfileUpdated();

        $b = [];
        $b['status'] = true;
        $b['status_text'] = 'Successfully Updated';
        $b['data'] = $data;
        return $b;
    }


    public function getDetailsById($student_id)
    {
        $dql = "SELECT r.id,r.course,r.dept_code,r.semester,r.course_type,r.email,r.name,r.phone,r.email,r.roll_no,r.university_roll_no,r.registration_no,r.present_address,r.permanent_address,r.religion,r.gender,r.caste,r.is_handicapped,r.is_ews,r.account_holder,r.account_no,r.educational_details,r.father_name,r.mother_name from Student r where r.id=:student_id";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('student_id', $student_id);
        $result = $query->getResult();
        if (sizeof($result) > 0) {

            // fetch subjects of this semester
            $result[0]['subjects'] = $this->getEntityManager()->getRepository('StudentSubjects')->getStudentSubject($student_id, $result[0]['semester']);
            return $result[0];
        } else {
            return false;
        }
    }

    public function getStudentSubjectsOnly($student_id)
    {
        $dql = "SELECT r.id,r.course,r.dept_code,r.semester,r.course_type,r.email,r.name,r.phone,r.email,r.roll_no,r.university_roll_no,r.registration_no,r.present_address,r.permanent_address,r.religion,r.gender,r.caste,r.is_handicapped,r.is_ews,r.account_holder,r.account_no,r.bank,r.bank_branch,r.bank_ifsc,r.educational_details,r.father_name,r.mother_name from Student r where r.id=:student_id";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('student_id', $student_id);
        $result = $query->getResult();
        if (sizeof($result) > 0) {

            // fetch subjects of this semester
            return $this->getEntityManager()->getRepository('StudentSubjects')->getStudentSubject($student_id, $result[0]['semester']);
        } else {
            return false;
        }
    }



    public function getStudentPhoneNumber($email)
    {
        $dql = "SELECT r from Student r where r.email=:email";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('email', $email);
        $result = $query->getResult();
        return $result[0]->getPhone();
    }

    public function getStudentSingle($id)
    {
        $dql = "SELECT r.id,r.class_id,r.course,r.course_type,r.stream,r.dept_code,r.semester,r.session_id,r.name,r.father_name,r.mother_name,r.phone,r.email,r.gender,r.caste,r.date_of_birth,r.present_address,r.permanent_address,r.year_of_admission,r.roll_no,r.registration_no,r.quota,r.state,r.attendance,r.class_data,r.educational_details,r.achievements,r.dp,r.signature,r.is_del From Student r where r.id =:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $result = $query->getResult();
        $index = 0;
        foreach ($result as $r) {
            $result[$index]['subjects'] = $this->getEntityManager()->getRepository('StudentSubjects')->getStudentSubject($r['id'], $r['semester']);
            $index++;
        }
        return $result;
    }

    public function getStudentProfilePercent($email)
    {
        $data = $this->getStudentProfileSingle($email);
        $count = 0;
        $total_count = -1;
        $data_filtered = $data[0]; //10/35

        foreach ($data_filtered as $key => $value) {
            if ($value == '' || $value == null) {
                $count++;
            }
            $total_count++;
        }

        $percentage = (($total_count - $count) / $total_count) * 100;

        return round($percentage);
    }





    public function updateStudent($id, $body)
    {
        $entityManager = $this->getEntityManager();
        $course_type = addslashes(strip_tags(trim($body['course_type'])));
        $course = addslashes(strip_tags(trim($body['course'])));
        $stream = addslashes(strip_tags(trim($body['stream'])));
        $dept_code = addslashes(strip_tags(trim($body['dept_code'])));
        $semester = addslashes(strip_tags(trim($body['term'])));
        $class_id = addslashes(strip_tags(trim($body['class_id'])));
        $session_id = addslashes(strip_tags(trim($body['session_id'])));
        $name = addslashes(strip_tags(trim($body['name'])));
        $father_name = addslashes(strip_tags(trim($body['father_name'])));
        $mother_name = addslashes(strip_tags(trim($body['mother_name'])));
        $contact = addslashes(strip_tags(trim($body['phone'])));
        $email = addslashes(strip_tags(trim($body['email'])));
        $gender = addslashes(strip_tags(trim($body['gender'])));
        $caste = addslashes(strip_tags(trim($body['caste'])));
        $date_of_birth = addslashes(strip_tags(trim($body['date_of_birth'])));
        $present_address = $body['present_address'];
        $permanent_address = $body['permanent_address'];
        $year_of_admission = $body['year_of_admission'];
        $roll_no = addslashes(strip_tags(trim($body['roll_no'])));
        $registration_no = addslashes(strip_tags(trim($body['registration_no'])));
        //$quota = addslashes(strip_tags(trim($body['quota'])));
        $state = addslashes(strip_tags(trim($body['state'])));
        $religion = addslashes(strip_tags(trim($body['religion'])));
        $nationality = addslashes(strip_tags(trim($body['nationality'])));
        $is_handicapped = addslashes(strip_tags(trim($body['is_handicapped'])));
        $disability = addslashes(strip_tags(trim($body['disability'])));
        $attendance = $body['attendance'];
        $class_data = $body['class_data'];
        $achievements = $body['achievements'];
        $educational_details = $body['educational_details'];
        $dp = $body['dp'];
        $signature = $body['signature'];
        $subjects = $body['subjects'];
        $result = $this->getStudentForEdit($id);
        if (sizeof($result) == 1) {

            $result[0]->setCourseType($course_type);
            $result[0]->setCourse($course);
            $result[0]->setStream($stream);
            $result[0]->setDeptCode($dept_code);
            $result[0]->setSemester($semester);
            $result[0]->setClassId($class_id);
            $result[0]->setSessionId($session_id);
            $result[0]->setName($name);
            $result[0]->setFatherName($father_name);
            $result[0]->setMotherName($mother_name);
            $result[0]->setGender($gender);
            $result[0]->setCaste($caste);
            $result[0]->setPhone($contact);
            $result[0]->setDateOfBirth($date_of_birth);
            $result[0]->setPresentAddress($present_address);
            $result[0]->setPermanentAddress($permanent_address);
            $result[0]->setYearOfAdmission($year_of_admission);
            $result[0]->setRollNo($roll_no);
            $result[0]->setRegistrationNo($registration_no);
            $result[0]->setQuota("");
            $result[0]->setState($state);
            $result[0]->setIsHandicapped($is_handicapped);
            $result[0]->setDisability($disability);
            $result[0]->setReligion($religion);
            $result[0]->setNationality($nationality);
            $result[0]->setAttendance($attendance);
            $result[0]->setClassData($class_data);
            $result[0]->setAchievements($achievements);
            $result[0]->setEducationalDetails($educational_details);
            $result[0]->setDp($dp);
            $result[0]->setSignature($signature);

            $result[0]->setIsDel(0);
            $entityManager->persist($result[0]);
            $entityManager->flush();
            if (null != $result[0]->getId()) {
                $student_id = $result[0]->getId();
                $entityManager->getRepository('StudentSubjects')->addStudentSubject($student_id, $semester, $subjects);
                return "Updated Successfully. You have to refresh this page to see changes";
            } else {
                return "Cannot update subject";
            }
        } else {
            return "Not found.";
        }
    }



    public function getStudentByRollNo($id)
    {
        $dql = "SELECT r.id,r.course,r.course_type,r.stream,r.dept_code,r.semester,r.session_id,r.name,r.date_of_birth,r.father_name,r.mother_name,r.phone,r.email,r.present_address,r.permanent_address,r.roll_no,r.dp,r.signature From Student r where r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $result = $query->getResult();
        return $result;
    }

    public function getStudentByIdNew($id)
    {
        $dql = "SELECT r.id,r.course,r.course_type,r.stream,r.dept_code,r.semester,r.session_id,r.name,r.father_name,r.mother_name,r.phone,r.email,r.present_address,r.permanent_address,r.roll_no,r.dp,r.signature,s.subjects From Student r, StudentSubjects s where r.id=:id AND r.semester=s.semester AND r.id=s.student_id";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $id);
        $result = $query->getResult();
        if (sizeof($result) > 0) {
            return $result[0];
        } else {
            return false;
        }
    }


    public function getStudentByIdAndSemesterForTest($id, $semester)
    {
        $dql = "SELECT r.id,r.course,r.course_type,r.dept_code,r.semester,r.name,r.phone,r.email,r.roll_no,r.university_roll_no,s.subjects From Student r, StudentSubjects s where r.id=s.student_id AND s.semester=:semester AND r.id=:id";
        $query = $this->getEntityManager()->createQuery($dql)
            ->setParameter('id', $id)
            ->setParameter('semester', $semester);
        $result = $query->getResult();
        return $result;
    }


    public function promoteStudent($body)
    {
        $entityManager = $this->getEntityManager();
        $semester_id = addslashes(strip_tags(trim($body['semester_id'])));
        $rolls = $body['roll_nos'];
        if (is_array($rolls) && sizeof($rolls) > 0) {
            for ($i = 0; $i < sizeof($rolls); $i++) {
                $dql = 'SELECT r FROM Student r WHERE r.id=:id';
                $query = $this->getEntityManager()->createQuery($dql)->setParameter('id', $rolls[$i]);
                $result = $query->getResult();
                $result[0]->setCurrentSemester($semester_id);
                $entityManager->persist($result[0]);
                $entityManager->flush();
            }
            return 'Student promoted successfully.';
        } else {
            return 'No record found';
        }
    }



    public function getStudentAttendaceReportsStudent($body)
    {
        $em = $this->getEntityManager();
        $start_date = addslashes(strip_tags(trim($body['start_date'])));
        $end_date = addslashes(strip_tags(trim($body['end_date'])));

        $id = addslashes(strip_tags(trim($body['id'])));

        $sql = "SELECT r.id,r.semester,r.name,r.roll_no,r.email,r.phone,r.course,r.stream,r.course_type,r.semester, s.subjects FROM student r LEFT JOIN student_subjects s ON r.id=s.student_id AND r.semester=s.semester WHERE r.id=:id";
        $stmt = $em->getConnection()->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $result = $stmt->fetchAll();

        if (sizeof($result) > 0) {
            $b = array();
            $subjects = json_decode($result[0]['subjects'], true);
            foreach ($subjects as $subject) {
                $a = [];
                $a['sub_code'] = $subject['label'] . ' ' . $subject['sub_code'];
                $a['sub_name'] = $subject['label'];
                $a['attendance'] = $this->getEntityManager()->getRepository('Attendance')->fetchReportByDateSingle($start_date, $end_date, $body, $subject['sub_code']);
                array_push($b, $a);
                $a = [];
            }

            $result[0]['attendance_data'] = $b;
        }

        return $result;
    }






    public function getStudentAttendaceReportsStudentByDate($body, $current_session)
    {
        $em = $this->getEntityManager();
        $id = addslashes(strip_tags(trim($body['id'])));


        $sql = "SELECT r.id,r.semester,r.name,r.roll_no,r.email,r.phone,r.course,r.course_type,r.semester,s.subjects FROM student r LEFT JOIN student_subjects s ON r.id=s.student_id AND r.semester=s.semester WHERE r.id=:id";
        $stmt = $em->getConnection()->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_STR);
        $stmt->execute();
        $result = $stmt->fetchAll();

        if (sizeof($result) > 0) {
            $b = array();
            $subjects = json_decode($result[0]['subjects'], true);
            foreach ($subjects as $subject) {
                $a = [];
                $a['sub_code'] = $subject['value'];
                $a['sub_name'] = $subject['label'];
                $a['attendance'] = $this->getEntityManager()->getRepository('Attendance')->fetchReportByDateSingleByDate($current_session, $body, $subject['value']);
                array_push($b, $a);


                $a = [];
            }

            $result[0]['attendance_data'] = $b;
        }

        return $result;
    }


    public function updateSmallProfilePhoto($body)
    {
        $em = $this->getEntityManager();
        $student_id = addslashes(strip_tags(trim($body['student_id'])));

        $dp = $body['dp'];
        $signature = $body['signature'];

        $Student = $em->getRepository('Student')->find($student_id);

        $Student->setDp($dp);
        $Student->setSignature($signature);
        $em->persist($Student);
        $em->flush();
        $b = [];
        $b['status'] = true;
        $b['status_text'] = 'Successfully Updated';
        return $b;
    }

    public function getSmallUploadedPhoto($body)
    {
        $em = $this->getEntityManager();
        $student_id = addslashes(strip_tags(trim($body['student_id'])));

        $Student = $em->getRepository('Student')->find($student_id);

        $data = [];
        $data['dp'] = $Student->getDp();
        $data['signature'] = $Student->getSignature();

        $b = [];
        $b['status'] = true;
        $b['status_text'] = 'Successfully Updated';
        $b['data'] = $data;
        return $b;
    }


    public function updateSmallSubject($body)
    {
        $em = $this->getEntityManager();
        $student_id = addslashes(strip_tags(trim($body['student_id'])));

        $compulsory_1 = addslashes(strip_tags(trim($body['compulsory_1'])));
        $compulsory_2 = addslashes(strip_tags(trim($body['compulsory_2'])));
        $compulsory_3 = addslashes(strip_tags(trim($body['compulsory_3'])));
        $major_1 = addslashes(strip_tags(trim($body['major_1'])));
        $major_2 = addslashes(strip_tags(trim($body['major_2'])));
        $major_3 = addslashes(strip_tags(trim($body['major_3'])));
        $generic_1_1 = addslashes(strip_tags(trim($body['generic_1_1'])));
        $generic_1_2 = addslashes(strip_tags(trim($body['generic_1_2'])));
        $generic_1_3 = addslashes(strip_tags(trim($body['generic_1_3'])));
        $mdc_1 = addslashes(strip_tags(trim($body['mdc_1'])));
        $vac = addslashes(strip_tags(trim($body['vac'])));
        $mil = addslashes(strip_tags(trim($body['mil'])));
        $sec = addslashes(strip_tags(trim($body['sec'])));
        $samarth_roll_no = addslashes(strip_tags(trim($body['samarth_roll_no'])));

        $roll_no = "";
        if (array_key_exists('roll_no', $body)) {
            $roll_no = addslashes(strip_tags(trim($body['roll_no'])));
        }

        $university_roll_no = "";
        if (array_key_exists('university_roll_no', $body)) {
            $university_roll_no = addslashes(strip_tags(trim($body['university_roll_no'])));
        }


        $Student = $em->getRepository('Student')->find($student_id);

        // arrange the subjects

        $course = $Student->getCourse();
        $semester = $Student->getSemester();


        if ($course == "BA" || $course == "BSC") {

            //$as1 = $em->getRepository('StudentSubjects')->getStudentSubject($Student->getId(), $Student->getSemester());


            $allSubjects = [];
            $smSub = [];
            foreach ($allSubjects as $as) {
                array_push($smSub, $as['sub_code']);
            }

            if ($semester == 1 || $semester == 2) {
                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_1 != '' && !in_array($generic_1_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                // if ($semester == 1) {

                //     if ($generic_1_2 != '' && !in_array($generic_1_2, $smSub)) {
                //         // insert

                //         $ss1 = $em
                //             ->getRepository('SubjectMaster')
                //             ->getSubjectSingle($generic_1_2);
                //         if (sizeof($ss1) > 0) {
                //             $ss1[0]['type'] = 'generic_1_2';
                //             $ss1[0]['label'] = $ss1[0]['sub_name'];
                //             $ss1[0]['value'] = $ss1[0]['sub_code'];
                //             $allSubjects = array_merge($allSubjects, $ss1);
                //         }
                //     }
                
                  

                //         if ($generic_1_3 != '' && !in_array($generic_1_3, $smSub)) {
                //             // insert

                //                 $ss1 = $em
                //                     ->getRepository('SubjectMaster')
                //                     ->getSubjectSingle($generic_1_3);
                //                 if (sizeof($ss1) > 0) {
                //                     $ss1[0]['type'] = 'generic_1_3';
                //                     $ss1[0]['label'] = $ss1[0]['sub_name'];
                //                     $ss1[0]['value'] = $ss1[0]['sub_code'];
                //                     $allSubjects = array_merge($allSubjects, $ss1);
                //                 }
                //             }
                // }

                if ($mdc_1 != '' && !in_array($mdc_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mdc_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mdc_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($vac != '' && !in_array($vac, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($vac);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'vac';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                if ($sec != '' && !in_array($sec, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($sec);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'sec';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($mil != '' && !in_array($mil, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mil);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mil';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }
            }


            if ($semester == 3 || $semester == 4) {
                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_1 != '' && !in_array($generic_1_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                // if ($generic_1_2 != '' && !in_array($generic_1_2, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($generic_1_2);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'generic_1_2';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }


                // if ($generic_1_3 != '' && !in_array($generic_1_3, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($generic_1_3);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'generic_1_3';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }


                if ($mdc_1 != '' && !in_array($mdc_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mdc_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mdc_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                // if ($vac != '' && !in_array($vac, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($vac);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'vac';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }

                if ($sec != '' && !in_array($sec, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($sec);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'sec';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                if ($semester == 4) {
                    if ($mil != '' && !in_array($mil, $smSub)) {
                        // insert

                        $ss1 = $em
                            ->getRepository('SubjectMaster')
                            ->getSubjectSingle($mil);
                        if (sizeof($ss1) > 0) {
                            $ss1[0]['type'] = 'mil';
                            $ss1[0]['label'] = $ss1[0]['sub_name'];
                            $ss1[0]['value'] = $ss1[0]['sub_code'];
                            $allSubjects = array_merge($allSubjects, $ss1);
                        }
                    }
                }
            }



            if ($semester == 5 || $semester == 6) {
                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                // if ($generic_1_1 != '' && !in_array($generic_1_1, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($generic_1_1);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'generic_1_1';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }
            }














            $em->getRepository('StudentSubjects')->addStudentSubject($Student->getId(), $Student->getSemester(), $allSubjects);
        }


        if ($course == "BCOM") {

            //$as1 = $em->getRepository('StudentSubjects')->getStudentSubject($Student->getId(), $Student->getSemester());


            $allSubjects = [];
            $smSub = [];
            foreach ($allSubjects as $as) {
                array_push($smSub, $as['sub_code']);
            }

            if ($semester == 1 || $semester == 2) {
                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_1 != '' && !in_array($generic_1_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_2 != '' && !in_array($generic_1_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                // if ($generic_1_3 != '' && !in_array($generic_1_3, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($generic_1_3);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'generic_1_3';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }


                if ($mdc_1 != '' && !in_array($mdc_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mdc_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mdc_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($vac != '' && !in_array($vac, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($vac);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'vac';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                if ($sec != '' && !in_array($sec, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($sec);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'sec';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($mil != '' && !in_array($mil, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mil);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mil';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }
            }


            if ($semester == 3) {
                if ($compulsory_1 != '' && !in_array($compulsory_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($compulsory_2 != '' && !in_array($compulsory_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                // if ($compulsory_3 != '' && !in_array($compulsory_3, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($compulsory_3);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'compulsory_3';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }


                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                // if ($major_2 != '' && !in_array($major_2, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($major_2);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'major_2';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }


                if ($mdc_1 != '' && !in_array($mdc_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mdc_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mdc_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }




                if ($sec != '' && !in_array($sec, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($sec);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'sec';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }
            }


            if ($semester == 4) {
                if ($compulsory_1 != '' && !in_array($compulsory_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($compulsory_2 != '' && !in_array($compulsory_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                if ($compulsory_3 != '' && !in_array($compulsory_3, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_3);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_3';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_1 != '' && !in_array($generic_1_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                if ($generic_1_2 != '' && !in_array($generic_1_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                // if ($major_2 != '' && !in_array($major_2, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($major_2);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'major_2';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }







                if ($vac != '' && !in_array($vac, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($vac);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'vac';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }
            }



            if ($semester == 5 || $semester == 6) {
                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                
                if ($compulsory_1 != '' && !in_array($compulsory_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($compulsory_2 != '' && !in_array($compulsory_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_1 != '' && !in_array($generic_1_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                if ($generic_1_2 != '' && !in_array($generic_1_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }
            }














            $em->getRepository('StudentSubjects')->addStudentSubject($Student->getId(), $Student->getSemester(), $allSubjects);
        }


        if ($course == "BCA") {

            //$as1 = $em->getRepository('StudentSubjects')->getStudentSubject($Student->getId(), $Student->getSemester());


            $allSubjects = [];
            $smSub = [];
            foreach ($allSubjects as $as) {
                array_push($smSub, $as['sub_code']);
            }

            if ($semester == 1 || $semester == 2) {
                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_1 != '' && !in_array($generic_1_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_2 != '' && !in_array($generic_1_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_3 != '' && !in_array($generic_1_3, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_3);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_3';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($mdc_1 != '' && !in_array($mdc_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mdc_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mdc_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($vac != '' && !in_array($vac, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($vac);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'vac';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                if ($sec != '' && !in_array($sec, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($sec);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'sec';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($mil != '' && !in_array($mil, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mil);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mil';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }
            }


            if ($semester == 3) {
                if ($compulsory_1 != '' && !in_array($compulsory_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($compulsory_2 != '' && !in_array($compulsory_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                // if ($compulsory_3 != '' && !in_array($compulsory_3, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($compulsory_3);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'compulsory_3';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }


                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                // if ($major_2 != '' && !in_array($major_2, $smSub)) {
                //     // insert

                //     $ss1 = $em
                //         ->getRepository('SubjectMaster')
                //         ->getSubjectSingle($major_2);
                //     if (sizeof($ss1) > 0) {
                //         $ss1[0]['type'] = 'major_2';
                //         $ss1[0]['label'] = $ss1[0]['sub_name'];
                //         $ss1[0]['value'] = $ss1[0]['sub_code'];
                //         $allSubjects = array_merge($allSubjects, $ss1);
                //     }
                // }


                if ($mdc_1 != '' && !in_array($mdc_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mdc_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mdc_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }




                if ($sec != '' && !in_array($sec, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($sec);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'sec';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }
            }


            if ($semester == 4) {





                if ($major_1 != '' && !in_array($major_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($major_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'major_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_1 != '' && !in_array($generic_1_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                if ($generic_1_2 != '' && !in_array($generic_1_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_3 != '' && !in_array($generic_1_3, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_3);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_3';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($mdc_1 != '' && !in_array($mdc_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mdc_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mdc_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }




                if ($mil != '' && !in_array($mil, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($mil);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'mil';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }
            }



            if ($semester == 5 || $semester == 6) {
                if ($compulsory_1 != '' && !in_array($compulsory_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($compulsory_2 != '' && !in_array($compulsory_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($compulsory_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'compulsory_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }


                if ($generic_1_1 != '' && !in_array($generic_1_1, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_1);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_1';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }

                if ($generic_1_2 != '' && !in_array($generic_1_2, $smSub)) {
                    // insert

                    $ss1 = $em
                        ->getRepository('SubjectMaster')
                        ->getSubjectSingle($generic_1_2);
                    if (sizeof($ss1) > 0) {
                        $ss1[0]['type'] = 'generic_1_2';
                        $ss1[0]['label'] = $ss1[0]['sub_name'];
                        $ss1[0]['value'] = $ss1[0]['sub_code'];
                        $allSubjects = array_merge($allSubjects, $ss1);
                    }
                }
            }














            $em->getRepository('StudentSubjects')->addStudentSubject($Student->getId(), $Student->getSemester(), $allSubjects);
        }
        //$Student->setSubjects($allSubjects);
        //$Student->setProfileUpdated(1);
        if (array_key_exists('roll_no', $body)) {
            $Student->setRollNo($roll_no);
        }
        if (array_key_exists('samarth_roll_no', $body)) {
            $Student->setRegistrationNo($samarth_roll_no);
        }

        if (array_key_exists('university_roll_no', $body)) {
            $Student->setUniversityRollNo($university_roll_no);
        }



        $em->persist($Student);
        $em->flush();
        $b = [];
        $b['status'] = true;
        $b['status_text'] = 'Successfully Updated';
        return $b;
    }



    public function getStudentProfileSingle($email)
    {
        $dql = "SELECT r.id,r.class_id,r.course_type,r.course,r.stream,r.dept_code,r.semester,r.session_id,r.name,r.father_name,r.mother_name,r.phone,r.email,r.gender,r.caste,r.date_of_birth,r.present_address,r.permanent_address,r.year_of_admission,r.roll_no,r.registration_no,r.quota,r.state,r.attendance,r.class_data,r.educational_details,r.achievements,r.dp,r.signature,r.is_del,r.subjects,r.religion,r.nationality,r.primary_email,r.extra_curr,r.is_pwd,r.is_ews,r.maratial_status,r.blood_group,r.father_phone,r.father_email,r.father_qualification,r.father_profession,r.mother_phone,r.mother_qualification,r.mother_profession,r.annual_income,r.local_g,r.local_address,r.activities,r.account_holder,r.account_no,r.account_bank,r.account_branch,r.account_ifsc,r.account_micr From Student r where r.email =:email";
        $query = $this->getEntityManager()->createQuery($dql)->setParameter('email', $email);
        $result = $query->getResult();

        if (sizeof($result) > 0) {
            // fetch subjects of this semester
            $result[0]['subjects'] = $this->getEntityManager()->getRepository('StudentSubjects')->getStudentSubject($result[0]['id'], $result[0]['semester']);
        }

        return $result;
    }
}
