<?php

/**
 * @Entity(repositoryClass="StudentSubjectsRepository") @Table(name="student_subjects")
 */

class StudentSubjects
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="integer",length=11)
     */
    protected $student_id;

    /**
     * @Column(type="integer",length=11)
     */
    protected $semester;

    /**
     * @Column(type="json_array", nullable=true)
     */
    protected $subjects;

   

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set studentId.
     *
     * @param int $studentId
     *
     * @return StudentSubjects
     */
    public function setStudentId($studentId)
    {
        $this->student_id = $studentId;

        return $this;
    }

    /**
     * Get studentId.
     *
     * @return int
     */
    public function getStudentId()
    {
        return $this->student_id;
    }

    /**
     * Set semester.
     *
     * @param int $semester
     *
     * @return StudentSubjects
     */
    public function setSemester($semester)
    {
        $this->semester = $semester;

        return $this;
    }

    /**
     * Get semester.
     *
     * @return int
     */
    public function getSemester()
    {
        return $this->semester;
    }

    /**
     * Set subjects.
     *
     * @param array|null $subjects
     *
     * @return StudentSubjects
     */
    public function setSubjects($subjects = null)
    {
        $this->subjects = $subjects;

        return $this;
    }

    /**
     * Get subjects.
     *
     * @return array|null
     */
    public function getSubjects()
    {
        return $this->subjects;
    }
}
