<?php

/**
 * @Entity(repositoryClass="SubjectMasterRepository") @Table(name="subject_master")
 */

class SubjectMaster
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="string",length=50)
     */
    protected $sub_code;

    /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $sub_type;

    /**
     * @Column(type="string",length=50,nullable=true)
     */
    protected $dept_code;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $sub_name;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $course;


    

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set subCode.
     *
     * @param string $subCode
     *
     * @return SubjectMaster
     */
    public function setSubCode($subCode)
    {
        $this->sub_code = $subCode;

        return $this;
    }

    /**
     * Get subCode.
     *
     * @return string
     */
    public function getSubCode()
    {
        return $this->sub_code;
    }

    /**
     * Set subType.
     *
     * @param string|null $subType
     *
     * @return SubjectMaster
     */
    public function setSubType($subType = null)
    {
        $this->sub_type = $subType;

        return $this;
    }

    /**
     * Get subType.
     *
     * @return string|null
     */
    public function getSubType()
    {
        return $this->sub_type;
    }

    /**
     * Set deptCode.
     *
     * @param string|null $deptCode
     *
     * @return SubjectMaster
     */
    public function setDeptCode($deptCode = null)
    {
        $this->dept_code = $deptCode;

        return $this;
    }

    /**
     * Get deptCode.
     *
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->dept_code;
    }

    /**
     * Set subName.
     *
     * @param string|null $subName
     *
     * @return SubjectMaster
     */
    public function setSubName($subName = null)
    {
        $this->sub_name = $subName;

        return $this;
    }

    /**
     * Get subName.
     *
     * @return string|null
     */
    public function getSubName()
    {
        return $this->sub_name;
    }

    /**
     * Set course.
     *
     * @param string|null $course
     *
     * @return SubjectMaster
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course.
     *
     * @return string|null
     */
    public function getCourse()
    {
        return $this->course;
    }
}
