<?php

/**
 * @Entity(repositoryClass="ViewedNotiByStRepository") @Table(name="viewed_noti_by_st")
 */

class ViewedNotiBySt
{
    /**
     * @Id @GeneratedValue @Column(type="integer")
     */
    protected $id;

    /**
     * @Column(type="integer")
     */
    protected $noti_id;

    /**
     * @Column(type="string",length=100, nullable=true)
     */
    protected $by_username;

       /**
     * @Column(type="string",length=50, nullable=true)
     */
    protected $viewed_at;


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set notiId.
     *
     * @param int $notiId
     *
     * @return ViewedNotiBySt
     */
    public function setNotiId($notiId)
    {
        $this->noti_id = $notiId;

        return $this;
    }

    /**
     * Get notiId.
     *
     * @return int
     */
    public function getNotiId()
    {
        return $this->noti_id;
    }

    /**
     * Set byUsername.
     *
     * @param string|null $byUsername
     *
     * @return ViewedNotiBySt
     */
    public function setByUsername($byUsername = null)
    {
        $this->by_username = $byUsername;

        return $this;
    }

    /**
     * Get byUsername.
     *
     * @return string|null
     */
    public function getByUsername()
    {
        return $this->by_username;
    }

    /**
     * Set viewedAt.
     *
     * @param \DateTime $viewedAt
     *
     * @return ViewedNotiBySt
     */
    public function setViewedAt($viewedAt)
    {
        $this->viewed_at = $viewedAt;

        return $this;
    }

    /**
     * Get viewedAt.
     *
     * @return \DateTime
     */
    public function getViewedAt()
    {
        return $this->viewed_at;
    }
}
